/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.jmx;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.jmx.IJMXDataView;
import com.wily.introscope.agent.jmx.JMXClamp;
import com.wily.introscope.agent.jmx.JMXDataUnavailableException;
import com.wily.introscope.agent.stat.AccumulatorAlreadyExistsException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.transformer.dynamic.IOverheadListener;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.introscope.spec.metric.BadlyFormedNameException;
import com.wily.introscope.spec.metric.ConflictingTypesException;
import com.wily.util.feedback.Module;
import java.util.Random;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServer;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public abstract class AJMXDataView
implements IJMXDataView,
IOverheadListener {
    private String fSourceAttribute;
    private ObjectName fSourceObjectName;
    private MBeanServer fServer;
    private int fNumConsecutiveExceptionsEncountered;
    private IAgent fAgent;
    private long fAverageTime = 0L;
    private long fLastTime = 0L;
    private long fPollCount = 0L;
    private long fExceptions = 0L;
    private long fSuccessfulPollCount = 0L;
    private long fCurrentFailedPollCount = 0L;
    private long fStartTime = 0L;
    private Object fAttKey;
    private static long fMaxPollRepeat = 8L;
    private long fNumberOfTimesWeSeeRepeatValue = 0L;
    private long fNumberOfTimesSkippedOnRepeat = 0L;
    private long fNumberOfSkipIntervals = 0L;
    private boolean fLastPollSkipped = false;
    static final int kMaxAllowableExceptionCount = 2;

    protected long setSawSameValue() {
        if (this.fNumberOfTimesWeSeeRepeatValue < fMaxPollRepeat) {
            ++this.fNumberOfTimesWeSeeRepeatValue;
        }
        return this.fNumberOfTimesWeSeeRepeatValue;
    }

    protected void resetSawSameValue() {
        this.fNumberOfTimesWeSeeRepeatValue = 0L;
        this.fNumberOfSkipIntervals = 0L;
    }

    protected long getSawSameValue() {
        return this.fNumberOfTimesWeSeeRepeatValue;
    }

    protected boolean seenSameValueMaxTimes() {
        return this.fNumberOfTimesWeSeeRepeatValue == fMaxPollRepeat;
    }

    protected AJMXDataView(IAgent agent, ObjectName on, MBeanServer server, String attributeName, Object attKey) {
        this.fAgent = agent;
        this.fSourceAttribute = attributeName;
        this.fServer = server;
        this.fSourceObjectName = on;
        this.fNumConsecutiveExceptionsEncountered = 0;
        OverheadAdministrator.registerOverheadControlSubscriber((IOverheadListener)this);
    }

    protected ObjectName getSourceObjectName() {
        return this.fSourceObjectName;
    }

    protected MBeanServer getSourceServer() {
        return this.fServer;
    }

    protected String getSourceAttribute() {
        return this.fSourceAttribute;
    }

    protected IAgent getAgent() {
        return this.fAgent;
    }

    protected Object getAttKey() {
        return this.fAttKey;
    }

    protected void clearExceptionCount() {
        this.fNumConsecutiveExceptionsEncountered = 0;
    }

    protected void incrementExceptionCount() {
        ++this.fNumConsecutiveExceptionsEncountered;
    }

    protected void throwIfExceptionCountIsExcessive() throws JMXDataUnavailableException {
        if (this.fNumConsecutiveExceptionsEncountered >= 2) {
            throw new JMXDataUnavailableException(this.fSourceObjectName, this.fSourceAttribute);
        }
    }

    @Override
    public final void IJMXDataView_destroy() {
        this.fSourceAttribute = null;
        this.fServer = null;
        this.fSourceObjectName = null;
        this.doDestroy();
    }

    @Override
    public final void IJMXDataView_clear() {
        this.doDestroy();
    }

    @Override
    public boolean IJMXDataView_update() throws AttributeNotFoundException, InstanceNotFoundException, MBeanException, ReflectionException, BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        ++this.fPollCount;
        this.fStartTime = System.currentTimeMillis();
        IDataAccumulator accum = this.getAccumulator();
        if (!this.isVirtual() && accum != null && this.fAgent.IAgent_isMetricShutOff(accum.IDataAccumulator_getMetric())) {
            this.fLastTime = 0L;
            return true;
        }
        if (this.seenSameValueMaxTimes()) {
            if (0L == this.fNumberOfSkipIntervals) {
                Random rand = new Random();
                this.fNumberOfSkipIntervals = Math.abs(rand.nextLong() % (fMaxPollRepeat / 2L)) + 1L;
            }
            ++this.fNumberOfTimesSkippedOnRepeat;
            if (this.fNumberOfTimesSkippedOnRepeat < this.fNumberOfSkipIntervals) {
                this.fLastPollSkipped = true;
                return true;
            }
            if (this.fNumberOfSkipIntervals < fMaxPollRepeat) {
                ++this.fNumberOfSkipIntervals;
            }
            this.fLastPollSkipped = false;
            this.fNumberOfTimesSkippedOnRepeat = 0L;
        }
        Throwable propagateError = null;
        Object objectValue = null;
        try {
            objectValue = this.getValue();
            if (objectValue != null) {
                this.doUpdate(objectValue);
                ++this.fSuccessfulPollCount;
            } else {
                ++this.fCurrentFailedPollCount;
            }
        }
        catch (Throwable t) {
            propagateError = t;
        }
        long endTime = System.currentTimeMillis();
        this.fLastTime = endTime - this.fStartTime;
        this.fAverageTime = this.fAverageTime > 0L ? (this.fAverageTime + this.fLastTime) / 2L : this.fLastTime;
        if (propagateError != null) {
            throw new Error(propagateError);
        }
        return objectValue != null;
    }

    protected Object getValue() throws Exception {
        Object objectValue = null;
        if (this.getSourceServer() != null && this.getSourceObjectName() != null && this.getSourceAttribute() != null) {
            objectValue = this.getSourceServer().getAttribute(this.getSourceObjectName(), this.getSourceAttribute());
        }
        return objectValue;
    }

    protected boolean isVirtual() {
        return false;
    }

    protected abstract void doDestroy();

    protected IDataAccumulator getAccumulator() throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException {
        return this.getAccumulator(false);
    }

    protected abstract IDataAccumulator getAccumulator(boolean var1) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException;

    protected abstract void doUpdate(Object var1) throws BadlyFormedNameException, ConflictingTypesException, AccumulatorAlreadyExistsException;

    public String toString() {
        String fullClassName = this.getClass().getName();
        int lastDotIndex = fullClassName.lastIndexOf(46);
        String simpleName = fullClassName.substring(lastDotIndex + 1);
        return "[" + simpleName + ": attr=" + this.fSourceAttribute.toString() + "]";
    }

    @Override
    public long getLastPollTime() {
        return this.fLastTime;
    }

    @Override
    public long getAveragePollTime() {
        return this.fAverageTime;
    }

    @Override
    public long getPollCount() {
        return this.fPollCount;
    }

    @Override
    public long getSuccessfulPollCount() {
        return this.fSuccessfulPollCount;
    }

    public void addSuccessfulPollCount(long count) {
        this.fSuccessfulPollCount += count;
    }

    public void addCurrentFailedPollCount(long count) {
        this.fCurrentFailedPollCount += count;
    }

    @Override
    public long getLastPollTimeStart() {
        return this.fStartTime;
    }

    @Override
    public long getRepeatedValuePollCount() {
        return this.getSawSameValue();
    }

    @Override
    public boolean wasLastPollSkipped() {
        return this.fLastPollSkipped;
    }

    void debugTrace(Module module, String string) {
        this.fAgent.IAgent_getModuleFeedback().debug(module, string);
    }

    protected void decrementJMXClampMetricCounter() {
        JMXClamp.getInstance(this.fAgent).decrementMetricCounter();
    }

    public void setOverheadMode(OverheadMode mode) {
        if (mode == OverheadMode.ABSOLUTE_LOW) {
            this.doDestroy();
        }
    }

    public OverheadMode getCurrentOverheadMode() {
        return null;
    }
}

