/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.file;

import com.wily.util.file.FileUtils;
import com.wily.util.file.PropertyFileUtils;
import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.util.Enumeration;
import java.util.Properties;

public abstract class APropertyFile {
    private File fFile;
    private String fRelease;
    private Properties fCurrentProps;
    private Properties fOrigProps;
    private Properties fPropsToEdit;
    private Properties fPropsToInsert;
    private Properties fPropsToAppend;
    private String fAppendComment;
    protected String paddingSpace = "";

    public APropertyFile(String sourceStr) throws FileNotFoundException, IOException {
        this.fFile = new File(sourceStr);
        this.fOrigProps = PropertyFileUtils.convertFileToProperties(this.fFile);
        this.fCurrentProps = PropertyFileUtils.convertFileToProperties(this.fFile);
        this.fPropsToEdit = new Properties();
        this.fPropsToInsert = new Properties();
        this.fPropsToAppend = new Properties();
    }

    public String getRelease() {
        return this.fRelease;
    }

    public void setRelease(String release) {
        this.fRelease = release;
    }

    public String getContents() throws IOException {
        return FileUtils.convertFileToString(this.fFile);
    }

    public void setContents(String text) throws IOException {
        FileUtils.convertStringToFile(text, this.fFile);
        this.fCurrentProps = PropertyFileUtils.convertFileToProperties(this.fFile);
    }

    public Properties getCurrentProps() {
        return this.fCurrentProps;
    }

    public Properties getOrigProps() {
        return this.fOrigProps;
    }

    public String getAppendComment() {
        return this.fAppendComment;
    }

    public void setAppendComment(String comment) {
        this.fAppendComment = comment;
    }

    public void editProps(Properties propTable) throws IOException {
        Enumeration<?> editEnum = propTable.propertyNames();
        while (editEnum.hasMoreElements()) {
            String name = editEnum.nextElement().toString();
            String value = propTable.getProperty(name);
            PropertyFileUtils.editPropertyInFile(this.fFile, name, value, this.paddingSpace);
            this.fCurrentProps.put(name, value);
        }
    }

    public void appendProps(Properties propsToAppend) throws IOException {
        if (propsToAppend.size() > 0) {
            Enumeration<?> propEnum = propsToAppend.propertyNames();
            while (propEnum.hasMoreElements()) {
                String name = propEnum.nextElement().toString();
                String value = propsToAppend.getProperty(name);
                String escapedValue = value.replaceAll("\\\\", "\\\\\\\\");
                FileUtils.appendLineToFile(String.valueOf(name) + this.paddingSpace + "=" + this.paddingSpace + escapedValue, this.fFile);
                this.fCurrentProps.put(name, value);
            }
        }
    }

    public void appendProps(Properties propsToAppend, String comment) throws IOException {
        if (propsToAppend.size() > 0) {
            FileUtils.appendNewLineToFile(this.fFile);
            if (comment != null && !comment.equals("")) {
                FileUtils.appendLineToFile("#" + comment, this.fFile);
            }
            this.appendProps(propsToAppend);
        }
    }

    public void insertProps(Properties propsToInsert) throws IOException {
        if (propsToInsert.size() > 0) {
            Enumeration<?> propEnum = propsToInsert.propertyNames();
            while (propEnum.hasMoreElements()) {
                String name = propEnum.nextElement().toString();
                String value = propsToInsert.getProperty(name);
                String escapedValue = value.replaceAll("\\\\", "\\\\\\\\");
                PropertyFileUtils.insertPropertyToFile(this.fFile, name, escapedValue, this.paddingSpace);
                this.fCurrentProps.put(name, value);
            }
        }
    }

    public void importProps(APropertyFile fileToImport, APropertyFile blacklist) {
        StringBuffer buf = new StringBuffer();
        Properties sourceProps = fileToImport.getCurrentProps();
        Properties blackProps = blacklist.getCurrentProps();
        buf.append("Source table - pre transform:");
        buf.append(PropertyFileUtils.convertPropertiesToString(sourceProps));
        buf.append("\n\nBlacklist table - pre transform:");
        buf.append(PropertyFileUtils.convertPropertiesToString(blackProps));
        this.transformProps(fileToImport, blacklist);
        buf.append("Source table - post transform:");
        buf.append(PropertyFileUtils.convertPropertiesToString(sourceProps));
        buf.append("\n\nBlacklist table - post transform:");
        buf.append(PropertyFileUtils.convertPropertiesToString(blackProps));
        this.buildPropChangeTables(sourceProps, blackProps);
        buf.append("Edit table:");
        buf.append(PropertyFileUtils.convertPropertiesToString(this.fPropsToEdit));
        buf.append("\n\nInsert table:");
        buf.append(PropertyFileUtils.convertPropertiesToString(this.fPropsToInsert));
        buf.append("\n\nAppend table:");
        buf.append(PropertyFileUtils.convertPropertiesToString(this.fPropsToAppend));
        System.out.println(buf.toString());
        try {
            this.editProps(this.fPropsToEdit);
            this.insertProps(this.fPropsToInsert);
            this.appendProps(this.fPropsToAppend, this.fAppendComment);
        }
        catch (IOException ioe) {
            ioe.printStackTrace();
        }
    }

    private void buildPropChangeTables(Properties srcProps, Properties blackProps) {
        Enumeration<?> srcEnum = srcProps.propertyNames();
        while (srcEnum.hasMoreElements()) {
            String srcKey = srcEnum.nextElement().toString();
            if (PropertyFileUtils.propertyExistsInTable(srcKey, blackProps)) continue;
            String srcVal = srcProps.getProperty(srcKey);
            if (PropertyFileUtils.propertyExistsInTable(srcKey, this.fCurrentProps)) {
                String currVal = PropertyFileUtils.getPropertyValue(srcKey, this.fCurrentProps);
                if (srcVal.intern().equalsIgnoreCase(currVal.intern())) continue;
                this.fPropsToEdit.setProperty(srcKey, srcVal);
                continue;
            }
            if (PropertyFileUtils.propertyShouldBeInsertedToFile(srcKey, this.fFile)) {
                this.fPropsToInsert.setProperty(srcKey, srcVal);
                continue;
            }
            this.fPropsToAppend.setProperty(srcKey, srcVal);
        }
    }

    public abstract void transformProps(APropertyFile var1, APropertyFile var2);
}

