#!/usr/bin/env bash
# START OF USAGE
# This script generates the value for the -javaagent directive to your java process
#
# Add a variable JAVA_AGENT to your script, that starts your java process, to store the generated value from this script (example shown below)
#     In bash and compatible shells:
#         JAVA_AGENT=$(path-to/agent-location.sh)
#     In csh, tcsh and compatible shells:
#         set JAVA_AGENT=`path-to/agent-location.sh`
#
# Then, use this variable against the -javaagent directive in your command that starts your java process (shown below)
#     <initial part of the command> -javaagent:"$JAVA_AGENT" <rest of the command>
#
# NOTE: The variable needs to be declared before it is used
#
#
# END OF USAGE
#
#
#
#
#
# Absolute path to this script, e.g. /home/user/bin/agent.location
SCRIPT=$(readlink -f "$0")
# Absolute path this script is in, thus /home/user/bin
SCRIPT_DIR=$(dirname "$SCRIPT")
# Get release version
RELEASE=$(cat "$SCRIPT_DIR"/agent.release)
#Generate release dir
RELEASE_DIR="$SCRIPT_DIR""/releases/""$RELEASE"
#Generate java agent string
echo "$RELEASE_DIR""/Agent.jar"" -Dcom.wily.introscope.agentProfile=""$RELEASE_DIR""/core/config/IntroscopeAgent.profile"" -Dintroscope.agent.bootstrap.home=""$SCRIPT_DIR"" -Dintroscope.agent.bootstrap.release.version=""$RELEASE"" -Dintroscope.agent.bootstrap.version.loaded=""$RELEASE"