/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import java.awt.Color;
import java.util.Vector;

public class ColorSeriesFactory {
    private static final float kHueSimilarityThreshold = 0.5f;
    private static final float kSaturationSimilarityThreshold = 0.2f;
    private static final float kBrightnessSimilarityThreshold = 0.1f;

    public static Color[] createColorSeries(int numHues, float[] allowedBrightnesses, float[] allowedSaturations, Color[] dangerousColors) {
        Vector<Color> useableColors = new Vector<Color>();
        float hueStep = 1.0f / (float)(numHues + 1);
        for (int i = 0; i < allowedBrightnesses.length; ++i) {
            for (int j = 0; j < allowedSaturations.length; ++j) {
                for (int k = 0; k < numHues; ++k) {
                    Color candidateColor = Color.getHSBColor((float)k * hueStep, allowedSaturations[j], allowedBrightnesses[i]);
                    if (ColorSeriesFactory.similarToDangerousColors(candidateColor, dangerousColors)) continue;
                    useableColors.add(candidateColor);
                }
            }
        }
        Color[] colors = new Color[useableColors.size()];
        for (int i = 0; i < colors.length; ++i) {
            colors[i] = (Color)useableColors.elementAt(i);
        }
        return colors;
    }

    private static boolean similarToDangerousColors(Color color, Color[] dangerousColors) {
        boolean similarToDangerousColor = false;
        for (int i = 0; i < dangerousColors.length && !similarToDangerousColor; ++i) {
            similarToDangerousColor = ColorSeriesFactory.colorsAreSimilar(color, dangerousColors[i]);
        }
        return similarToDangerousColor;
    }

    private static boolean colorsAreSimilar(Color color1, Color color2) {
        float[] color2HSB;
        float[] color1HSB = Color.RGBtoHSB(color1.getRed(), color1.getGreen(), color1.getBlue(), null);
        return Math.abs(color1HSB[0] - (color2HSB = Color.RGBtoHSB(color2.getRed(), color2.getGreen(), color2.getBlue(), null))[0]) < 0.5f && Math.abs(color1HSB[1] - color2HSB[1]) < 0.2f && Math.abs(color1HSB[2] - color2HSB[2]) < 0.1f;
    }
}

