/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.swing.ExtendedJLabel;
import java.awt.Container;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.util.Hashtable;
import javax.swing.JPanel;
import javax.swing.JTextField;

public class ListOfLabeledEditTextFieldsPanel
extends JPanel {
    private static final long serialVersionUID = 7264030880093603011L;
    private ExtendedJLabel[] fLabels;
    private JTextField[] fTextFields;
    private static final String kStateSavePrefix = "ListOfLabeledEditTextFieldsPanel_State_";

    public ListOfLabeledEditTextFieldsPanel(String[] names) {
        GridBagLayout gridbag = new GridBagLayout();
        this.setLayout(gridbag);
        int listSize = names.length;
        this.fLabels = new ExtendedJLabel[listSize];
        this.fTextFields = new JTextField[listSize];
        for (int x = 0; x < listSize; ++x) {
            this.fLabels[x] = new ExtendedJLabel(names[x]);
            this.fTextFields[x] = new JTextField();
        }
        this.addLabelTextRows(this.fLabels, this.fTextFields, gridbag, this);
    }

    public JTextField getTextFieldAtIndex(int index) {
        return this.fTextFields[index];
    }

    private void addLabelTextRows(ExtendedJLabel[] labels, JTextField[] textFields, GridBagLayout gridbag, Container container) {
        GridBagConstraints c = new GridBagConstraints();
        c.anchor = 13;
        int numLabels = labels.length;
        for (int i = 0; i < numLabels; ++i) {
            c.gridwidth = -1;
            c.fill = 0;
            c.weightx = 0.0;
            gridbag.setConstraints(labels[i], c);
            container.add(labels[i]);
            c.gridwidth = 0;
            c.fill = 2;
            c.weightx = 1.0;
            gridbag.setConstraints(textFields[i], c);
            container.add(textFields[i]);
        }
    }

    public void IStateSaver_saveState(Hashtable stateContainer, String keyPrefix) {
        for (int x = 0; x < this.fTextFields.length; ++x) {
            stateContainer.put(keyPrefix + kStateSavePrefix + x, this.getTextFieldAtIndex(x).getText());
        }
    }

    public void IStateSaver_restoreState(Hashtable stateContainer, String keyPrefix) {
        for (int x = 0; x < this.fTextFields.length; ++x) {
            this.getTextFieldAtIndex(x).setText((String)stateContainer.get(keyPrefix + kStateSavePrefix + x));
        }
    }
}

