/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.backend.jms.nameformatter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.INameFormatter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.backend.jms.helper.JMSHelper;
import com.wily.introscope.agent.trace.backend.jms.helper.PatternMatcherHandler;
import com.wily.introscope.agent.trace.backendprotocols.BackendProtocolsConstants;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.util.concurrent.atomic.AtomicReference;

public class JMSNameFormatter
implements INameFormatter,
BackendProtocolsConstants {
    public static final String[] PLACEHOLDERS = new String[]{"{jmsdestinationtype}", "{destinationname}"};
    public static final int PLACEHOLDER_DESTINATION_TYPE = 0;
    public static final int PLACEHOLDER_DESTINATION_NAME = 1;
    protected static IModuleFeedbackChannel feedback;
    private static final AtomicReference<PatternMatcherHandler> patternMatcherHandlerHolder;
    private static final Module ModuleName;
    private static ThreadLocal NameFormatterBuilder;

    static {
        patternMatcherHandlerHolder = new AtomicReference();
        ModuleName = new Module("JMSNameFormatter");
        NameFormatterBuilder = new ThreadLocal(){

            protected Object initialValue() {
                return new StringBuilder();
            }
        };
    }

    private static void setDestinationNamePatternSettings(IAgent agent) {
        if (patternMatcherHandlerHolder.get() == null) {
            patternMatcherHandlerHolder.compareAndSet(null, new PatternMatcherHandler(agent));
        }
    }

    public JMSNameFormatter(IAgent agent) {
        feedback = agent.IAgent_getModuleFeedback();
        JMSNameFormatter.setDestinationNamePatternSettings(agent);
    }

    public String INameFormatter_format(String name, InvocationData data) {
        String result = null;
        if (name != null) {
            try {
                StringBuilder metricBldr = (StringBuilder)NameFormatterBuilder.get();
                metricBldr.replace(0, metricBldr.length(), name);
                int placeholder = 0;
                while (placeholder < PLACEHOLDERS.length) {
                    int index = metricBldr.indexOf(PLACEHOLDERS[placeholder]);
                    if (index >= 0) {
                        switch (placeholder) {
                            case 0: {
                                String destinationType = this.resolveDestinationType(data);
                                metricBldr = this.replaceAll(metricBldr, PLACEHOLDERS[placeholder], destinationType);
                                break;
                            }
                            case 1: {
                                String destinationName = this.resolveDestinationName(data);
                                metricBldr = this.replaceAll(metricBldr, PLACEHOLDERS[placeholder], destinationName);
                                break;
                            }
                            default: {
                                feedback.warn(JMSHelper.module, "An unknown name formatter placeholder requested:" + placeholder);
                            }
                        }
                    }
                    ++placeholder;
                }
                result = metricBldr.toString();
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    feedback.error("An error occurred formatting jms client metric name" + t.getMessage());
                    feedback.verbose(t);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }
        if (result == null) {
            ProbeIdentification probeIdentification = data.getProbeInformation().getProbeIdentification();
            String s = String.valueOf(probeIdentification.getProbeClassName()) + "|" + probeIdentification.getProbeMethodName();
            feedback.debug("JMS Name Formatter returned null. So, using the default resource name : " + s);
            return s;
        }
        return result;
    }

    protected StringBuilder replaceAll(StringBuilder builder, String source, String dest) {
        if (builder != null && dest != null) {
            int index = builder.indexOf(source);
            while (index != -1) {
                builder.replace(index, index + source.length(), dest);
                index += dest.length();
                index = builder.indexOf(source, index);
            }
        }
        return builder;
    }

    protected String resolveDestinationName(InvocationData data) {
        String destinationName = (String)data.get("Jms.Destination.Key");
        String destinationType = (String)data.get("jms.destination.type");
        if (destinationName == null) {
            Object destination = this.getJMSDestination(data);
            destinationName = destination != null ? JMSNameFormatter.checkTempDestAndReturn(data, destination, destinationType) : "Unknown";
        }
        boolean isMessageIBMMQSpecific = false;
        if (data != null) {
            String probeClassName;
            ProbeIdentification probe = data.getProbeInformation() != null ? data.getProbeInformation().getProbeIdentification() : null;
            String string = probeClassName = probe != null ? probe.getProbeClassName() : null;
            if (probeClassName != null && (probeClassName.contains("com.ibm.mq.jms") || probeClassName.contains("com.ibm.msg.client.jms.internal"))) {
                isMessageIBMMQSpecific = true;
            }
        }
        if (isMessageIBMMQSpecific && destinationName != null && !destinationName.equals("Unknown")) {
            destinationName = this.getAndAppendQueueManagerNameToDestination(data, destinationName, destinationType);
        }
        return destinationName;
    }

    protected String getAndAppendQueueManagerNameToDestination(InvocationData data, String destinationObjectName, String destinationType) {
        String destinationName = destinationObjectName;
        String queueManagerName = JMSHelper.getQueueManagerWithHostname(data, feedback, destinationType);
        if (destinationObjectName != null && queueManagerName != null && !queueManagerName.equals("Unknown")) {
            if (destinationType.equals("Queues")) {
                destinationName = destinationObjectName != null ? destinationObjectName.replace("queue_", "").replaceAll("/", "") : destinationObjectName;
            } else if (destinationType.equals("Topics")) {
                destinationName = destinationObjectName != null ? destinationObjectName.replace("topic_", "").replaceAll("/", "") : destinationObjectName;
            }
        }
        return destinationName;
    }

    public static String checkTempDestAndReturn(InvocationData data, Object destination, String destinationType) {
        boolean isTemp = false;
        boolean isTopic = false;
        boolean isQueue = false;
        String destinationName = "Unknown";
        if ("Queues".equals(destinationType)) {
            isQueue = true;
        } else if ("Topics".equals(destinationType)) {
            isTopic = true;
        }
        boolean shouldPerformTempDestCheck = true;
        PatternMatcherHandler handler = patternMatcherHandlerHolder.get();
        if (handler != null) {
            shouldPerformTempDestCheck = handler.shouldPerformInstanceofCheckForTempDest();
        }
        if (shouldPerformTempDestCheck && JMSHelper.isTempDestination(destination, feedback)) {
            JMSHelper.debug(ModuleName, "The destination being used is an instance of TemporaryQueue/TemporaryTopic");
            if (isQueue) {
                destinationName = "Temporary Queues";
            } else if (isTopic) {
                destinationName = "Temporary Topics";
            }
            isTemp = true;
        } else if (isQueue) {
            destinationName = JMSHelper.substituteMetricSeparatorChars(JMSHelper.getQueueName(destination, feedback));
        } else if (isTopic) {
            destinationName = JMSHelper.substituteMetricSeparatorChars(JMSHelper.getTopicName(destination, feedback));
        }
        if (!isTemp && !destinationName.equals("Unknown") && JMSNameFormatter.matchesPattern(destinationName)) {
            if (isQueue) {
                destinationName = "Temporary Queues";
            } else if (isTopic) {
                destinationName = "Temporary Topics";
            }
        }
        data.put("Jms.Destination.Key", (Object)destinationName);
        return destinationName;
    }

    private static boolean matchesPattern(String destinationName) {
        PatternMatcherHandler handler = patternMatcherHandlerHolder.get();
        if (handler != null) {
            return handler.matches(destinationName);
        }
        return false;
    }

    protected Object getJMSDestination(InvocationData data) {
        Object destination = JMSHelper.getDestination(data, feedback);
        return destination;
    }

    protected String resolveDestinationType(InvocationData data) {
        String destinationType = (String)data.get("jms.destination.type");
        boolean isMessageIBMMQSpecific = false;
        if (data != null) {
            String probeClassName;
            ProbeIdentification probe = data.getProbeInformation() != null ? data.getProbeInformation().getProbeIdentification() : null;
            String string = probeClassName = probe != null ? probe.getProbeClassName() : null;
            if (probeClassName != null && (probeClassName.contains("com.ibm.mq.jms") || probeClassName.contains("com.ibm.msg.client.jms.internal"))) {
                isMessageIBMMQSpecific = true;
            }
        }
        if (!isMessageIBMMQSpecific && destinationType != null) {
            return destinationType;
        }
        if (destinationType == null) {
            destinationType = "Unknown";
            Object destination = this.getJMSDestination(data);
            destinationType = JMSHelper.getDestinationType(destination, feedback, data);
        }
        if (isMessageIBMMQSpecific && destinationType != null && !destinationType.equals("Unknown")) {
            destinationType = JMSHelper.getQueueManagerWithHostname(data, feedback, destinationType);
        }
        return destinationType;
    }
}

