/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.IBlameStack;
import com.wily.introscope.agent.sqlagent.DatabaseNameFormatter;
import com.wily.introscope.agent.sqlagent.SQLAgentConfiguration;
import com.wily.introscope.agent.trace.BlamePointTracer;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.properties.AttributeListing;
import java.util.HashMap;
import java.util.Map;

public class ExecuteCommandTracer
extends BlamePointTracer {
    private static final Map sTTKeyLookup = new HashMap();
    private final SQLAgentConfiguration fConfiguration;

    static {
        sTTKeyLookup.put("Dynamic", "Dynamic SQL");
        sTTKeyLookup.put("Prepared", "Prepared SQL");
        sTTKeyLookup.put("Stored Procedures", "Stored Procedure SQL");
        sTTKeyLookup.put("Table Access", "Database Table");
    }

    public ExecuteCommandTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.fConfiguration = SQLAgentConfiguration.getInstance(agent);
    }

    protected void addComponentToBlameStack(String component, InvocationData data) {
        if (this.fConfiguration.shouldParticipateInBlame()) {
            String sqlType = this.getTTKey(data);
            String sql = DatabaseNameFormatter.getNormalizedSQLForUserView(this.getModuleFeedback(), data, this.fConfiguration.getNormalizedMaxSQLLength());
            ComponentTracer componentTracer = this.getComponentTracer();
            IBlameStack stack = data.getStack(componentTracer, true);
            componentTracer.addComponent(stack, component, sqlType, sql);
        }
    }

    private String getTTKey(InvocationData data) {
        String commandType = DatabaseNameFormatter.getCommandType();
        String key = (String)sTTKeyLookup.get(commandType);
        if (key == null) {
            key = "SQL";
        }
        return key;
    }

    protected void removeComponentFromBlameStack(String component, InvocationData data) {
        if (this.fConfiguration.shouldParticipateInBlame()) {
            ComponentTracer componentTracer = this.getComponentTracer();
            IBlameStack stack = data.getStack(componentTracer, false);
            componentTracer.removeComponent(stack, component);
        }
    }
}

