/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.atc;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.ca.apm.agent.jmxclient.api.JmxPollingEventListener;
import com.ca.apm.agent.jmxclient.api.TaskExecutor;
import com.ca.apm.agent.jmxclient.atc.AtcConnectionManager;
import com.wily.introscope.agent.trace.intelligent.Logger;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.TimeUnit;

public class JmxAtcService
implements JmxPollingEventListener {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private final AtcConnectionManager atcManager;
    private final TaskExecutor executor;
    private volatile ScheduledFuture<?> task;
    private final Map<JmxNodeInfo, Boolean> activeNodes = new ConcurrentHashMap<JmxNodeInfo, Boolean>();

    public JmxAtcService(TaskExecutor executor) {
        this.atcManager = new AtcConnectionManager();
        this.atcManager.registerWithServer();
        this.executor = executor;
    }

    private ScheduledFuture<?> configureATCGraphService(TaskExecutor executor) {
        LOGGER.logDebugMessage("Starting JMX ATC Service");
        return executor.scheduleAtFixedRate(new Runnable(){

            @Override
            public void run() {
                Set<JmxNodeInfo> nodes = JmxAtcService.this.activeNodes.keySet();
                if (nodes.size() > 0) {
                    JmxAtcService.this.atcManager.generateAndSendATCData(nodes);
                }
            }
        }, 15000L, Configuration.getGraphSyncServiceInterval(), TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void notifyOnPollingStart(JmxNodeInfo node) {
        this.activeNodes.put(node, Boolean.TRUE);
        if (this.task == null) {
            this.task = this.configureATCGraphService(this.executor);
        }
    }

    @Override
    public synchronized void notifyOnPollingStop(JmxNodeInfo node) {
        this.activeNodes.remove(node);
        if (this.activeNodes.isEmpty() && this.task != null && this.task.cancel(false)) {
            this.task = null;
        }
    }
}

