/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing.table.highlighting;

import com.wily.ui.swing.table.TooltipSavyJTable;
import com.wily.ui.swing.table.highlighting.AHighlighter;
import com.wily.ui.swing.table.highlighting.AHighlighterCreator;
import com.wily.ui.swing.table.highlighting.DefaultHighlightingTooltipSavvyTableCellRenderer;
import com.wily.ui.swing.table.highlighting.HighlighterCreatorFactory;
import com.wily.ui.swing.table.highlighting.HighlightingTableCellRenderer;
import com.wily.ui.swing.table.highlighting.IContextMenuProvider;
import com.wily.ui.swing.table.highlighting.TableStripingHighlighter;
import com.wily.util.HashCodeUtils;
import java.awt.Color;
import java.awt.Component;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.text.DateFormat;
import java.text.NumberFormat;
import java.util.ArrayList;
import java.util.Date;
import java.util.Hashtable;
import java.util.Iterator;
import java.util.Vector;
import javax.swing.AbstractAction;
import javax.swing.Action;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.JCheckBox;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;
import javax.swing.JSeparator;
import javax.swing.JTable;
import javax.swing.ListSelectionModel;
import javax.swing.UIDefaults;
import javax.swing.table.TableCellRenderer;
import javax.swing.table.TableColumnModel;
import javax.swing.table.TableModel;

public class HighlightingTooltipSavvyJTable
extends TooltipSavyJTable {
    private static final long serialVersionUID = 1L;
    private static AHighlighter sDefaultTableStripingHighlighter;
    protected ArrayList fNonEditableHighlighterList;
    protected ArrayList fHighlighterList;
    protected ArrayList fHighlighterCreatorActionFactoriesList;
    protected ArrayList fContextMenuProviders;
    protected ArrayList fColorList;
    protected ArrayList fUsedColorList;
    private HighlightingTooltipSavyJTableMouseListener fMouseListener;
    private boolean fSelectOnRightClick = true;

    public HighlightingTooltipSavvyJTable() {
        this.initialize();
    }

    public HighlightingTooltipSavvyJTable(TableModel dm) {
        super(dm);
        this.initialize();
    }

    public HighlightingTooltipSavvyJTable(TableModel dm, TableColumnModel cm) {
        super(dm, cm);
        this.initialize();
    }

    public HighlightingTooltipSavvyJTable(TableModel dm, TableColumnModel cm, ListSelectionModel sm) {
        super(dm, cm, sm);
        this.initialize();
    }

    public HighlightingTooltipSavvyJTable(int numRows, int numColumns) {
        super(numRows, numColumns);
        this.initialize();
    }

    public HighlightingTooltipSavvyJTable(Object[][] rowData, Object[] columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    public HighlightingTooltipSavvyJTable(Vector rowData, Vector columnNames) {
        super(rowData, columnNames);
        this.initialize();
    }

    protected void initialize() {
        if (sDefaultTableStripingHighlighter == null) {
            sDefaultTableStripingHighlighter = new TableStripingHighlighter(new Color(237, 243, 254), Color.black);
        }
        if (this.fNonEditableHighlighterList == null) {
            this.fNonEditableHighlighterList = new ArrayList();
        }
        if (this.fHighlighterList == null) {
            this.fHighlighterList = new ArrayList();
        }
        if (this.fHighlighterCreatorActionFactoriesList == null) {
            this.fHighlighterCreatorActionFactoriesList = new ArrayList();
        }
        if (this.fContextMenuProviders == null) {
            this.fContextMenuProviders = new ArrayList();
        }
        if (this.fColorList == null) {
            this.fColorList = new ArrayList();
        }
        if (this.fUsedColorList == null) {
            this.fUsedColorList = new ArrayList();
        }
        if (this.fMouseListener == null) {
            this.fMouseListener = new HighlightingTooltipSavyJTableMouseListener();
            this.addMouseListener(this.fMouseListener);
        }
        this.initializeColorPacks();
    }

    protected void initializeColorPacks() {
        Color[] backgroundColors = new Color[]{Color.blue, Color.cyan, Color.darkGray, Color.gray, Color.green, Color.lightGray, Color.magenta, Color.orange, Color.pink, Color.red, Color.yellow};
        Color[] foregroundColors = new Color[]{Color.white, Color.black, Color.white, Color.white, Color.white, Color.white, Color.white, Color.black, Color.black, Color.white, Color.black};
        for (int x = 0; x < backgroundColors.length; ++x) {
            this.fColorList.add(new ColorPack(backgroundColors[x], foregroundColors[x]));
        }
    }

    protected void createDefaultRenderers() {
        this.defaultRenderersByColumnClass = new UIDefaults();
        this.setLazyRenderer(Number.class, "com.wily.ui.swing.table.highlighting.HighlightingTooltipSavvyJTable$HighlightingTooltipSavvyNumberRenderer");
        this.setLazyRenderer(Float.class, "com.wily.ui.swing.table.highlighting.HighlightingTooltipSavvyJTable$HighlightingTooltipSavvyDoubleRenderer");
        this.setLazyRenderer(Double.class, "com.wily.ui.swing.table.highlighting.HighlightingTooltipSavvyJTable$HighlightingTooltipSavvyDoubleRenderer");
        this.setLazyRenderer(Date.class, "com.wily.ui.swing.table.highlighting.HighlightingTooltipSavvyJTable$HighlightingTooltipSavvyDateRenderer");
        this.setLazyRenderer(Icon.class, "com.wily.ui.swing.table.highlighting.HighlightingTooltipSavvyJTable$HighlightingTooltipSavvyIconRenderer");
        this.setLazyRenderer(ImageIcon.class, "com.wily.ui.swing.table.highlighting.HighlightingTooltipSavvyJTable$HighlightingTooltipSavvyIconRenderer");
        this.setLazyRenderer(Boolean.class, "com.wily.ui.swing.table.highlighting.HighlightingTooltipSavvyJTable$HighlightingTooltipSavvyBooleanRenderer");
        this.setDefaultRenderer(Object.class, (TableCellRenderer)new DefaultHighlightingTooltipSavvyTableCellRenderer());
    }

    public boolean getSelectOnRightClick() {
        return this.fSelectOnRightClick;
    }

    public void setSelectOnRightClick(boolean val) {
        this.fSelectOnRightClick = val;
    }

    public synchronized void addHighlighterCreatorActionFactory(HighlighterCreatorFactory factory) {
        if (!this.fHighlighterCreatorActionFactoriesList.contains(factory)) {
            this.fHighlighterCreatorActionFactoriesList.add(factory);
        }
    }

    public synchronized void removeHighlighterCreatorActionFactory(HighlighterCreatorFactory factory) {
        this.fHighlighterCreatorActionFactoriesList.remove(factory);
    }

    public synchronized void addNonEditableHighlighterCreatorActionFactory(AHighlighter highlighter) {
        if (!this.fNonEditableHighlighterList.contains(highlighter)) {
            this.fNonEditableHighlighterList.add(highlighter);
        }
    }

    public synchronized void removeNonEditableHighlighterCreatorActionFactory(AHighlighter highlighter) {
        this.fNonEditableHighlighterList.remove(highlighter);
    }

    public synchronized void addDefaultTableStripingHighlighter() {
        if (!this.fNonEditableHighlighterList.contains(sDefaultTableStripingHighlighter)) {
            this.fNonEditableHighlighterList.add(sDefaultTableStripingHighlighter);
        }
    }

    public synchronized void removeDefaultTableStripingHighlighter() {
        this.fNonEditableHighlighterList.remove(sDefaultTableStripingHighlighter);
    }

    public AHighlighter[] getHighlighters() {
        int x;
        AHighlighter[] editableHighlighters = this.fHighlighterList.toArray(new AHighlighter[0]);
        AHighlighter[] nonEditableHighlighters = this.fNonEditableHighlighterList.toArray(new AHighlighter[0]);
        AHighlighter[] allHighlighters = new AHighlighter[editableHighlighters.length + nonEditableHighlighters.length];
        for (x = 0; x < editableHighlighters.length; ++x) {
            allHighlighters[x] = editableHighlighters[x];
        }
        for (x = 0; x < nonEditableHighlighters.length; ++x) {
            allHighlighters[x + editableHighlighters.length] = nonEditableHighlighters[x];
        }
        return allHighlighters;
    }

    public AHighlighter[] getEditableHighlighters() {
        return this.fHighlighterList.toArray(new AHighlighter[0]);
    }

    public AHighlighter[] getNonEditableHighlighters() {
        return this.fNonEditableHighlighterList.toArray(new AHighlighter[0]);
    }

    public synchronized void addContextMenuProvider(IContextMenuProvider provider) {
        if (!this.fContextMenuProviders.contains(provider)) {
            this.fContextMenuProviders.add(provider);
        }
    }

    public synchronized void removeContextMenuProvider(IContextMenuProvider provider) {
        this.fContextMenuProviders.remove(provider);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeAllCurrentHighlighters() {
        HighlightingTooltipSavvyJTable highlightingTooltipSavvyJTable = this;
        synchronized (highlightingTooltipSavvyJTable) {
            while (this.fHighlighterList.size() != 0) {
                AHighlighter removedHighlighter = (AHighlighter)this.fHighlighterList.remove(0);
                this.fUsedColorList.remove(new ColorPack(removedHighlighter.getBackgroundColor(), removedHighlighter.getForegroundColor()));
            }
        }
        this.repaint();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addHighlighter(AHighlighter highlighter) {
        HighlightingTooltipSavvyJTable highlightingTooltipSavvyJTable = this;
        synchronized (highlightingTooltipSavvyJTable) {
            if (highlighter != null) {
                this.fHighlighterList.add(highlighter);
                this.fUsedColorList.add(new ColorPack(highlighter.getBackgroundColor(), highlighter.getForegroundColor()));
            }
        }
        this.repaint();
    }

    public synchronized ColorPack getFirstUnusedColorPack() {
        Iterator iterator = this.fColorList.iterator();
        while (iterator.hasNext()) {
            ColorPack colorPack = (ColorPack)iterator.next();
            if (this.fUsedColorList.contains(colorPack)) continue;
            return colorPack;
        }
        return null;
    }

    private void setLazyValue(Hashtable h, Class c, String s) {
        h.put(c, new UIDefaults.ProxyLazyValue(s));
    }

    private void setLazyRenderer(Class c, String s) {
        this.setLazyValue(this.defaultRenderersByColumnClass, c, s);
    }

    public void setDefaultRenderer(Class columnClass, TableCellRenderer renderer) {
        if (!(renderer instanceof HighlightingTableCellRenderer)) {
            throw new RuntimeException("renderer must be instance of HighlightingTableCellRenderer!");
        }
        super.setDefaultRenderer(columnClass, renderer);
    }

    public static class HighlightingTooltipSavvyBooleanRenderer
    extends JCheckBox
    implements HighlightingTableCellRenderer {
        private static final long serialVersionUID = 1196721431039880436L;

        public HighlightingTooltipSavvyBooleanRenderer() {
            this.setHorizontalAlignment(0);
        }

        public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
            if (isSelected) {
                this.setForeground(table.getSelectionForeground());
                super.setBackground(table.getSelectionBackground());
            } else {
                AHighlighter[] highlighters = ((HighlightingTooltipSavvyJTable)table).getHighlighters();
                boolean highlighterApplied = false;
                for (int x = 0; x < highlighters.length; ++x) {
                    AHighlighter highlighter = highlighters[x];
                    if (!highlighter.shouldHighlight(table, value, isSelected, hasFocus, row, column)) continue;
                    this.setBackground(highlighter.getBackgroundColor());
                    this.setForeground(highlighter.getForegroundColor());
                    highlighterApplied = true;
                    break;
                }
                if (!highlighterApplied) {
                    this.setBackground(table.getBackground());
                    this.setForeground(table.getForeground());
                }
            }
            this.setSelected(value != null && (Boolean)value != false);
            return this;
        }
    }

    public static class HighlightingTooltipSavvyIconRenderer
    extends DefaultHighlightingTooltipSavvyTableCellRenderer {
        private static final long serialVersionUID = -644470106073866156L;

        public HighlightingTooltipSavvyIconRenderer() {
            this.setHorizontalAlignment(0);
        }

        public void setValue(Object value) {
            this.setIcon(value instanceof Icon ? (Icon)value : null);
        }
    }

    public static class HighlightingTooltipSavvyDateRenderer
    extends DefaultHighlightingTooltipSavvyTableCellRenderer {
        private static final long serialVersionUID = -5458635691657214733L;
        DateFormat formatter;

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = DateFormat.getDateInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class HighlightingTooltipSavvyDoubleRenderer
    extends HighlightingTooltipSavvyNumberRenderer {
        private static final long serialVersionUID = 864431688401245998L;
        NumberFormat formatter;

        public void setValue(Object value) {
            if (this.formatter == null) {
                this.formatter = NumberFormat.getInstance();
            }
            this.setText(value == null ? "" : this.formatter.format(value));
        }
    }

    public static class HighlightingTooltipSavvyNumberRenderer
    extends DefaultHighlightingTooltipSavvyTableCellRenderer {
        private static final long serialVersionUID = 4799244703934553607L;

        public HighlightingTooltipSavvyNumberRenderer() {
            this.setHorizontalAlignment(4);
        }
    }

    public static class ColorPack {
        private Color fBackgroundColor;
        private Color fForegroundColor;

        public ColorPack(Color backgroundColor, Color foregroundColor) {
            this.fBackgroundColor = backgroundColor;
            this.fForegroundColor = foregroundColor;
        }

        public Color getBackgroundColor() {
            return this.fBackgroundColor;
        }

        public Color getForegroundColor() {
            return this.fForegroundColor;
        }

        public boolean equals(Object o) {
            ColorPack colorPack = (ColorPack)o;
            return colorPack.getBackgroundColor().equals(this.fBackgroundColor) && colorPack.getForegroundColor().equals(this.fForegroundColor);
        }

        public int hashCode() {
            return HashCodeUtils.accumulateHashCode(this.fBackgroundColor.hashCode(), this.fForegroundColor.hashCode());
        }
    }

    private class HighlighterCreatorAction
    extends AbstractAction {
        private static final long serialVersionUID = -1580717296728689979L;
        private AHighlighterCreator fHighlighterCreator;
        private ColorPack fColorPack;

        public HighlighterCreatorAction(AHighlighterCreator highlighterCreator, ColorPack colorPack) {
            super("     ");
            this.fHighlighterCreator = highlighterCreator;
            this.fColorPack = colorPack;
        }

        public HighlighterCreatorAction(AHighlighterCreator highlighterCreator, Color backgroundColor, Color foregroundColor) {
            super("     ");
            this.fHighlighterCreator = highlighterCreator;
            this.fColorPack = new ColorPack(backgroundColor, foregroundColor);
        }

        public void actionPerformed(ActionEvent e) {
            AHighlighter highlighter = this.fHighlighterCreator.createHighlighter(this.fColorPack.getBackgroundColor(), this.fColorPack.getForegroundColor());
            if (highlighter != null) {
                HighlightingTooltipSavvyJTable.this.fUsedColorList.add(this.fColorPack);
                HighlightingTooltipSavvyJTable.this.fHighlighterList.add(highlighter);
                HighlightingTooltipSavvyJTable.this.repaint();
            }
        }

        public Color getBackgroundColor() {
            return this.fColorPack.getBackgroundColor();
        }

        public Color getForegroundColor() {
            return this.fColorPack.getForegroundColor();
        }
    }

    private class MoveHighlighterAction
    extends AbstractAction {
        private static final long serialVersionUID = -7369306922592684610L;
        public static final int MOVE_DOWN = 0;
        public static final int MOVE_UP = 1;
        public static final int MOVE_LAST = 2;
        public static final int MOVE_FIRST = 3;
        private AHighlighter fHighlighter;
        private int fMoveType;

        public MoveHighlighterAction(AHighlighter highlighter, int moveType) {
            this.fHighlighter = highlighter;
            this.fMoveType = moveType;
            switch (this.fMoveType) {
                case 0: {
                    this.putValue("Name", "Move Highlighter Priority Down");
                    break;
                }
                case 1: {
                    this.putValue("Name", "Move Highlighter Priority Up");
                    break;
                }
                case 2: {
                    this.putValue("Name", "Move Highligther Priority To Last");
                    break;
                }
                case 3: {
                    this.putValue("Name", "Move Highligther Priority To First");
                }
            }
        }

        public void actionPerformed(ActionEvent e) {
            int highlighterIndex = HighlightingTooltipSavvyJTable.this.fHighlighterList.indexOf(this.fHighlighter);
            if (highlighterIndex > -1) {
                HighlightingTooltipSavvyJTable.this.fHighlighterList.remove(this.fHighlighter);
                switch (this.fMoveType) {
                    case 0: {
                        HighlightingTooltipSavvyJTable.this.fHighlighterList.add(highlighterIndex + 1, this.fHighlighter);
                        break;
                    }
                    case 1: {
                        HighlightingTooltipSavvyJTable.this.fHighlighterList.add(highlighterIndex - 1, this.fHighlighter);
                        break;
                    }
                    case 2: {
                        HighlightingTooltipSavvyJTable.this.fHighlighterList.add(this.fHighlighter);
                        break;
                    }
                    case 3: {
                        HighlightingTooltipSavvyJTable.this.fHighlighterList.add(0, this.fHighlighter);
                    }
                }
                HighlightingTooltipSavvyJTable.this.repaint();
            }
        }
    }

    private class RemoveHighlighterAction
    extends AbstractAction {
        private static final long serialVersionUID = 7781243675401701492L;
        private AHighlighter fHighlighter;

        public RemoveHighlighterAction(AHighlighter highlighter) {
            super("Remove highlighter");
            this.fHighlighter = highlighter;
        }

        public void actionPerformed(ActionEvent e) {
            HighlightingTooltipSavvyJTable.this.fHighlighterList.remove(this.fHighlighter);
            HighlightingTooltipSavvyJTable.this.fUsedColorList.remove(new ColorPack(this.fHighlighter.getBackgroundColor(), this.fHighlighter.getForegroundColor()));
            HighlightingTooltipSavvyJTable.this.repaint();
        }
    }

    private class RemoveAllHighlightersAction
    extends AbstractAction {
        private static final long serialVersionUID = -9015647974423075274L;

        public RemoveAllHighlightersAction() {
            super("Remove all highlighters");
        }

        public void actionPerformed(ActionEvent e) {
            HighlightingTooltipSavvyJTable.this.removeAllCurrentHighlighters();
        }
    }

    static class ColorizedJMenuItem
    extends JMenuItem {
        private static final long serialVersionUID = -8244346224641949962L;
        private Color fBackgroundColor;
        private Color fForegroundColor;

        public ColorizedJMenuItem(Color backgroundColor, Color foregroundColor) {
            super("     ");
            this.setBackground(backgroundColor);
            this.setForeground(foregroundColor);
            this.fBackgroundColor = backgroundColor;
            this.fForegroundColor = foregroundColor;
        }

        public ColorizedJMenuItem(ColorPack colorPack) {
            super("     ");
            this.setBackground(colorPack.getBackgroundColor());
            this.setForeground(colorPack.getForegroundColor());
            this.fBackgroundColor = colorPack.getBackgroundColor();
            this.fForegroundColor = colorPack.getForegroundColor();
        }

        public ColorizedJMenuItem(HighlighterCreatorAction highlighterCreatorAction) {
            super(highlighterCreatorAction);
            this.setBackground(highlighterCreatorAction.getBackgroundColor());
            this.setForeground(highlighterCreatorAction.getForegroundColor());
            this.fBackgroundColor = highlighterCreatorAction.getBackgroundColor();
            this.fForegroundColor = highlighterCreatorAction.getForegroundColor();
        }

        public Color getBackgroundColor() {
            return this.fBackgroundColor;
        }

        public Color getForegroundColor() {
            return this.fForegroundColor;
        }
    }

    private class HighlightingTooltipSavyJTableMouseListener
    extends MouseAdapter {
        private HighlightingTooltipSavyJTableMouseListener() {
        }

        public void mousePressed(MouseEvent e) {
            if (e.getButton() == 3) {
                Point point = new Point(e.getX(), e.getY());
                int selectionRow = HighlightingTooltipSavvyJTable.this.rowAtPoint(point);
                int selectionColumn = HighlightingTooltipSavvyJTable.this.columnAtPoint(point);
                if (selectionRow != -1 && selectionColumn != -1) {
                    if (HighlightingTooltipSavvyJTable.this.fSelectOnRightClick) {
                        HighlightingTooltipSavvyJTable.this.setRowSelectionInterval(selectionRow, selectionRow);
                    }
                    int modelColumnIndex = HighlightingTooltipSavvyJTable.this.convertColumnIndexToModel(selectionColumn);
                    ArrayList<HighlighterCreatorFactory> applicableFactories = new ArrayList<HighlighterCreatorFactory>();
                    Iterator iterator = HighlightingTooltipSavvyJTable.this.fHighlighterCreatorActionFactoriesList.iterator();
                    while (iterator.hasNext()) {
                        HighlighterCreatorFactory factory = (HighlighterCreatorFactory)iterator.next();
                        int[] applicableIndexes = factory.getApplicableModelIndexes();
                        for (int x = 0; x < applicableIndexes.length; ++x) {
                            if (applicableIndexes[x] != modelColumnIndex) continue;
                            applicableFactories.add(factory);
                        }
                    }
                    if (HighlightingTooltipSavvyJTable.this.fHighlighterList.size() > 0 || applicableFactories.size() > 0 || HighlightingTooltipSavvyJTable.this.fContextMenuProviders.size() > 0) {
                        JPopupMenu popup = new JPopupMenu();
                        if (HighlightingTooltipSavvyJTable.this.fHighlighterList.size() > 0 || applicableFactories.size() > 0) {
                            JMenu highlightersMenu = new JMenu("Highlight...");
                            if (applicableFactories.size() > 0 && HighlightingTooltipSavvyJTable.this.fColorList.size() != HighlightingTooltipSavvyJTable.this.fUsedColorList.size()) {
                                iterator = applicableFactories.iterator();
                                while (iterator.hasNext()) {
                                    HighlighterCreatorFactory applicableFactory = (HighlighterCreatorFactory)iterator.next();
                                    JMenu highlighterMenu = new JMenu("by " + applicableFactory.getHighlighterName());
                                    AHighlighterCreator highlighterCreator = applicableFactory.createHighlighterCreator(HighlightingTooltipSavvyJTable.this, selectionRow, modelColumnIndex, HighlightingTooltipSavvyJTable.this.getValueAt(selectionRow, selectionColumn));
                                    Iterator colorIterator = HighlightingTooltipSavvyJTable.this.fColorList.iterator();
                                    while (colorIterator.hasNext()) {
                                        ColorPack colorPack = (ColorPack)colorIterator.next();
                                        if (HighlightingTooltipSavvyJTable.this.fUsedColorList.contains(colorPack)) continue;
                                        ColorizedJMenuItem colorMenuItem = new ColorizedJMenuItem(new HighlighterCreatorAction(highlighterCreator, colorPack));
                                        highlighterMenu.add(colorMenuItem);
                                    }
                                    highlightersMenu.add(highlighterMenu);
                                }
                            }
                            if (HighlightingTooltipSavvyJTable.this.fHighlighterList.size() > 0) {
                                if (highlightersMenu.getItemCount() > 0) {
                                    highlightersMenu.addSeparator();
                                    highlightersMenu.add(new RemoveAllHighlightersAction());
                                    highlightersMenu.addSeparator();
                                }
                                iterator = HighlightingTooltipSavvyJTable.this.fHighlighterList.iterator();
                                int index = 0;
                                int maxIndex = HighlightingTooltipSavvyJTable.this.fHighlighterList.size() - 1;
                                while (iterator.hasNext()) {
                                    AHighlighter highlighter = (AHighlighter)iterator.next();
                                    JMenu highlighterOptionsMenu = new JMenu(highlighter.getName());
                                    highlighterOptionsMenu.setBackground(highlighter.getBackgroundColor());
                                    highlighterOptionsMenu.setForeground(highlighter.getForegroundColor());
                                    RemoveHighlighterAction removeHighlighterAction = new RemoveHighlighterAction(highlighter);
                                    highlighterOptionsMenu.add(removeHighlighterAction);
                                    if (index == 0 && maxIndex > 0) {
                                        highlighterOptionsMenu.add(new MoveHighlighterAction(highlighter, 0));
                                        highlighterOptionsMenu.add(new MoveHighlighterAction(highlighter, 2));
                                    }
                                    if (index > 0) {
                                        if (index == maxIndex) {
                                            highlighterOptionsMenu.add(new MoveHighlighterAction(highlighter, 1));
                                            highlighterOptionsMenu.add(new MoveHighlighterAction(highlighter, 3));
                                        } else {
                                            highlighterOptionsMenu.add(new MoveHighlighterAction(highlighter, 1));
                                            highlighterOptionsMenu.add(new MoveHighlighterAction(highlighter, 3));
                                            highlighterOptionsMenu.add(new MoveHighlighterAction(highlighter, 0));
                                            highlighterOptionsMenu.add(new MoveHighlighterAction(highlighter, 2));
                                        }
                                    }
                                    ++index;
                                    highlightersMenu.add(highlighterOptionsMenu);
                                }
                            }
                            popup.add(highlightersMenu);
                        }
                        if (HighlightingTooltipSavvyJTable.this.fContextMenuProviders.size() > 0) {
                            if (popup.getSubElements().length > 0) {
                                popup.add(new JSeparator());
                            }
                            iterator = HighlightingTooltipSavvyJTable.this.fContextMenuProviders.iterator();
                            while (iterator.hasNext()) {
                                IContextMenuProvider provider = (IContextMenuProvider)iterator.next();
                                Object object = provider.getContextMenu(HighlightingTooltipSavvyJTable.this, selectionRow, modelColumnIndex, HighlightingTooltipSavvyJTable.this.getValueAt(selectionRow, selectionColumn));
                                if (object == null) continue;
                                if (object instanceof Action) {
                                    popup.add((Action)object);
                                    continue;
                                }
                                if (object instanceof JMenuItem) {
                                    popup.add((JMenuItem)object);
                                    continue;
                                }
                                popup.add(object.toString());
                            }
                        }
                        popup.show(HighlightingTooltipSavvyJTable.this, e.getX(), e.getY());
                    }
                }
            }
        }
    }
}

