/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.wizard;

import com.wily.ui.CalendarPanel;
import com.wily.ui.IGenericServices;
import com.wily.ui.swing.ExtendedJLabel;
import com.wily.ui.wizard.AWizard;
import com.wily.util.properties.IndexedProperties;
import java.util.Enumeration;
import java.util.Hashtable;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JTextField;

public abstract class APropertiesWizard
extends AWizard {
    private Hashtable fWidgetTable;

    public APropertiesWizard(IGenericServices genericServices) {
        super(genericServices);
        this.init();
    }

    protected void showState() {
        this.setAllAssociatedPropertiesFromWidgetValues();
        super.showState();
    }

    protected void showStatusState() {
        this.setAllAssociatedPropertiesFromWidgetValues();
        super.showStatusState();
    }

    protected void showFinishedState() {
        this.setAllAssociatedPropertiesFromWidgetValues();
        super.showFinishedState();
    }

    private void init() {
        this.fWidgetTable = new Hashtable();
    }

    public void linkWidgetToProperty(JComponent widget, IndexedProperties whichProperties, String settingKey) {
        PropertiesTuple hashTableEntry = new PropertiesTuple(whichProperties, settingKey);
        this.fWidgetTable.put(widget, hashTableEntry);
        this.setWidgetValueFromAssociatedProperty(widget);
    }

    public void setAllAssociatedPropertiesFromWidgetValues() {
        Enumeration widgets = this.fWidgetTable.keys();
        while (widgets.hasMoreElements()) {
            JComponent c = (JComponent)widgets.nextElement();
            this.setAssociatedPropertyFromWidgetValue(c);
        }
    }

    public void setAllWidgetValuesFromAssociatedProperties() {
        Enumeration widgets = this.fWidgetTable.keys();
        while (widgets.hasMoreElements()) {
            JComponent c = (JComponent)widgets.nextElement();
            this.setWidgetValueFromAssociatedProperty(c);
        }
    }

    private void setWidgetValueFromAssociatedProperty(JComponent widget) {
        PropertiesTuple hashTableEntry = (PropertiesTuple)this.fWidgetTable.get(widget);
        String value = hashTableEntry.getProperties().getTrimmedProperty(hashTableEntry.getKey());
        if (value == null) {
            value = "";
        }
        if (widget instanceof ExtendedJLabel) {
            ((ExtendedJLabel)widget).setText(value);
        } else if (widget instanceof JCheckBox) {
            ((JCheckBox)widget).setSelected(value.equalsIgnoreCase("true"));
        } else if (widget instanceof JTextField) {
            ((JTextField)widget).setText(value);
        } else if (widget instanceof JComboBox) {
            ((JComboBox)widget).setSelectedItem(value);
        } else if (widget instanceof JList) {
            ((JList)widget).setSelectedValue(value, true);
        }
    }

    private void setAssociatedPropertyFromWidgetValue(JComponent c) {
        Long value;
        PropertiesTuple hashTableEntry = (PropertiesTuple)this.fWidgetTable.get(c);
        IndexedProperties propsToUse = hashTableEntry.getProperties();
        String propsKey = hashTableEntry.getKey();
        if (c instanceof ExtendedJLabel) {
            propsToUse.put(propsKey, ((ExtendedJLabel)c).getText());
        } else if (c instanceof JTextField) {
            propsToUse.put(propsKey, ((JTextField)c).getText());
        } else if (c instanceof JCheckBox) {
            propsToUse.put(propsKey, ((JCheckBox)c).isSelected() ? "true" : "false");
        } else if (c instanceof JList) {
            Object value2 = ((JList)c).getSelectedValue();
            if (value2 != null) {
                propsToUse.put(propsKey, value2);
            }
        } else if (c instanceof JComboBox) {
            Object value3 = ((JComboBox)c).getSelectedItem();
            if (value3 != null && !value3.toString().startsWith("<")) {
                propsToUse.put(propsKey, value3);
            } else {
                propsToUse.remove(propsKey);
                if (value3 != null) {
                    propsToUse.put(propsKey, value3);
                }
            }
        } else if (c instanceof CalendarPanel && (value = new Long(((CalendarPanel)c).getTimeInMillis())) != null) {
            propsToUse.put(propsKey, value.toString());
        }
    }

    private class PropertiesTuple {
        private IndexedProperties fProperties;
        private String fKey;

        public PropertiesTuple(IndexedProperties props, String key) {
            this.fProperties = props;
            this.fKey = key;
        }

        public IndexedProperties getProperties() {
            return this.fProperties;
        }

        public String getKey() {
            return this.fKey;
        }
    }
}

