/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.ACommonAgent;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.hc2.ASingleInstanceTracerFactoryHC;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.IndexedProperties;

public class AsyncHttpServletDetectionTracer
extends ASingleInstanceTracerFactoryHC {
    private static final String asynchHttpServletTracingEnableKey = "introscope.autoprobe.enable.tracergroup.AsyncHttpServletTracing";
    protected final IModuleFeedbackChannel feedback;
    protected final IAgent agent;
    protected static Module module = new Module("AsyncHttpServletDetectionTracer");
    private boolean done;
    private volatile IDynamicInstrumentationTransformer fTransformer = null;

    private IDynamicInstrumentationTransformer getTransformer() {
        if (this.fTransformer == null) {
            this.fTransformer = this.agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
        }
        return this.fTransformer;
    }

    public AsyncHttpServletDetectionTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.agent = agent;
        this.feedback = agent.IAgent_getModuleFeedback();
        IndexedProperties props = agent.IAgent_getIndexedProperties();
        String value = props.getProperty(asynchHttpServletTracingEnableKey);
        this.done = !"auto".equalsIgnoreCase(value);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        this.done = true;
        System.setProperty(asynchHttpServletTracingEnableKey, "true");
        this.feedback.info(module, "Detected asynchronous servlet execution in this application.");
        this.feedback.info(module, "Overriding: introscope.autoprobe.enable.tracergroup.AsyncHttpServletTracing= true");
        if (this.feedback.isDebugEnabled(module)) {
            this.feedback.debug(module, "Detected asynchronous servlet execution.", new Exception("Location"));
        }
        ((ACommonAgent)this.agent).getConfigurationWatcher().reloadConfig();
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public boolean ITracerFactory_isShutoff() {
        return this.done;
    }

    @Override
    protected void doOnAbortedTransactionEndTrace(int tracerIndex, IStackElement data) {
    }

    @Override
    public void doOnStartTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
    }

    @Override
    public void doOnEndTrace(int tracerIndex, IStackElement data, ITransactionElement element) {
    }
}

