/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.connection;

import com.wily.introscope.agent.connection.ClientInfo;
import com.wily.introscope.agent.connection.IAgentCommand;
import com.wily.introscope.spec.server.beans.agent.IAgentBridgeService;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;

class RenameAgentCommand
implements IAgentCommand {
    private final IAgentBridgeService fAgentBridge;
    private final String fActualAgentName;
    private final String fRequestedAgentName;
    private final ClientInfo fClientInfo;
    private final IModuleFeedbackChannel fFeedback;
    private final IStringLocalizer fLocalizer;

    public RenameAgentCommand(IAgentBridgeService agentBridge, String requestedAgentName, String actualAgentName, ClientInfo clientInfo, IModuleFeedbackChannel feedback, IStringLocalizer localizer) {
        this.fAgentBridge = agentBridge;
        this.fRequestedAgentName = requestedAgentName;
        this.fActualAgentName = actualAgentName;
        this.fClientInfo = clientInfo;
        this.fFeedback = feedback;
        this.fLocalizer = localizer;
    }

    @Override
    public void handleAgentCommand() throws Exception {
        this.fFeedback.info(this.fLocalizer.IStringLocalizer_getFormattedLocalizedString("Agent_JIP_Protocol_Request_Agent_Name_Change_Message", this.fActualAgentName, this.fRequestedAgentName));
        this.fAgentBridge.handleClientNameChanged(this.fClientInfo.getHostName(), this.fClientInfo.getProcessName(), this.fRequestedAgentName, this.fClientInfo.isClonedAgent());
    }
}

