/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.event;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.event.IEventNoticer;
import com.wily.introscope.agent.extension.DuplicateDynamicClassException;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.InstantiableDynamicClassLookup;
import com.wily.introscope.agent.extension.InvalidDynamicClassException;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;

final class EventNoticerLoader
extends InstantiableDynamicClassLookup {
    private static final String kEventNoticerPluginType = "eventnoticer";
    private static final int kCurrentEventNoticerPluginVersion = 1;
    private static final Class[] kEventNoticerConstructorParameterTypes = new Class[]{IAgent.class};

    public EventNoticerLoader(IAgent agent) {
        super(agent, IEventNoticer.class, kEventNoticerConstructorParameterTypes);
        this.loadEventNoticerPlugins();
    }

    @Override
    protected Object[] getConstructorParameters(IAgent dynamicAgent) {
        return new Object[]{dynamicAgent};
    }

    public IEventNoticer loadEventNoticer(String eventNoticerName) {
        return (IEventNoticer)this.load(eventNoticerName);
    }

    private void loadEventNoticerPlugins() {
        ExtensionAdministrator extensionAdministrator = this.getAgent().IAgent_getExtensionAdministrator();
        Assertion.wilyAssert(false);
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kEventNoticerPluginType);
        int i = 0;
        while (i < plugins.length) {
            this.loadEventNoticerPlugin(plugins[i]);
            ++i;
        }
    }

    private void loadEventNoticerPlugin(IPlugin plugin) {
        Class eventNoticerClass = ExtensionUtilities.loadEntryPointClass(this.getModuleFeedback(), this.getStringLocalizer(), plugin, 1, IEventNoticer.class);
        if (eventNoticerClass != null) {
            IStringLocalizer eventNoticerLocalizer = plugin.IPlugin_getOwningExtension().IExtension_getStringLocalizer(this.getStringLocalizer());
            try {
                this.register(plugin, eventNoticerClass.getName(), eventNoticerClass, eventNoticerLocalizer);
                this.getModuleFeedback().verbose(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Event_Noticer_Plugin_Registered_Message", plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName()));
            }
            catch (DuplicateDynamicClassException ddce) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Event_Noticer_Plugin_Duplicate_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName()));
                this.getModuleFeedback().verbose(ddce);
            }
            catch (InvalidDynamicClassException idce) {
                this.getModuleFeedback().error(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Event_Noticer_Plugin_Invalid_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName()));
                this.getModuleFeedback().verbose(idce);
            }
        }
    }
}

