/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.InformationNotAvailableException;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.stat.ILongAverageDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.ICpuUsageReporter;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.util.properties.AttributeListing;

public final class MethodCPUTimer
extends ASingleMetricTracerFactory {
    private static boolean fHopeless;
    private static ICpuUsageReporter fReporter;

    private static ICpuUsageReporter getCPUUsageReporter(IAgent agent) {
        if (!fHopeless && fReporter == null) {
            MethodCPUTimer.lookupCPUUsageReporter(agent);
        }
        return fReporter;
    }

    private static synchronized void lookupCPUUsageReporter(IAgent agent) {
        if (!fHopeless && fReporter == null) {
            try {
                fReporter = agent.IAgent_getServiceAdministrator().getCpuUsageReporter();
            }
            catch (InformationNotAvailableException informationNotAvailableException) {
                fHopeless = true;
                fReporter = null;
                agent.IAgent_getModuleFeedback().error(agent.IAgent_getStringLocalizer().IStringLocalizer_getLocalizedString("Agent_Tracer_CPU_Timer_Support_Not_Available_Message"));
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                fHopeless = true;
                fReporter = null;
                agent.IAgent_getModuleFeedback().error(agent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_CPU_Timer_Support_Error_Message", t.toString()));
                agent.IAgent_getModuleFeedback().verbose(t);
            }
        }
    }

    private static synchronized void clearCPUUsageReporter() {
        fHopeless = true;
        fReporter = null;
    }

    static synchronized void debug_resetCPUUsageReporter() {
        fHopeless = false;
        fReporter = null;
    }

    public MethodCPUTimer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        MethodCPUTimer.getCPUUsageReporter(agent);
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        ICpuUsageReporter reporter = MethodCPUTimer.getCPUUsageReporter(this.getAgent());
        if (reporter != null && data.getCPUStartTime() < 0L) {
            data.setCPUStartTime(this.getCPUUsage(reporter));
        }
        this.addToBlameStackIfEnabled(data);
    }

    @Override
    protected final IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return this.getDataAccumulatorFactory().safeGetLongAverageDataAccumulator(formattedMetricName);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        long startTime;
        BlameStackSnapshot snapshot = this.removeFromBlameStackIfEnabledAndReturnSnapshot(data);
        ICpuUsageReporter reporter = MethodCPUTimer.getCPUUsageReporter(this.getAgent());
        if (reporter != null && (startTime = data.getCPUStartTime()) >= 0L) {
            ILongAverageDataAccumulator average;
            long endTime = data.getCPUFinishTime();
            if (endTime < 0L) {
                endTime = this.getCPUUsage(reporter);
                data.setCPUFinishTime(endTime);
            }
            if (!(average = (ILongAverageDataAccumulator)this.getDataAccumulator(data)).IDataAccumulator_isShutOff()) {
                average.ILongAggregatingDataAccumulator_recordDataPoint(this.elapsedTime(startTime, endTime), snapshot);
            }
        }
    }

    private long elapsedTime(long start, long finish) {
        return finish > start ? finish - start : 0L;
    }

    private long getCPUUsage(ICpuUsageReporter reporter) {
        try {
            return reporter.ICpuUsageReporter_getCpuUsage();
        }
        catch (InformationNotAvailableException inae) {
            MethodCPUTimer.clearCPUUsageReporter();
            this.getAgent().IAgent_getModuleFeedback().debug("Misconfigured platform monitor threw an exception when attempting to access per thread CPU usage");
            this.getAgent().IAgent_getModuleFeedback().debug(inae);
            return 0L;
        }
    }
}

