/*
 * Decompiled with CFR 0.152.
 */
package com.wily.net;

import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.net.AgentSocketInputStream;
import java.io.IOException;
import java.net.AbstractPlainSocketImpl;
import java.net.SocketInputStream;

public class ManagedSocketInputStreamAPSIHighPerformanceNew
extends SocketInputStream {
    private final AgentSocketInputStream managedSocketInputStream = new AgentSocketInputStream();

    public ManagedSocketInputStreamAPSIHighPerformanceNew(AbstractPlainSocketImpl impl) throws IOException {
        super(impl);
        this.managedSocketInputStream.setCache(impl.socket);
    }

    public int read() throws IOException {
        int byteRead;
        if (this.managedSocketInputStream.getCache() == null || this.checkWithOverheadMgr()) {
            return super.read();
        }
        boolean addedToConcurrentReaders = this.managedSocketInputStream.addToConcurrentReaders("read()");
        if (this.managedSocketInputStream.getCache().isClientConnection()) {
            this.managedSocketInputStream.annotateBlameStack(this);
            this.managedSocketInputStream.suggestStackTraceRecording();
        }
        try {
            byteRead = super.read();
            this.managedSocketInputStream.addToInputBandwidth(1);
        }
        finally {
            this.managedSocketInputStream.removeFromConcurrentReaders(addedToConcurrentReaders, "read()");
        }
        return byteRead;
    }

    public int read(byte[] b, int off, int length) throws IOException {
        int numberOfBytesRead;
        if (this.managedSocketInputStream.getCache() == null || this.checkWithOverheadMgr()) {
            return super.read(b, off, length);
        }
        boolean addedToConcurrentReaders = this.managedSocketInputStream.addToConcurrentReaders("read(byte[],int,int)");
        if (this.managedSocketInputStream.getCache().isClientConnection()) {
            this.managedSocketInputStream.annotateBlameStack(this);
            this.managedSocketInputStream.suggestStackTraceRecording();
        }
        try {
            numberOfBytesRead = super.read(b, off, length);
            this.managedSocketInputStream.addToInputBandwidth(numberOfBytesRead);
        }
        finally {
            this.managedSocketInputStream.removeFromConcurrentReaders(addedToConcurrentReaders, "read(byte[],int,int)");
        }
        return numberOfBytesRead;
    }

    private boolean checkWithOverheadMgr() {
        return OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == OverheadAdministrator.getOverheadMode() || OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode();
    }
}

