/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.transactiontrace.ISamplingInput;
import com.wily.util.feedback.Module;

public interface ISamplingResult {
    public static final Module kSamplingModule = new Module("TransactionSamplingStrategy");
    public static final ISamplingResult NO = new ConstantSamplingResult(false, null);

    public Answer shouldStartSampling();

    public void determineSampling(ISamplingInput var1, Callback var2);

    public ISamplingResult derivativeSamplingResult();

    public static class Answer {
        public final Choice choice;
        public final String byWho;

        public Answer(Choice choice, String byWho) {
            this.choice = choice;
            this.byWho = byWho;
        }

        public String toString() {
            return "ISamplingResult.Answer=" + (Object)((Object)this.choice) + (this.byWho == null ? "" : " by " + this.byWho);
        }
    }

    public static interface Callback {
        public static final Callback NO_OP_CALLBACK = new Callback(){

            @Override
            public void onSamplingDetermined(Answer answer) {
            }
        };

        public void onSamplingDetermined(Answer var1);
    }

    public static enum Choice {
        YES(true),
        NO(false),
        MAYBE(true);

        public final boolean mayBeYes;

        private Choice(boolean mayBeYes) {
            this.mayBeYes = mayBeYes;
        }
    }

    public static final class ConstantSamplingResult
    implements ISamplingResult {
        private final Answer answer;

        public ConstantSamplingResult(boolean sample, String byWho) {
            this(new Answer(sample ? Choice.YES : Choice.NO, byWho));
        }

        protected ConstantSamplingResult(Answer answer) {
            this.answer = answer;
        }

        @Override
        public Answer shouldStartSampling() {
            return this.answer;
        }

        @Override
        public void determineSampling(ISamplingInput input, Callback callback) {
            callback.onSamplingDetermined(this.answer);
        }

        @Override
        public ISamplingResult derivativeSamplingResult() {
            return this;
        }
    }
}

