/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.util;

public enum JavaVersion {
    CURRENT,
    v6("1.6"),
    v7("1.7"),
    v8("1.8"),
    v9("9.0"),
    v10("10.0"),
    v11("11.0"),
    UNKNOWN("0.0");

    private final float version;
    private static final float VERSION_NOT_KNOWN = 0.0f;
    private static final String VERSION_PROPERTY = "java.version";

    private JavaVersion(float version) {
        this.version = version;
    }

    private JavaVersion(String version) {
        this(JavaVersion.parse(version));
    }

    private JavaVersion() {
        float v = 0.0f;
        try {
            v = JavaVersion.parse(System.getProperty(VERSION_PROPERTY));
        }
        catch (Exception exception) {}
        this.version = v;
    }

    private boolean haveValidVersion() {
        return this.version != 0.0f;
    }

    private boolean higher(String verString) {
        return this.haveValidVersion() && this.version > JavaVersion.parse(verString);
    }

    private boolean lower(String verString) {
        return this.haveValidVersion() && this.version < JavaVersion.parse(verString);
    }

    private boolean atLeast(String verString) {
        return this.haveValidVersion() && this.version >= JavaVersion.parse(verString);
    }

    private boolean atMost(String verString) {
        return this.haveValidVersion() && this.version <= JavaVersion.parse(verString);
    }

    private boolean matches(String verString) {
        return this.haveValidVersion() && this.version == JavaVersion.parse(verString);
    }

    public boolean satisfies(String expression) {
        if (expression.startsWith(">=")) {
            return this.atLeast(expression.substring(2).trim());
        }
        if (expression.startsWith("<=")) {
            return this.atMost(expression.substring(2).trim());
        }
        if (expression.startsWith(">")) {
            return this.higher(expression.substring(1).trim());
        }
        if (expression.startsWith("<")) {
            return this.lower(expression.substring(1).trim());
        }
        if (expression.startsWith("==")) {
            return this.matches(expression.substring(2).trim());
        }
        return this.matches(expression.trim());
    }

    public String toString() {
        return String.format("%s [java.version = %s]", this.name(), Float.valueOf(this.version));
    }

    public String getVersion() {
        return String.valueOf(this.version);
    }

    public boolean isUnknown() {
        return 0.0f == this.version;
    }

    private static float parse(String v) {
        String[] tokens = v.split("\\.");
        if (tokens.length == 0) {
            throw new IllegalArgumentException(String.format("Missing required version information : %s", v));
        }
        return tokens.length == 1 ? Float.parseFloat(String.valueOf(tokens[0]) + ".0") : Float.parseFloat(String.valueOf(tokens[0]) + "." + tokens[1]);
    }
}

