/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.intelligent.entrypoint.stacktrace;

import com.wily.introscope.agent.intelligent.detection.rules.CommonUtils;
import com.wily.introscope.agent.intelligent.entrypoint.EntryPointDetectionConfiguration;
import com.wily.introscope.agent.intelligent.entrypoint.apis.IndexAwareTraceElement;
import com.wily.introscope.agent.intelligent.entrypoint.stacktrace.WrappedStackTraceElement;
import com.wily.introscope.agent.probe.net.ManagedDatagramSocket;
import com.wily.introscope.agent.probe.net.ManagedSocketInputStream;
import com.wily.introscope.agent.probe.net.ManagedSocketOutputStream;
import java.util.Arrays;
import java.util.HashSet;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;

public class StackTraceRepository {
    private static Queue<StackTraceElement[]> tracesQueue = new ConcurrentLinkedQueue<StackTraceElement[]>();
    private static final AgentElementsFilter AGENT_ELEMENTS_FILTER = new AgentElementsFilter();

    public static boolean add(StackTraceElement[] trace) {
        return tracesQueue.add(trace);
    }

    public static StackTraceElement[] poll() {
        return tracesQueue.poll();
    }

    public static IndexAwareTraceElement[] pollWrappedTrace() {
        return StackTraceRepository.wrapTraceElements(tracesQueue.poll());
    }

    public static IndexAwareTraceElement[] wrapTraceElements(StackTraceElement[] origTrace) {
        StackTraceElement[] filteredTrace = AGENT_ELEMENTS_FILTER.filter(origTrace);
        IndexAwareTraceElement[] wrappedTrace = null;
        if (filteredTrace != null && filteredTrace.length > 0) {
            int length = filteredTrace.length;
            wrappedTrace = new IndexAwareTraceElement[length];
            StackTraceElement element = null;
            int index = 0;
            while (index < length) {
                element = filteredTrace[index];
                wrappedTrace[index] = new WrappedStackTraceElement(element, index, length);
                ++index;
            }
        }
        return wrappedTrace;
    }

    public static int size() {
        return tracesQueue.size();
    }

    public static boolean isEmpty() {
        return tracesQueue.isEmpty();
    }

    public static boolean isFull() {
        return StackTraceRepository.size() >= EntryPointDetectionConfiguration.getStackTracesLimitPerInterval();
    }

    public static void clear() {
        tracesQueue.clear();
    }

    public static AgentElementsFilter getAgentElementsFilter() {
        return AGENT_ELEMENTS_FILTER;
    }

    public static class AgentElementsFilter {
        private final Set<Pattern> packagePrefixesForAgentElements = new HashSet<Pattern>();
        private static final String GET_STACK_TRACE_ELEMENT_CLASS_NAME = "java.lang.Thread";
        private static final String GET_STACK_TRACE_ELEMENT_METHOD_NAME = "getStackTrace";
        private static final String GET_STACK_TRACE_ELEMENT_NAME = CommonUtils.getFqMethodName((String)"java.lang.Thread", (String)"getStackTrace");
        private static final String SUGGEST_STACK_TRACE_RECORDING_METHOD_NAME = "suggestStackTraceRecording";
        private static final Set<String> classesToFilterOut = new HashSet<String>(2);
        private static final Set<String> substitutedClassMethods = new HashSet<String>(5);
        private static final Set<String> socketReplacementClasses = new HashSet<String>(8);

        static {
            classesToFilterOut.add(GET_STACK_TRACE_ELEMENT_CLASS_NAME);
            substitutedClassMethods.add(CommonUtils.getFqMethodName((String)ManagedDatagramSocket.class.getName(), (String)"send"));
            substitutedClassMethods.add(CommonUtils.getFqMethodName((String)ManagedDatagramSocket.class.getName(), (String)"receive"));
            substitutedClassMethods.add(CommonUtils.getFqMethodName((String)ManagedSocketOutputStream.class.getName(), (String)"write"));
            substitutedClassMethods.add(CommonUtils.getFqMethodName((String)ManagedSocketInputStream.class.getName(), (String)"read"));
            socketReplacementClasses.add("com.wily.net.ManagedSocketOutputStreamAPSIHighPerformance");
            socketReplacementClasses.add("com.wily.net.ManagedSocketOutputStreamAPSIHighPerformanceNew");
            socketReplacementClasses.add("com.wily.net.ManagedSocketInputStreamAPSIHighPerformance");
            socketReplacementClasses.add("com.wily.net.ManagedSocketInputStreamAPSIHighPerformanceNew");
            socketReplacementClasses.add("com.wily.net.ManagedSocketInputStreamHighPerformance");
            socketReplacementClasses.add("com.wily.net.ManagedSocketInputStreamHighPerformanceNew");
            socketReplacementClasses.add("com.wily.net.ManagedSocketOutputStreamHighPerformance");
            socketReplacementClasses.add("com.wily.net.ManagedSocketOutputStreamHighPerformanceNew");
        }

        public AgentElementsFilter(Set<String> packageExprns) {
            this(packageExprns, true);
        }

        public AgentElementsFilter(Set<String> packageExprns, boolean isRegexBased) {
            for (String packageExpr : packageExprns) {
                if (!isRegexBased) {
                    packageExpr = CommonUtils.convertToPackageRegex((String)packageExpr);
                }
                this.packagePrefixesForAgentElements.add(Pattern.compile(packageExpr, 2));
            }
        }

        public AgentElementsFilter(String commadSepratedPackagesList) {
            String[] stringArray = commadSepratedPackagesList.split(",");
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String pkg = stringArray[n2];
                pkg = CommonUtils.convertToPackageRegex((String)pkg);
                this.packagePrefixesForAgentElements.add(Pattern.compile(pkg, 2));
                ++n2;
            }
        }

        public AgentElementsFilter() {
            this("com.ca,com.wily");
        }

        public StackTraceElement[] filter(StackTraceElement[] traceElements) {
            if (traceElements != null && traceElements.length > 0) {
                StackTraceElement element = null;
                int size = traceElements.length;
                int index = 0;
                String fqMethod = "";
                boolean foundThreadElement = false;
                while (index < size) {
                    element = traceElements[index];
                    fqMethod = CommonUtils.getFqMethodName((String)(element = CommonUtils.sanitizetraceElement((StackTraceElement)element)).getClassName(), (String)element.getMethodName());
                    if (GET_STACK_TRACE_ELEMENT_NAME.equals(fqMethod)) {
                        foundThreadElement = true;
                    }
                    if (foundThreadElement && (substitutedClassMethods.contains(fqMethod) || socketReplacementClasses.contains(element.getClassName()) || !CommonUtils.doesElementPackageMatch((StackTraceElement)element, this.packagePrefixesForAgentElements) && !classesToFilterOut.contains(element.getClassName()) && !element.getMethodName().equals(SUGGEST_STACK_TRACE_RECORDING_METHOD_NAME))) break;
                    ++index;
                }
                if (foundThreadElement) {
                    return Arrays.copyOfRange(traceElements, index, size);
                }
            }
            return traceElements;
        }
    }
}

