/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.image.filter;

import java.awt.image.RGBImageFilter;

public class GrayScaleFilter
extends RGBImageFilter {
    private static final double kBrightnessFactor = 0.7;

    public GrayScaleFilter() {
        this.canFilterIndexColorModel = true;
    }

    public int filterRGB(int x, int y, int rgb) {
        int redVal = (rgb & 0xFF0000) >> 16;
        int greenVal = (rgb & 0xFF00) >> 8;
        int blueVal = rgb & 0xFF;
        int grayVal = (redVal + greenVal + blueVal) / 3;
        int brightnessAdjustment = (int)((double)(255 - grayVal) * 0.7);
        return 0xFF000000 | (grayVal += brightnessAdjustment) << 16 | grayVal << 8 | grayVal;
    }
}

