/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.ui.IGenericServices;
import com.wily.ui.RadialMeasurements;
import com.wily.ui.action.ErrorReportingExtendedActionWrapper;
import com.wily.ui.action.IExtendedAction;
import com.wily.ui.action.MonitoredExtendedActionWrapper;
import com.wily.ui.swing.KSwingPropertyNames;
import com.wily.ui.swing.WilyJDialog;
import com.wily.ui.swing.WilyMetalButtonComboBoxUI;
import com.wily.ui.swing.WilyMetalComboBoxUI;
import com.wily.ui.swing.WilySearchableComboBoxUI;
import com.wily.ui.swing.WilyWindowsButtonComboBoxUI;
import com.wily.ui.swing.WilyWindowsComboBoxUI;
import com.wily.ui.swing.WilyWindowsSearchableComboBoxUI;
import com.wily.util.StringUtils;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import com.wily.wilyassert.SwingAssertion;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.FontMetrics;
import java.awt.Frame;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.ComponentAdapter;
import java.awt.event.ComponentEvent;
import java.awt.event.ComponentListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import java.awt.font.FontRenderContext;
import java.awt.font.LineBreakMeasurer;
import java.awt.font.TextAttribute;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Rectangle2D;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.io.PrintStream;
import java.text.AttributedCharacterIterator;
import java.text.AttributedString;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Vector;
import javax.swing.AbstractButton;
import javax.swing.Action;
import javax.swing.BorderFactory;
import javax.swing.DefaultFocusManager;
import javax.swing.FocusManager;
import javax.swing.Icon;
import javax.swing.JComponent;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenuItem;
import javax.swing.JTextArea;
import javax.swing.KeyStroke;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.UnsupportedLookAndFeelException;
import javax.swing.plaf.BorderUIResource;
import javax.swing.plaf.metal.MetalLookAndFeel;

public class WilyUIUtilities {
    private static final WindowListener gAutoDeselectMenuOnDeactivationWindowListener = new AutoDeselectMenuOnDeactivationWindowListener();
    private static final ComponentListener gAutoRespectComponentMinimumSizeListener = new AutoRespectComponentMinimumSizeListener();
    private static final double kMaxAdvanceToHeightRatio = 0.6;
    private static final int kDefaultIconInset = 4;
    public static final Insets kDefaultToolbarButtonInsets = new Insets(1, 3, 1, 3);
    public static final Insets kDefaultToolbarTextButtonInsets = new Insets(0, 3, 0, 3);
    public static final int kDefaultToolbarButtonSpace = 3;
    public static final int kDefaultToolbarButtonGroupSpace = 10;
    public static final int LOOK_AND_FEEL_UNKNOWN = -1;
    public static final int LOOK_AND_FEEL_METAL = 0;
    public static final int LOOK_AND_FEEL_WINDOWS = 2;

    private WilyUIUtilities() {
    }

    public static List makeMonitoredReportingActions(List actionsToConvert, IGenericServices genericServices, Component parentComponent) {
        LinkedList<IExtendedAction> convertedActions = new LinkedList<IExtendedAction>();
        Iterator actions = actionsToConvert.iterator();
        while (actions.hasNext()) {
            convertedActions.add(WilyUIUtilities.makeMonitoredReportingAction((IExtendedAction)actions.next(), genericServices, parentComponent));
        }
        return convertedActions;
    }

    public static List makeReportingActions(List actionsToConvert, IGenericServices genericServices, Component parentComponent) {
        LinkedList<IExtendedAction> convertedActions = new LinkedList<IExtendedAction>();
        Iterator actions = actionsToConvert.iterator();
        while (actions.hasNext()) {
            convertedActions.add(WilyUIUtilities.makeReportingAction((IExtendedAction)actions.next(), genericServices, parentComponent));
        }
        return convertedActions;
    }

    public static IExtendedAction makeReportingAction(IExtendedAction action, IGenericServices genericServices, Component parentComponent) {
        return new ErrorReportingExtendedActionWrapper(genericServices, parentComponent, action);
    }

    public static IExtendedAction makeMonitoredReportingAction(IExtendedAction action, IGenericServices genericServices, Component parentComponent) {
        IExtendedAction errorReportingAction = WilyUIUtilities.makeReportingAction(action, genericServices, parentComponent);
        MonitoredExtendedActionWrapper monitoredAction = new MonitoredExtendedActionWrapper(errorReportingAction, genericServices.IGenericServices_getExtendedActionMonitor());
        return monitoredAction;
    }

    public static JFrame getOwningFrameForComponent(Component c) {
        Component root = SwingUtilities.getRoot(c);
        if (root instanceof JFrame) {
            return (JFrame)root;
        }
        return null;
    }

    public static int computeMaxStringLength(Graphics g, int pixels) {
        return pixels / g.getFontMetrics().getMaxAdvance();
    }

    public static int computeCharacterLimitHeuristic(JComponent component, Font font) {
        int maxAdvance = (int)((double)font.getSize() * 0.6);
        Insets insets = component.getInsets();
        int pixelWidth = component.getSize().width - insets.left - insets.right - 10;
        return pixelWidth <= 0 ? Integer.MAX_VALUE : pixelWidth / maxAdvance;
    }

    public static int computerStringWidthHeuristic(String string, Font font) {
        int maxAdvance = (int)((double)font.getSize() * 0.6);
        return string.length() * maxAdvance + 10;
    }

    public static int getInsertionIndex(Container component, Point location) {
        Component targetComponent = component.getComponentAt(location);
        int targetIndex = WilyUIUtilities.getChildIndex(component, targetComponent);
        int insertionIndex = component.getComponentCount();
        if (targetIndex != -1) {
            Point localizedPoint = WilyUIUtilities.convertParentPointToImmediateChildPoint(targetComponent, location);
            insertionIndex = localizedPoint.x > targetComponent.getWidth() / 2 ? targetIndex + 1 : targetIndex;
        }
        return insertionIndex;
    }

    public static Point convertParentPointToImmediateChildPoint(Component child, Point p) {
        return new Point(p.x - child.getLocation().x, p.y - child.getLocation().y);
    }

    public static Point convertChildPointToParentPoint(Component child, Component parent, Point p) {
        Point translatedPoint = p;
        for (Component current = child; current != null && current != parent; current = current.getParent()) {
            translatedPoint = new Point(translatedPoint.x + current.getLocation().x, translatedPoint.y + current.getLocation().y);
        }
        return translatedPoint;
    }

    public static void setEnabledForComponentAndAllChildren(Component c, boolean enabled) {
        c.setEnabled(enabled);
        if (c instanceof Container) {
            Container parentContainer = (Container)c;
            Component[] children = parentContainer.getComponents();
            for (int i = 0; i < children.length; ++i) {
                WilyUIUtilities.setEnabledForComponentAndAllChildren(children[i], enabled);
            }
        }
    }

    public static Dimension getChildOffset(Component child, Container parent, boolean includeParentOffsets) {
        Point parentPoint = WilyUIUtilities.convertChildPointToParentPoint(child, parent, new Point(0, 0));
        if (includeParentOffsets) {
            Insets parentInsets = parent.getInsets();
            parentPoint.x -= parentInsets.left + parentInsets.right;
            parentPoint.y -= parentInsets.top + parentInsets.bottom;
        }
        return new Dimension(parentPoint.x, parentPoint.y);
    }

    public static int getChildIndex(Container parentComponent, Component childComponent) {
        SwingAssertion.assertSwingSafe();
        int componentCount = parentComponent.getComponentCount();
        for (int i = 0; i < componentCount; ++i) {
            if (!parentComponent.getComponent(i).equals(childComponent)) continue;
            return i;
        }
        return -1;
    }

    public static void setActionForButton(Action action, AbstractButton button) {
        WilyUIUtilities.setActionForButton(action, button, false);
    }

    public static void setActionForButton(Action action, AbstractButton button, boolean syncNames) {
        WilyUIUtilities.setActionForButton(action, button, syncNames, true);
    }

    public static void setActionForButton(final Action action, final AbstractButton button, boolean syncNames, boolean syncButtonState) {
        button.addActionListener(action);
        if (syncButtonState) {
            action.addPropertyChangeListener(new SyncStatesListener(action, button, syncNames));
        }
        if (syncNames) {
            final String name = (String)action.getValue("Name");
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    button.setText(name);
                }
            });
        }
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                button.setEnabled(action.isEnabled());
            }
        });
    }

    public static boolean componentShareTopLevelAncestor(JComponent comp1, JComponent comp2) {
        Container cont1 = comp1.getTopLevelAncestor();
        Container cont2 = comp2.getTopLevelAncestor();
        return cont1 != null && cont1 == cont2;
    }

    public static Component getSharedAncestor(Component comp1, Component comp2) {
        Component c;
        Vector<Component> comp1Ancestors = new Vector<Component>();
        Component commonAncestor = null;
        for (c = comp1; c != null; c = c.getParent()) {
            comp1Ancestors.add(c);
        }
        for (c = comp2; c != null && commonAncestor == null; c = c.getParent()) {
            if (!comp1Ancestors.contains(c)) continue;
            commonAncestor = c;
        }
        return commonAncestor;
    }

    public static boolean componentHasAncestor(Component component, Component ancestor) {
        for (Component c = component; c != null; c = c.getParent()) {
            if (c != ancestor) continue;
            return true;
        }
        return false;
    }

    public static void drawCircle(Graphics2D g2D, RadialMeasurements measurements) {
        SwingAssertion.assertSwingSafe();
        Ellipse2D.Float circle = new Ellipse2D.Float(measurements.getCenter().x - measurements.getRadius(), measurements.getCenter().y - measurements.getRadius(), 2 * measurements.getRadius(), 2 * measurements.getRadius());
        g2D.draw(circle);
    }

    public static void fillCircle(Graphics2D g2D, RadialMeasurements measurements) {
        SwingAssertion.assertSwingSafe();
        Ellipse2D.Float circle = new Ellipse2D.Float(measurements.getCenter().x - measurements.getRadius(), measurements.getCenter().y - measurements.getRadius(), 2 * measurements.getRadius(), 2 * measurements.getRadius());
        g2D.fill(circle);
    }

    public static boolean windowCanFitOnScreen(Window window) {
        Rectangle windowRect = new Rectangle(window.getSize());
        return WilyUIUtilities.windowCanFitOnScreen(windowRect);
    }

    public static boolean windowCanFitOnScreen(WilyJDialog dialog) {
        Dimension size = new Dimension(dialog.getWidth(), dialog.getHeight());
        Rectangle windowRect = new Rectangle(size);
        return WilyUIUtilities.windowCanFitOnScreen(windowRect);
    }

    private static boolean windowCanFitOnScreen(Rectangle windowRect) {
        Rectangle screenRectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return screenRectangle.contains(windowRect);
    }

    public static void relocateWindowToFitOnScreen(final Window window) {
        Point adjustedLocation;
        Point windowLocation = window.getLocation();
        if (!windowLocation.equals(adjustedLocation = WilyUIUtilities.getRelocateWindowToFitOnScreenPosition(windowLocation, window.getSize()))) {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    window.setLocation(adjustedLocation);
                }
            });
        }
    }

    public static void relocateWindowToFitOnScreen(final WilyJDialog dialog) {
        Dimension windowSize;
        Point adjustedLocation;
        Point windowLocation = dialog.getLocation();
        if (!windowLocation.equals(adjustedLocation = WilyUIUtilities.getRelocateWindowToFitOnScreenPosition(windowLocation, windowSize = new Dimension(dialog.getWidth(), dialog.getHeight())))) {
            if (SwingUtilities.isEventDispatchThread()) {
                dialog.setLocation(adjustedLocation.x, adjustedLocation.y);
            } else {
                SwingUtilities.invokeLater(new Runnable(){

                    public void run() {
                        dialog.setLocation(adjustedLocation.x, adjustedLocation.y);
                    }
                });
            }
        }
    }

    private static Point getRelocateWindowToFitOnScreenPosition(Point windowLocation, Dimension windowSize) {
        Rectangle screenRectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        int adjustedX = windowLocation.x;
        int adjustedY = windowLocation.y;
        if (windowSize.width > screenRectangle.width) {
            adjustedX = screenRectangle.width / 2;
        } else if (windowLocation.x < 0) {
            adjustedX = 0;
        } else if (windowLocation.x + windowSize.width > screenRectangle.width) {
            adjustedX = screenRectangle.width - windowSize.width;
        }
        if (windowSize.width > screenRectangle.height) {
            adjustedY = screenRectangle.height / 2;
        } else if (windowLocation.x < 0) {
            adjustedY = 0;
        } else if (windowLocation.x + windowSize.width > screenRectangle.width) {
            adjustedY = screenRectangle.height - windowSize.height;
        }
        return new Point(adjustedX, adjustedY);
    }

    public static void resizeWindowToFitOnScreen(final Window window) {
        final Dimension newSize = WilyUIUtilities.getSizeToFitOnScreen(window.getSize());
        SwingUtilities.invokeLater(new Runnable(){

            public void run() {
                window.setSize(newSize.width, newSize.height);
            }
        });
    }

    public static void resizeWindowToFitOnScreen(final WilyJDialog dialog) {
        Dimension windowSize = new Dimension(dialog.getWidth(), dialog.getHeight());
        final Dimension newSize = WilyUIUtilities.getSizeToFitOnScreen(windowSize);
        if (SwingUtilities.isEventDispatchThread()) {
            dialog.setSize(newSize);
        } else {
            SwingUtilities.invokeLater(new Runnable(){

                public void run() {
                    dialog.setSize(newSize);
                }
            });
        }
    }

    private static Dimension getSizeToFitOnScreen(Dimension windowSize) {
        Dimension screenSize = Toolkit.getDefaultToolkit().getScreenSize();
        int newWidth = windowSize.width > screenSize.width ? screenSize.width / 100 * 90 : windowSize.width;
        int newHeight = windowSize.height > screenSize.height ? screenSize.height / 100 * 90 : windowSize.height;
        return new Dimension(newWidth, newHeight);
    }

    public static boolean pointOnScreen(Point point) {
        Rectangle screenRectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        return screenRectangle.contains(point);
    }

    public static boolean boundsFitOnScreen(Point location, Dimension size) {
        Rectangle screenRectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        Rectangle candidateRect = new Rectangle(location, size);
        return screenRectangle.contains(candidateRect);
    }

    public static void centerWindowOnScreen(Window windowToCenter) {
        SwingAssertion.assertSwingSafe();
        Rectangle screenRectangle = new Rectangle(Toolkit.getDefaultToolkit().getScreenSize());
        WilyUIUtilities.centerComponentOnRectangle(windowToCenter, screenRectangle);
    }

    public static void centerWindowOnComponent(Window windowToCenter, Component centeringComponent) {
        SwingAssertion.assertSwingSafe();
        Rectangle centeringComponentRectangle = new Rectangle(centeringComponent.getLocationOnScreen(), centeringComponent.getSize());
        WilyUIUtilities.centerComponentOnRectangle(windowToCenter, centeringComponentRectangle);
        WilyUIUtilities.relocateWindowToFitOnScreen(windowToCenter);
    }

    private static void centerComponentOnRectangle(Component componentToCenter, Rectangle centeringRectangle) {
        SwingAssertion.assertSwingSafe();
        Point center = new Point(centeringRectangle.x + centeringRectangle.width / 2, centeringRectangle.y + centeringRectangle.height / 2);
        Point componentToCenterLocation = new Point(center.x - componentToCenter.getSize().width / 2, center.y - componentToCenter.getSize().height / 2);
        componentToCenter.setLocation(componentToCenterLocation);
    }

    public static void restoreWindowIfMinimized(Frame frame) {
        int state = frame.getState();
        if (state == 1) {
            frame.setState(0);
        }
    }

    public static String truncateString(String stringToTruncate, FontMetrics fontMetrics, int pixelLimit, String truncationMarker) {
        StringBuffer truncatedStringBuffer = new StringBuffer(stringToTruncate.length());
        int truncationMarkerWidth = 0;
        int proposedStringWidth = 0;
        if (truncationMarker == null) {
            truncationMarker = "";
        }
        truncationMarkerWidth = SwingUtilities.computeStringWidth(fontMetrics, truncationMarker);
        if (SwingUtilities.computeStringWidth(fontMetrics, stringToTruncate) <= pixelLimit) {
            return stringToTruncate;
        }
        if (truncationMarker != null && truncationMarkerWidth > pixelLimit) {
            return "";
        }
        proposedStringWidth = fontMetrics.charWidth(stringToTruncate.charAt(0));
        for (int i = 0; i < stringToTruncate.length() && proposedStringWidth + truncationMarkerWidth < pixelLimit; ++i) {
            truncatedStringBuffer.append(stringToTruncate.charAt(i));
            proposedStringWidth += i + 1 < stringToTruncate.length() ? fontMetrics.charWidth(stringToTruncate.charAt(i + 1)) : 0;
        }
        return truncatedStringBuffer.append(truncationMarker).toString();
    }

    public static String getHtmlFormattedText(String fontFace, String text, boolean bold) {
        fontFace = StringUtils.ensureNonNullString(fontFace);
        text = StringUtils.ensureNonNullString(text);
        StringBuffer buffer = new StringBuffer(text.length() + 50);
        buffer.append("<html>");
        buffer.append("<font face=\"");
        buffer.append(fontFace);
        buffer.append("\" size=-1>");
        if (bold) {
            buffer.append("<b>");
        }
        String escapedText = StringUtils.escapeHTMLSpecialCharacters(text);
        String[] kSources = new String[]{"\n", " ", "\t"};
        String[] kReplacements = new String[]{"<br>", "&nbsp;", "&nbsp;&nbsp;&nbsp;&nbsp;"};
        buffer.append(StringUtils.multipleReplace(escapedText, kSources, kReplacements));
        if (bold) {
            buffer.append("</b>");
        }
        buffer.append("</font>");
        buffer.append("</html>");
        return buffer.toString();
    }

    public static Icon getIconForType(int messageType) {
        Assertion.wilyAssert(messageType == 0 || messageType == 1 || messageType == 2 || messageType == 3);
        switch (messageType) {
            case 0: {
                return WilyUIUtilities.getStandardErrorIcon();
            }
            case 1: {
                return WilyUIUtilities.getStandardInformationIcon();
            }
            case 2: {
                return WilyUIUtilities.getStandardWarningIcon();
            }
            case 3: {
                return WilyUIUtilities.getStandardQuestionIcon();
            }
        }
        return null;
    }

    public static Icon getStandardWarningIcon() {
        return UIManager.getIcon("OptionPane.warningIcon");
    }

    public static Icon getStandardInformationIcon() {
        return UIManager.getIcon("OptionPane.informationIcon");
    }

    public static Icon getStandardQuestionIcon() {
        return UIManager.getIcon("OptionPane.questionIcon");
    }

    public static Icon getStandardErrorIcon() {
        return UIManager.getIcon("OptionPane.errorIcon");
    }

    public static JComponent getIconComponentForType(int messageType) {
        return WilyUIUtilities.getIconAsComponent(WilyUIUtilities.getIconForType(messageType));
    }

    public static JComponent getStandardQuestionIconComponent() {
        return WilyUIUtilities.getIconAsComponent(WilyUIUtilities.getStandardQuestionIcon());
    }

    public static JComponent getStandardWarningIconComponent() {
        return WilyUIUtilities.getIconAsComponent(WilyUIUtilities.getStandardWarningIcon());
    }

    public static JComponent getStandardInformationIconComponent() {
        return WilyUIUtilities.getIconAsComponent(WilyUIUtilities.getStandardInformationIcon());
    }

    public static JComponent getStandardErrorIconComponent() {
        return WilyUIUtilities.getIconAsComponent(WilyUIUtilities.getStandardErrorIcon());
    }

    public static JComponent getIconAsComponent(Icon icon) {
        return WilyUIUtilities.getIconAsComponent(icon, 4);
    }

    public static JComponent getIconAsComponent(Icon icon, int inset) {
        JLabel label = new JLabel(icon);
        label.setBorder(BorderFactory.createEmptyBorder(inset, inset, inset, inset));
        return label;
    }

    public static void setLocalizedMnemonic(AbstractButton button, String mnemonicKey, IStringLocalizer stringLocalizer) {
        String localizedMnemonicString = stringLocalizer.IStringLocalizer_getLocalizedString(mnemonicKey);
        if (localizedMnemonicString == mnemonicKey) {
            localizedMnemonicString = null;
        }
        if (localizedMnemonicString != null && !StringUtils.isEmpty(localizedMnemonicString)) {
            button.setMnemonic(localizedMnemonicString.charAt(0));
        }
    }

    public static void setLocalizedAccelerator(JMenuItem menuItem, String acceleratorKey, IStringLocalizer stringLocalizer) {
        String localizedAcceleratorString = stringLocalizer.IStringLocalizer_getLocalizedString(acceleratorKey);
        KeyStroke keyStroke = null;
        if (localizedAcceleratorString != acceleratorKey && !StringUtils.isEmpty(localizedAcceleratorString)) {
            try {
                keyStroke = KeyStroke.getKeyStroke(localizedAcceleratorString);
            }
            catch (Throwable t) {
                Assertion.wilyAssert("Couldn't parse accelerator key: " + acceleratorKey);
                keyStroke = null;
            }
        }
        if (keyStroke != null) {
            // empty if block
        }
        menuItem.setAccelerator(keyStroke);
    }

    public static void registerLocalizedKeyboardAction(JComponent component, Action action, String keyboardActionKey, int aCondition, IStringLocalizer stringLocalizer) {
        String localizedKeyboardActionString = stringLocalizer.IStringLocalizer_getLocalizedString(keyboardActionKey);
        KeyStroke keyStroke = null;
        if (localizedKeyboardActionString != keyboardActionKey && !StringUtils.isEmpty(localizedKeyboardActionString)) {
            try {
                keyStroke = KeyStroke.getKeyStroke(localizedKeyboardActionString);
            }
            catch (Throwable t) {
                Assertion.wilyAssert("Couldn't parse keyboard action key: " + keyboardActionKey);
                keyStroke = null;
            }
        }
        if (keyStroke != null) {
            // empty if block
        }
        component.registerKeyboardAction(action, "", keyStroke, aCondition);
    }

    public static void autoDeselectMenuOnWindowDeactivation(Window window) {
    }

    public static void autoRespectComponentMinimumSize(Component component) {
        component.addComponentListener(gAutoRespectComponentMinimumSizeListener);
    }

    public static void activateDebugFocusManager() {
        FocusManager.setCurrentManager(new DebugFocusManager());
    }

    public static void dumpContainmentHierarchy(Component component, PrintStream out) {
        for (Component currentComponent = component; currentComponent != null; currentComponent = currentComponent.getParent()) {
            String componentName = currentComponent.getName() == null ? "no name specified" : currentComponent.getName();
            String className = currentComponent.getClass().getName();
            out.println("\t" + className + " (" + componentName + ")");
        }
    }

    public static void moveChild(Container container, int fromIndex, int toIndex) {
        SwingAssertion.assertSwingSafe();
        if (fromIndex != toIndex) {
            Component child = container.getComponent(fromIndex);
            container.remove(child);
            int adjustedToIndex = fromIndex < toIndex ? toIndex-- : toIndex;
            container.add(child, adjustedToIndex);
        }
    }

    public static void calculateMultiLineTextSize(JTextArea textArea, int maxMessageWidthInPixels) {
        Graphics g = textArea.getGraphics();
        String messageText = textArea.getText();
        Font font = textArea.getFont();
        FontMetrics fm = textArea.getFontMetrics(font);
        Rectangle2D messageStringBounds = fm.getStringBounds(messageText, g);
        boolean hasNewLine = messageText.indexOf(10) != -1;
        int messageWidth = (int)Math.ceil(messageStringBounds.getWidth());
        if (hasNewLine || messageWidth > maxMessageWidthInPixels) {
            textArea.setLineWrap(true);
            textArea.setWrapStyleWord(true);
            int charWidth = fm.charWidth('m');
            int numColumns = (int)Math.floor((double)maxMessageWidthInPixels / (double)charWidth);
            textArea.setColumns(numColumns);
            int numRows = 0;
            while (!messageText.equals("")) {
                String nextChunk;
                int numRowsForNextChunk = 0;
                int nextNewLine = messageText.indexOf(10);
                if (nextNewLine == -1) {
                    nextChunk = messageText;
                    messageText = "";
                } else {
                    nextChunk = messageText.substring(0, nextNewLine);
                    messageText = messageText.substring(nextNewLine + 1);
                }
                if (!nextChunk.equals("")) {
                    AttributedString attributedString = new AttributedString(nextChunk);
                    attributedString.addAttribute(TextAttribute.FONT, font);
                    AttributedCharacterIterator characterIterator = attributedString.getIterator();
                    Graphics2D g2d = (Graphics2D)g;
                    FontRenderContext fontRenderContext = g2d.getFontRenderContext();
                    LineBreakMeasurer measurer = new LineBreakMeasurer(characterIterator, fontRenderContext);
                    while (measurer.getPosition() < characterIterator.getEndIndex()) {
                        measurer.nextLayout(maxMessageWidthInPixels);
                        ++numRowsForNextChunk;
                    }
                }
                if (numRowsForNextChunk < 1) {
                    numRowsForNextChunk = 1;
                }
                numRows += numRowsForNextChunk;
            }
            textArea.setRows(numRows);
        } else {
            textArea.setLineWrap(false);
            textArea.setWrapStyleWord(false);
            textArea.setColumns(0);
            textArea.setRows(0);
        }
    }

    public static int setLookAndFeel() {
        int currentLookAndFeel = -1;
        System.setProperty("apple.laf.useScreenMenuBar", Boolean.TRUE.toString());
        try {
            WilyUIUtilities.setMetalLookAndFeel();
            currentLookAndFeel = 0;
        }
        catch (UnsupportedLookAndFeelException e) {
            System.out.println("*** Very unexpected: could not set the Metal look and feel. ***");
            e.printStackTrace();
        }
        try {
            WilyUIUtilities.setWindowsLookAndFeel();
            currentLookAndFeel = 2;
        }
        catch (UnsupportedLookAndFeelException unsupportedLookAndFeelException) {
        }
        catch (InstantiationException instantiationException) {
        }
        catch (IllegalAccessException illegalAccessException) {
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        return currentLookAndFeel;
    }

    public static void setMetalLookAndFeel() throws UnsupportedLookAndFeelException {
        UIManager.setLookAndFeel(new MetalLookAndFeel());
        UIManager.put("ToolTipUI", "com.wily.ui.swing.ExtendedToolTipUI");
        String className = "com.wily.ui.swing.WilySearchableComboBoxUI";
        Class searchableComboBoxUIClass = WilySearchableComboBoxUI.class;
        UIManager.put(className, searchableComboBoxUIClass);
        UIManager.put("WilySearchableComboBoxUI", className);
        className = "com.wily.ui.swing.WilyMetalButtonComboBoxUI";
        Class buttonComboBoxUIClass = WilyMetalButtonComboBoxUI.class;
        UIManager.put(className, buttonComboBoxUIClass);
        UIManager.put("WilyButtonComboBoxUI", className);
        className = "com.wily.ui.swing.WilyMetalComboBoxUI";
        Class comboBoxUIClass = WilyMetalComboBoxUI.class;
        UIManager.put(className, comboBoxUIClass);
        UIManager.put("ComboBoxUI", className);
    }

    public static void setWindowsLookAndFeel() throws UnsupportedLookAndFeelException, InstantiationException, IllegalAccessException, ClassNotFoundException {
        String lookAndFeelClass = "com.sun.java.swing.plaf.windows.WindowsLookAndFeel";
        String osProperty = System.getProperty("java.vendor");
        boolean isMac = osProperty.startsWith("Apple");
        if (osProperty != null && isMac) {
            lookAndFeelClass = "apple.laf.AquaLookAndFeel";
        }
        UIManager.setLookAndFeel(lookAndFeelClass);
        UIManager.put("ToolTipUI", "javax.swing.plaf.basic.BasicToolTipUI");
        UIManager.put("Button.showMnemonics", new Boolean(true));
        String className = "com.wily.ui.swing.WilyWindowsSearchableComboBoxUI";
        Class searchableComboBoxUIClass = WilyWindowsSearchableComboBoxUI.class;
        UIManager.put(className, searchableComboBoxUIClass);
        UIManager.put("WilySearchableComboBoxUI", className);
        className = "com.wily.ui.swing.WilyWindowsButtonComboBoxUI";
        Class buttonComboBoxUIClass = WilyWindowsButtonComboBoxUI.class;
        UIManager.put(className, buttonComboBoxUIClass);
        UIManager.put("WilyButtonComboBoxUI", className);
        className = "com.wily.ui.swing.WilyWindowsComboBoxUI";
        Class comboBoxUIClass = WilyWindowsComboBoxUI.class;
        UIManager.put(className, comboBoxUIClass);
        UIManager.put("ComboBoxUI", className);
        if (!isMac) {
            try {
                className = "com.wily.ui.swing.WilyWindowsCheckBoxMenuItemUI";
                Class<?> checkBoxMenuItemUIClass = Class.forName(className);
                UIManager.put(className, checkBoxMenuItemUIClass);
                UIManager.put("CheckBoxMenuItemUI", className);
            }
            catch (ClassNotFoundException checkBoxMenuItemUIClass) {
                // empty catch block
            }
        }
        try {
            className = "com.wily.ui.swing.WilyWindowsRadioButtonMenuItemUI";
            Class<?> radioButtonMenuItemUIClass = Class.forName(className);
            UIManager.put(className, radioButtonMenuItemUIClass);
            UIManager.put("RadioButtonMenuItemUI", className);
        }
        catch (ClassNotFoundException classNotFoundException) {
            // empty catch block
        }
        UIManager.put("MenuBar.border", new BorderUIResource(BorderFactory.createCompoundBorder(BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)UIManager.get("MenuBar.highlight")), BorderFactory.createMatteBorder(0, 0, 1, 0, (Color)UIManager.get("MenuBar.shadow")))));
        UIManager.put("Tree.selectionBorderColor", UIManager.getColor("Tree.selectionBackground"));
    }

    static class SyncStatesListener
    implements PropertyChangeListener,
    KSwingPropertyNames {
        private AbstractButton fButton;
        private boolean fSyncNames;

        public SyncStatesListener(Action action, AbstractButton button, boolean syncNames) {
            this.fButton = button;
            this.fSyncNames = syncNames;
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                Boolean enabledBoolean = (Boolean)evt.getNewValue();
                this.fButton.setEnabled(enabledBoolean);
            }
            if (evt.getPropertyName().equals("Name") && this.fSyncNames) {
                String name = (String)evt.getNewValue();
                this.fButton.setText(name);
            }
        }
    }

    static class DebugFocusManager
    extends DefaultFocusManager {
        DebugFocusManager() {
        }

        public void focusNextComponent(Component aComponent) {
            System.out.println("focus going away from component with following hierarchy:");
            WilyUIUtilities.dumpContainmentHierarchy(aComponent, System.out);
            System.out.println("----done----\n\n\n");
            super.focusNextComponent(aComponent);
        }
    }

    static class AutoRespectComponentMinimumSizeListener
    extends ComponentAdapter {
        AutoRespectComponentMinimumSizeListener() {
        }

        public void componentResized(ComponentEvent e) {
            SwingAssertion.assertSwingSafe();
            Component component = e.getComponent();
            int width = component.getWidth();
            int height = component.getHeight();
            Dimension size = component.getMinimumSize();
            int min_width = size.width;
            int min_height = size.height;
            boolean resize = false;
            if (width < min_width) {
                resize = true;
                width = min_width;
            }
            if (height < min_height) {
                resize = true;
                height = min_height;
            }
            if (resize) {
                Component c;
                int w = width;
                int h = height;
                if (component instanceof JFrame) {
                    c = component;
                } else {
                    c = SwingUtilities.windowForComponent(component);
                    if (c == null) {
                        return;
                    }
                }
                c.setSize(w, h);
            }
        }
    }

    static class AutoDeselectMenuOnDeactivationWindowListener
    extends WindowAdapter {
        AutoDeselectMenuOnDeactivationWindowListener() {
        }

        public void windowDeactivated(WindowEvent windowEvent) {
        }
    }
}

