/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter;

import com.wily.introscope.agent.filter.IntervalBasedSampler;
import com.wily.introscope.agent.filter.SamplingResult;
import com.wily.introscope.agent.transactiontrace.ISamplingInput;
import com.wily.introscope.agent.transactiontrace.ISamplingResult;
import java.util.Comparator;
import java.util.NoSuchElementException;
import java.util.concurrent.ConcurrentSkipListSet;
import java.util.concurrent.atomic.AtomicReference;

abstract class BaseStatisticalSampler
extends IntervalBasedSampler {
    private final AtomicReference<ConcurrentSkipListSet<Element>> top = new AtomicReference(new ConcurrentSkipListSet(Element.access$0()));

    BaseStatisticalSampler() {
    }

    @Override
    public ISamplingResult shouldSample() {
        if (this.isEnabled()) {
            if (this.fFeedback.isTraceEnabled(kSamplingModule)) {
                this.fFeedback.trace(kSamplingModule, String.valueOf(this.name()) + " sampling strategy 'may be' allowed sampling of transaction");
            }
            return new StatisticalSamplingResult();
        }
        return SamplingResult.NO;
    }

    private final Element smallest(ConcurrentSkipListSet<Element> currentTop) {
        try {
            return currentTop.first();
        }
        catch (NoSuchElementException noSuchElementException) {
            return null;
        }
    }

    private final void discard(Element element) {
        if (this.fFeedback.isDebugEnabled(kSamplingModule)) {
            this.fFeedback.debug(kSamplingModule, "Sampler " + this.name() + " is going to discard element outright with hash=" + element);
        }
        element.pendingCallback.onSamplingDetermined(new ISamplingResult.Answer(ISamplingResult.Choice.NO, this.name()));
    }

    private void insert(Element element) {
        Element smallest;
        ConcurrentSkipListSet<Element> currentTop = this.top.get();
        int samplesPerInterval = this.fSamplesCountPerInterval;
        if (currentTop.size() >= samplesPerInterval && (smallest = this.smallest(currentTop)) != null && Element.COMPARATOR.compare(element, smallest) <= 0) {
            this.discard(element);
            return;
        }
        if (this.fFeedback.isDebugEnabled(kSamplingModule)) {
            this.fFeedback.debug(kSamplingModule, "Sampler " + this.name() + " is trying to keep element with hash=" + element);
        }
        element.pendingCallback.onSamplingDetermined(new ISamplingResult.Answer(ISamplingResult.Choice.MAYBE, this.name()));
        currentTop.add(element);
        this.trimToSize(currentTop, samplesPerInterval, ISamplingResult.Choice.NO);
    }

    private void trimToSize(ConcurrentSkipListSet<Element> set, int size, ISamplingResult.Choice returnValue) {
        while (set.size() > size) {
            Element removed = set.pollFirst();
            if (removed == null) {
                return;
            }
            if (this.fFeedback.isDebugEnabled(kSamplingModule)) {
                if (returnValue == ISamplingResult.Choice.YES) {
                    this.fFeedback.debug(kSamplingModule, "Sampler " + this.name() + " will report sampled transacion with score=" + removed.value + ", hash=" + removed);
                } else {
                    this.fFeedback.debug(kSamplingModule, "Sampler " + this.name() + " discarded sampled transacion with score=" + removed.value + ", hash=" + removed);
                }
            }
            SamplingResult.execute(removed.pendingCallback, new ISamplingResult.Answer(returnValue, this.name()));
        }
    }

    protected abstract long appraise(ISamplingInput var1);

    @Override
    protected void cleanup() {
        ConcurrentSkipListSet<Element> old = this.top.getAndSet(new ConcurrentSkipListSet(Element.COMPARATOR));
        this.trimToSize(old, 0, ISamplingResult.Choice.NO);
        super.cleanup();
    }

    @Override
    protected void onDurationExpired() {
        ConcurrentSkipListSet<Element> fromPreviousInterval = this.top.getAndSet(new ConcurrentSkipListSet(Element.COMPARATOR));
        this.trimToSize(fromPreviousInterval, this.fSamplesCountPerInterval, ISamplingResult.Choice.NO);
        this.trimToSize(fromPreviousInterval, 0, ISamplingResult.Choice.YES);
    }

    private static final class Element {
        final ISamplingResult.Callback pendingCallback;
        final long value;
        private static final Comparator<Element> COMPARATOR = new Comparator<Element>(){

            @Override
            public int compare(Element o1, Element o2) {
                if (o1.value < o2.value) {
                    return -1;
                }
                if (o1.value > o2.value) {
                    return 1;
                }
                return 0;
            }
        };

        private Element(ISamplingResult.Callback pendingCallback, long value) {
            this.pendingCallback = pendingCallback;
            this.value = value;
        }
    }

    private final class StatisticalSamplingResult
    extends SamplingResult {
        public StatisticalSamplingResult() {
            super(new ISamplingResult.Answer(ISamplingResult.Choice.MAYBE, null));
        }

        @Override
        protected void determineSamplingInternal(ISamplingInput input, ISamplingResult.Callback callback) {
            long value = BaseStatisticalSampler.this.appraise(input);
            Element element = new Element(callback, value);
            BaseStatisticalSampler.this.insert(element);
        }
    }
}

