/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.remote;

import com.wily.introscope.agent.IAgent;
import com.wily.util.classfile.IClassName;
import com.wily.util.classfile.IMethodName;
import com.wily.util.classfile.IMethodSignature;
import com.wily.util.classfile.IModeledClass;
import com.wily.util.classfile.IModeledMethod;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.classfile.InvalidMethodDescriptorException;
import com.wily.util.classfile.InvalidMethodNameException;
import com.wily.util.classfile.java.ClassFileMethodDescriptor;
import com.wily.util.classfile.java.ClassName;
import com.wily.util.classfile.java.MethodName;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.io.PrintWriter;
import java.util.Iterator;

public final class RemoteModeledMethod
implements IModeledMethod {
    private final IModuleFeedbackChannel fFeedback;
    private final String methodName;
    private final String className;
    private final String probeName;
    private final String methodDescriptor;

    public RemoteModeledMethod(IAgent agent, String methodName, String className, String methodDescriptor, String probeName) {
        this.methodName = methodName;
        this.className = className;
        this.methodDescriptor = methodDescriptor;
        this.probeName = probeName;
        this.fFeedback = agent.IAgent_getModuleFeedback();
    }

    @Override
    public IModeledClass getModeledClass() {
        return new IModeledClass(){

            @Override
            public IClassName getClassName() {
                try {
                    return ClassName.getClassName(RemoteModeledMethod.this.className);
                }
                catch (InvalidClassNameException e) {
                    RemoteModeledMethod.this.fFeedback.error("Invalid class name: " + RemoteModeledMethod.this.className + " " + e.getMessage());
                    if (RemoteModeledMethod.this.fFeedback.isDebugEnabled()) {
                        RemoteModeledMethod.this.fFeedback.debug(e);
                    }
                    return null;
                }
            }

            @Override
            public boolean hasSuperClass() {
                return false;
            }

            @Override
            public IClassName getSuperClassName() {
                return null;
            }

            @Override
            public boolean isInterface() {
                return false;
            }

            @Override
            public boolean isValueType() {
                return false;
            }

            @Override
            public boolean inheritsDirectlyFromInterface(IClassName interfaceName) {
                return false;
            }

            @Override
            public boolean isInstanceOf(IClassName classOrinterfaceName) {
                return false;
            }

            @Override
            public Iterator getAllDeclaredMethods() {
                return null;
            }

            @Override
            public boolean containsAnnotation(IClassName annotationName) {
                return false;
            }

            @Override
            public boolean referencesClass(IClassName referencedName) {
                return false;
            }

            @Override
            public void debugDump(PrintWriter log) {
                log.println(RemoteModeledMethod.this.className);
            }
        };
    }

    @Override
    public IMethodName getMethodName() {
        try {
            return MethodName.getMethodName(this.methodName);
        }
        catch (InvalidMethodDescriptorException e) {
            this.fFeedback.error("Invalid method desriptor: " + this.className + "." + this.methodName + " " + this.methodDescriptor + " " + e.getMessage());
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug(e);
            }
            return null;
        }
        catch (InvalidMethodNameException e) {
            this.fFeedback.error("Invalid method name: " + this.className + "." + this.methodName + " " + this.methodDescriptor + " " + e.getMessage());
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug(e);
            }
            return null;
        }
    }

    @Override
    public IMethodSignature getSignature() {
        try {
            if (this.methodDescriptor != null && this.methodDescriptor.length() > 0) {
                return new ClassFileMethodDescriptor(this.methodDescriptor);
            }
            return new ClassFileMethodDescriptor("()V");
        }
        catch (InvalidMethodDescriptorException e) {
            this.fFeedback.error("Invalid method desriptor: " + this.className + "." + this.methodName + " " + this.methodDescriptor + " " + e.getMessage());
            if (this.fFeedback.isDebugEnabled()) {
                this.fFeedback.debug(e);
            }
            return null;
        }
    }

    @Override
    public boolean isInstanceConstructor() {
        return this.methodName.equals(this.className);
    }

    @Override
    public boolean isClassConstructor() {
        return false;
    }

    @Override
    public boolean isStatic() {
        return false;
    }

    @Override
    public boolean isEntryPoint() {
        return false;
    }

    @Override
    public boolean hasBytecode() {
        return true;
    }

    @Override
    public boolean isComplex() {
        return true;
    }

    @Override
    public boolean containsAnnotation(IClassName annotationName) {
        return false;
    }

    @Override
    public boolean isComplex(boolean includeRestricted) {
        return true;
    }

    @Override
    public boolean isRemote() {
        return false;
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        RemoteModeledMethod that = (RemoteModeledMethod)o;
        if (this.methodName != null ? !this.methodName.equals(that.methodName) : that.methodName != null) {
            return false;
        }
        if (this.className != null ? !this.className.equals(that.className) : that.className != null) {
            return false;
        }
        if (this.probeName != null ? !this.probeName.equals(that.probeName) : that.probeName != null) {
            return false;
        }
        return this.methodDescriptor != null ? this.methodDescriptor.equals(that.methodDescriptor) : that.methodDescriptor == null;
    }

    public int hashCode() {
        int result = this.methodName != null ? this.methodName.hashCode() : 0;
        result = 31 * result + (this.className != null ? this.className.hashCode() : 0);
        result = 31 * result + (this.probeName != null ? this.probeName.hashCode() : 0);
        result = 31 * result + (this.methodDescriptor != null ? this.methodDescriptor.hashCode() : 0);
        return result;
    }
}

