/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.stalls;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.stalls.StallFeature;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public class StallSweeper
implements ITimestampedRunnable {
    private List stallFeatureSets = new ArrayList();
    private boolean initialized = false;
    private int nextSlotValue = 0;
    private static StallSweeper sInstance = new StallSweeper();
    private static IRegisteredBehavior fRegisteredBehavior;
    static final int kNumSets = 30;

    private StallSweeper() {
        int i = 0;
        while (i < 30) {
            this.stallFeatureSets.add(i, new HashSet());
            ++i;
        }
    }

    boolean isInitialized() {
        return this.initialized;
    }

    void setInitialized() {
        this.initialized = true;
    }

    public static void initializeInstance(IAgent agent, long stallResolutionInMillis) {
        if (!sInstance.isInitialized()) {
            fRegisteredBehavior = agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)sInstance, "StallSweeper", true, stallResolutionInMillis, true);
            sInstance.setInitialized();
        } else {
            agent.IAgent_getModuleFeedback().error("StallSweeper already initialized");
        }
    }

    public static void reInitializeInstance(IAgent agent, long stallResolutionInMillis) {
        if (fRegisteredBehavior != null) {
            fRegisteredBehavior.IRegisteredBehavior_setPeriod(stallResolutionInMillis);
        }
    }

    public static StallSweeper getInstance() {
        return sInstance;
    }

    @Override
    public void ITimestampedRunnable_execute(long nowInMillis) {
        if (this.initialized) {
            this.sweepStacks(nowInMillis);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void register(StallFeature stallFeature) {
        Set slotSet;
        int slotValue = stallFeature.getSweeperSlotValue();
        Set set = slotSet = (Set)this.stallFeatureSets.get(slotValue);
        synchronized (set) {
            slotSet.add(stallFeature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void sweepStacks(long nowInMillis) {
        HashSet copyOfStallFeatures = new HashSet();
        int i = 0;
        while (i < 30) {
            Set featuresInList;
            copyOfStallFeatures.clear();
            Set set = featuresInList = (Set)this.stallFeatureSets.get(i);
            synchronized (set) {
                copyOfStallFeatures.addAll(featuresInList);
            }
            for (StallFeature stallFeature : copyOfStallFeatures) {
                stallFeature.checkIfStalled(nowInMillis);
            }
            ++i;
        }
        copyOfStallFeatures = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void deregister(StallFeature feature) {
        Set slotSet;
        int slotValue = feature.getSweeperSlotValue();
        Set set = slotSet = (Set)this.stallFeatureSets.get(slotValue);
        synchronized (set) {
            slotSet.remove(feature);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static int getNewSlotValue() {
        int result;
        StallSweeper stallSweeper = sInstance;
        synchronized (stallSweeper) {
            result = StallSweeper.sInstance.nextSlotValue++;
            if (StallSweeper.sInstance.nextSlotValue >= 30) {
                StallSweeper.sInstance.nextSlotValue = 0;
            }
        }
        return result;
    }
}

