/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.stat.IDataAccumulator;
import com.wily.introscope.agent.trace.ASingleMetricTracerFactory;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.util.properties.AttributeListing;

public class LegacyCompatibleErrorReportingTracer
extends ASingleMetricTracerFactory {
    public LegacyCompatibleErrorReportingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        if (data.hasInvocationThrownException()) {
            Throwable error = data.getInvocationThrownException();
            String errMsg = this.buildErrorMessage(data);
            IStackElement topElement = VirtualStack.peek();
            if (ErrorFeature.evalErrorQualificationForCurrTxn(this.getAgent(), error, errMsg) && topElement != null) {
                ErrorFeature.createAndUpdateErrorRepository(this.getFormattedName(), this.getDataAccumulatorFactory(), data, this.getAgent());
                ErrorFeature.incrementUpstreamErrorMetric(data);
                ErrorFeature.constructAndSendErrorSnapshotToServerWithOtherStackElementOnTop(data, errMsg, this.getAgent(), topElement);
                ErrorFeature.decorateTransactionsWithErrorOnOtherStackElement(data, errMsg, topElement);
            }
        }
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    @Override
    protected IDataAccumulator createDataAccumulator(String formattedMetricName) {
        return null;
    }

    private String buildErrorMessage(InvocationData data) {
        String errMsg = String.valueOf(this.getFormattedResource()) + ":" + ErrorFeature.fetchErrorMessage(data);
        return errMsg;
    }
}

