/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.filter.ISampler;
import com.wily.introscope.agent.trace.IIntelligentInstrumentationStackElement;
import com.wily.introscope.agent.trace.hc2.TransactionHarvestHelper;
import com.wily.introscope.agent.trace.intelligent.CrossProcessLogger;
import com.wily.introscope.agent.trace.intelligent.DownStreamListenerService;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligenceStackElement;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentStackHelper;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceTransactionCache;
import com.wily.introscope.agent.trace.intelligent.IntelligentInstrumentationThreadLocalObject;
import com.wily.introscope.agent.trace.intelligent.IntelligentTransactionHarvesterHelper;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.util.HashMap;

public class DownstreamTransactionHarvester {
    private HighPerformanceTransactionCache highPerformanceCache = HighPerformanceTransactionCache.getInstance();
    private boolean shouldAbort = false;

    public void setAbort(boolean flag) {
        this.shouldAbort = flag;
    }

    public void sendTrace(String transactionGUID) {
        this.createAndSendTCD(transactionGUID);
    }

    public static void validateTransactionFromIntelligentInstrumentation(TransactionComponentData root, TransactionComponentData parent) {
        int numChildren;
        if (parent != null) {
            root.fixTimingData(parent);
        }
        if (root.getParameterValue("Total Methods") != null) {
            root.getParameters().remove("Total Methods");
        }
        if ((numChildren = root.getSubNodeCount()) > 0) {
            TransactionComponentData[] children = root.getSubNodes();
            int i = 0;
            while (i < numChildren) {
                DownstreamTransactionHarvester.validateTransactionFromIntelligentInstrumentation(children[i], root);
                ++i;
            }
        }
    }

    private void createAndSendTCD(final String transactionGUID) {
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] deepStacks = this.highPerformanceCache.getForTransactionTrace(transactionGUID);
        if (deepStacks == null) {
            SustainabilityMetricsHelper.reportNumberOfTracesMissedInCacheMetric(1);
            return;
        }
        boolean success = false;
        HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack[] highPerformanceIntelligenceStackElementVirtualStackArray = deepStacks;
        int n = deepStacks.length;
        int n2 = 0;
        while (n2 < n) {
            block10: {
                HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack = highPerformanceIntelligenceStackElementVirtualStackArray[n2];
                if (this.shouldAbort) {
                    return;
                }
                try {
                    try {
                        success = DownstreamTransactionHarvester.createAndSendTCDHelper(deepStack, new TCDPreSendCallback(){

                            @Override
                            public void beforeSending(TransactionComponentData tcd) {
                                if (CrossProcessLogger.isDebugEnabled()) {
                                    CrossProcessLogger.logDebugMessage("Downstream agent sent the TT for: " + transactionGUID);
                                }
                                tcd.setParameterValue("Trace Type", "Normal");
                                tcd.setParameterValue("Trace Reason", "Autotrace");
                                tcd.setParameterValue("Autotrace Trigger Criteria", "Cross Process Trigger");
                                SustainabilityMetricsHelper.reportNumberOfTracesFromCacheMetric(1);
                                DownStreamListenerService.tracesPerIntervalCount.getAndIncrement();
                            }
                        });
                    }
                    catch (Exception e) {
                        if (CrossProcessLogger.isDebugEnabled()) {
                            CrossProcessLogger.logDebugMessage("Transaction trace from cache had a failure for: " + transactionGUID, e);
                        }
                        this.highPerformanceCache.removeFromGuidCache(deepStack);
                        deepStack.reinit();
                        deepStack.trySetInUse(false);
                        break block10;
                    }
                }
                catch (Throwable throwable) {
                    this.highPerformanceCache.removeFromGuidCache(deepStack);
                    deepStack.reinit();
                    deepStack.trySetInUse(false);
                    throw throwable;
                }
                this.highPerformanceCache.removeFromGuidCache(deepStack);
                deepStack.reinit();
                deepStack.trySetInUse(false);
            }
            ++n2;
        }
        if (success) {
            this.highPerformanceCache.addUpstreamGUID(transactionGUID);
        }
    }

    public static boolean createAndSendTCDHelper(HighPerformanceIntelligenceStackElement.HighPerformanceIntelligenceStackElementVirtualStack deepStack, TCDPreSendCallback beforeSendingCallback) {
        if (!deepStack.markSentToEM()) {
            return true;
        }
        IAgent agent = HighPerformanceIntelligenceStackElement.getAgent();
        IntelligentInstrumentationThreadLocalObject tlObj = deepStack.sIntelligentThreadLocalObject;
        HashMap normalTcdHash = tlObj.fTopTCDElements;
        IIntelligentInstrumentationStackElement topElement = deepStack.getElementAt(1);
        if (topElement == null) {
            IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
            if (feedback.isDebugEnabled(ISampler.kSamplingModule)) {
                feedback.debug(ISampler.kSamplingModule, "deepStack " + deepStack + " doesn't have topElement to report?!!");
            }
            return false;
        }
        int topElementInvID = topElement.getInvocationId();
        if (topElementInvID == -1) {
            return false;
        }
        TransactionComponentData normalRootTcd = (TransactionComponentData)normalTcdHash.get(topElementInvID);
        if (normalRootTcd == null) {
            return false;
        }
        int stackElements = deepStack.getStackElementCount();
        int i = 2;
        while (i <= stackElements) {
            IIntelligentInstrumentationStackElement stackElement = deepStack.getElementAt(i);
            IntelligentTransactionHarvesterHelper.createTcd(stackElement);
            ++i;
        }
        deepStack.getElementAt(1).setTransactionComponentData(normalRootTcd);
        TransactionComponentData bizDefComponent = null;
        if (!normalRootTcd.getResource().startsWith("Business Segment") && (bizDefComponent = TransactionHarvestHelper.buildBusinessTransactionComponent(normalRootTcd)) != null) {
            HighPerformanceIntelligentStackHelper.realizeSubcomponent(bizDefComponent);
        }
        IntelligentTransactionHarvesterHelper.joinTCDSubTrees(deepStack);
        TransactionComponentData tcdToSend = bizDefComponent != null ? bizDefComponent : normalRootTcd;
        DownstreamTransactionHarvester.validateTransactionFromIntelligentInstrumentation(tcdToSend, null);
        if (beforeSendingCallback != null) {
            beforeSendingCallback.beforeSending(tcdToSend);
        }
        agent.IAgent_getTransactionTraceController().ITransactionTraceListener_reportTransaction(tcdToSend);
        deepStack.doOnTraceSendEvent();
        return true;
    }

    public boolean hasBeenAborted() {
        return this.shouldAbort;
    }

    public static interface TCDPreSendCallback {
        public void beforeSending(TransactionComponentData var1);
    }
}

