/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.intelligent;

import com.wily.agent.main.DesperationIntelligentTracerHelper;
import com.wily.agent.main.IIntelligentInstrumentationTracerHelper;
import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.correlation.CrossProcessCorrelationAdmin;
import com.wily.introscope.agent.errors.ErrorReportingService;
import com.wily.introscope.agent.feature.ErrorFeature;
import com.wily.introscope.agent.filter.ISampler;
import com.wily.introscope.agent.trace.ICallbackOnStartHarvestTransaction;
import com.wily.introscope.agent.trace.ICallbackOnTraceSendEvent;
import com.wily.introscope.agent.trace.IEntryPointShutoff;
import com.wily.introscope.agent.trace.IIntelligentInstrumentationMethodTracer;
import com.wily.introscope.agent.trace.IIntelligentInstrumentationStackElement;
import com.wily.introscope.agent.trace.IInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.IMethodTracer;
import com.wily.introscope.agent.trace.IStackElement;
import com.wily.introscope.agent.trace.ITracerFactory;
import com.wily.introscope.agent.trace.IWallClockDelegate;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ProbeInformation;
import com.wily.introscope.agent.trace.StartTransactionStackElement;
import com.wily.introscope.agent.trace.cas.AMixedTransactionElement;
import com.wily.introscope.agent.trace.cas.BlameTransactionElement;
import com.wily.introscope.agent.trace.cas.IStallPoint;
import com.wily.introscope.agent.trace.cas.IThreadLocalObjectFactory;
import com.wily.introscope.agent.trace.cas.ITransactionCache;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProvider;
import com.wily.introscope.agent.trace.cas.ITransactionCacheProviderFactory;
import com.wily.introscope.agent.trace.cas.ITransactionElement;
import com.wily.introscope.agent.trace.cas.TransactionTransitionException;
import com.wily.introscope.agent.trace.hc2.EntryPointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.intelligent.CrossProcessAutoTracingConfiguration;
import com.wily.introscope.agent.trace.intelligent.DeepTraceConfigurations;
import com.wily.introscope.agent.trace.intelligent.ErrorElementsParameterContainer;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceIntelligentStackHelper;
import com.wily.introscope.agent.trace.intelligent.HighPerformanceTransactionCache;
import com.wily.introscope.agent.trace.intelligent.IntelligentInstrumentationThreadLocalObject;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.trace.intelligent.SustainabilityMetricsHelper;
import com.wily.introscope.agent.trace.intelligent.VisibilityGapElement;
import com.wily.introscope.agent.trace.intelligent.VisibilityGapManager;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontEndCandidateAnalyzer;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontendCandidate;
import com.wily.introscope.agent.trace.intelligent.frontend.FrontendCandidatePerformance;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import com.wily.introscope.agent.transactiontrace.TransactionCollectStatus;
import com.wily.introscope.spec.server.transactiontrace.TransactionComponentData;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import java.lang.ref.WeakReference;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.atomic.AtomicBoolean;
import java.util.concurrent.atomic.AtomicInteger;

public class HighPerformanceIntelligenceStackElement
implements IIntelligentInstrumentationStackElement {
    private static final Module kModule = new Module("IISustainability");
    private static final int kOffsetToParent = 0;
    private static final int kOffsetToTime = 1;
    private static final int kOffsetToRecursionCount = 2;
    private static final int kOffsetToTracerCode = 3;
    private static final int kOffsetToStackElement = 4;
    private static final int kOffsetToStartedTransaction = 5;
    private static final int kOffsetToException = 6;
    private static final int kOffsetToLastChild = 7;
    private static final int kOffsetToChildrenDuration = 8;
    public static final int kSpaceNeededForElement = 9;
    private static volatile IIntelligentInstrumentationTracerHelper helper = null;
    private static volatile IAgent fAgent = null;
    private static volatile boolean sIsVisibilityGapProcessorEnabled = false;
    public static volatile int sMaxCount = 1000;
    public static volatile int sMaxCountSinceLastInvocationData = 10;
    private static long fTime = System.currentTimeMillis();
    private static String[] fFakeProbeInfo;
    private static final int kInitialSize = 256;
    private static final int kInitialObjectStackSize = 128;
    private static final int kInitialExceptionSize = 16;
    static final ConcurrentHashMap<ProbeIdentification, String> fCachedProbeInfoNames;
    HighPerformanceIntelligenceStackElementVirtualStack fStack;
    int fCurrentCursor = 0;

    static {
        try {
            fAgent = AgentShim.getAgent();
            fFakeProbeInfo = new String[]{"fakeProbeClassName", "fakeProbeMethodName", "fakeString", "fakeParameter", "fakeProbeClassName::fakeProbeMethodName"};
        }
        catch (AgentNotAvailableException agentNotAvailableException) {}
        fCachedProbeInfoNames = new ConcurrentHashMap(4);
    }

    public static void setIsVisibilityGapProcessorEnabled(boolean val) {
        sIsVisibilityGapProcessorEnabled = val;
    }

    public static IIntelligentInstrumentationTracerHelper getHelper() {
        if (helper == null && fAgent != null) {
            try {
                helper = fAgent.IAgent_getTracerAdministrator().getIntelligentInstrumentationService();
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }
        return helper;
    }

    public static IAgent getAgent() {
        if (fAgent == null) {
            try {
                fAgent = AgentShim.getAgent();
            }
            catch (Exception exception) {}
        }
        return fAgent;
    }

    public HighPerformanceIntelligenceStackElement(int currentCursor) {
        this.fCurrentCursor = currentCursor;
    }

    @Override
    public final long getEndTime() {
        int index = this.fStack.fStack[this.fCurrentCursor + 1];
        return this.fStack.fTimeStack[index + 1];
    }

    @Override
    public final long getStartTime() {
        int index = this.fStack.fStack[this.fCurrentCursor + 1];
        return this.fStack.fTimeStack[index];
    }

    @Override
    public boolean isInstrumentedByIntelligent() {
        return this.getProbeInfo() == null;
    }

    public final void increaseRecursionCount() {
        int index;
        int n = index = this.fCurrentCursor + 2;
        this.fStack.fStack[n] = this.fStack.fStack[n] + 1;
    }

    public final boolean decreaseRecursionCountIfNecessary() {
        int index = this.fCurrentCursor + 2;
        if (this.fStack.fStack[index] >= 0) {
            int n = index;
            this.fStack.fStack[n] = this.fStack.fStack[n] - 1;
            return true;
        }
        return false;
    }

    public final int getTracerCode() {
        int index = this.fCurrentCursor + 3;
        return this.fStack.fStack[index];
    }

    private final void setStartedTransaction() {
        int index = this.fCurrentCursor + 5;
        this.fStack.fStack[index] = 1;
    }

    public void setNotTop(boolean b) {
    }

    public final IStackElement getLastChild() {
        if (this.fCurrentCursor < 0) {
            return null;
        }
        int indexOfLastChildParent = this.fStack.fStack[this.fCurrentCursor + 7];
        if (indexOfLastChildParent == -1) {
            return null;
        }
        HighPerformanceIntelligenceStackElement lastChildElement = new HighPerformanceIntelligenceStackElement(indexOfLastChildParent);
        lastChildElement.fStack = this.fStack;
        return lastChildElement;
    }

    @Override
    public final IStackElement getParent() {
        if (this.fCurrentCursor < 0) {
            return null;
        }
        int indexOfParent = this.fStack.fStack[this.fCurrentCursor + 0];
        if (indexOfParent == -1) {
            return null;
        }
        HighPerformanceIntelligenceStackElement parentElement = new HighPerformanceIntelligenceStackElement(indexOfParent);
        parentElement.fStack = this.fStack;
        return parentElement;
    }

    @Override
    public ITransactionElement getCursor() {
        return null;
    }

    public ProbeInformation getStackElement() {
        if (this.fCurrentCursor == -1) {
            return null;
        }
        int index = this.fStack.fStack[this.fCurrentCursor + 4];
        if (index == -1) {
            return null;
        }
        ProbeInformation refProbeInfo = this.fStack.fProbeInfos[index];
        if (refProbeInfo == null && Logger.isDebugEnabled()) {
            Logger.logDebugMessage("getStackElement() referred InvocationData is null: fCurrentCursor=" + this.fCurrentCursor + "; fCount=" + this.fStack.fCount);
        }
        return refProbeInfo;
    }

    @Override
    public int getStackElementId() {
        return this.getInvocationId();
    }

    public void setInvocationThrownException(Throwable exception) {
        block5: {
            if (this.fCurrentCursor < 0) {
                return;
            }
            try {
                int index = this.fStack.fStack[this.fCurrentCursor + 6];
                try {
                    this.fStack.fExceptions[index] = exception;
                }
                catch (Throwable throwable) {
                    this.fStack.fExceptions[index] = new Exception(exception.getClass().getName());
                }
            }
            catch (Throwable throwable) {
                if (!Logger.isDebugEnabled()) break block5;
                Logger.logDebugMessage("setException generates exception, so the application exception is not set");
            }
        }
    }

    private void getTracer() {
        int tracerCode = this.fStack.fStack[this.fCurrentCursor + 3];
        if (tracerCode != -1) {
            this.fStack.fProbeInformation = null;
            this.fStack.fProbeHashCode = tracerCode;
            this.fStack.fProbeInfo = HighPerformanceIntelligenceStackElement.getHelper().getIntelligentInstrumentationInfoForSequentialHashCode(tracerCode);
            if (this.fStack.fProbeInfo == null) {
                if (Logger.isDebugEnabled()) {
                    Logger.logDebugMessage("getTracer fails for fProbeInfo: tracerCode=" + tracerCode + "; InvocationData index=" + this.fStack.fStack[this.fCurrentCursor + 4]);
                }
                this.fStack.fProbeInfo = fFakeProbeInfo;
            }
        } else {
            ProbeInformation data;
            this.fStack.fProbeInformation = data = this.getProbeInfo();
            this.fStack.fProbeInfo = null;
            if (data == null) {
                Logger.logDebugMessage("getTracer fails for fInvocationData: tracerCode=" + tracerCode + "; InvocationData index=" + this.fStack.fStack[this.fCurrentCursor + 4]);
                this.fStack.fProbeInfo = fFakeProbeInfo;
            }
        }
    }

    @Override
    public void setCursor(ITransactionElement cursor) {
    }

    @Override
    public Thread getMyThread() {
        return null;
    }

    @Override
    public long getWallClockElapsedTime() {
        return 0L;
    }

    @Override
    public long getWallClockStartTime() {
        int index = this.fStack.fStack[this.fCurrentCursor + 1];
        return this.fStack.fTimeStack[index];
    }

    @Override
    public void setStalled() {
    }

    @Override
    public boolean isStalled() {
        return false;
    }

    @Override
    public void unsetStalled() {
    }

    @Override
    public int getStartCursorsCount() {
        return 0;
    }

    @Override
    public ITransactionElement getStartCursorAt(int j) {
        return null;
    }

    @Override
    public Iterator getStartCursorsIterator() {
        return null;
    }

    @Override
    public Object get(String name) {
        return null;
    }

    @Override
    public Object put(String name, Object value) {
        return null;
    }

    @Override
    public String getComponentName() {
        String componentName = this.getElementName();
        return componentName;
    }

    @Override
    public long getWallClockFinishTime() {
        int index = this.fStack.fStack[this.fCurrentCursor + 1];
        return this.fStack.fTimeStack[index + 1];
    }

    @Override
    public void addParameterCallbacks(Map parameters) {
    }

    @Override
    public Map getParameterCallbacks(Map parameters) {
        return null;
    }

    public boolean isNotTop() {
        return false;
    }

    @Override
    public void setParameterCallback(IInvocationDataParameterCallback invocationDataCallback) {
    }

    @Override
    public void markStartTransaction() {
    }

    @Override
    public boolean hasFrontBoundary() {
        return false;
    }

    @Override
    public ITransactionElement getLastFrontendCursor() {
        return null;
    }

    @Override
    public ITransactionElement getStartTransactionElement() {
        return null;
    }

    @Override
    public void setStartTransactionElement(ITransactionElement element) {
    }

    @Override
    public void setLastFrontendCursor(ITransactionElement frontendCursor) {
    }

    @Override
    public void setStartInstancePositionAt(int position, int tracerIndex) {
    }

    @Override
    public int getStartInstancePositionAt(int tracerIndex) {
        return 0;
    }

    @Override
    public List getTransactionInstanceList() {
        return null;
    }

    @Override
    public boolean isTransactionAborted() {
        return false;
    }

    @Override
    public TransactionCollectStatus getTransactionCollectionStatus() {
        return null;
    }

    @Override
    public void setTransactionCollectStatus(TransactionCollectStatus tcs) {
    }

    @Override
    public IStallPoint getStallPoint() {
        return null;
    }

    @Override
    public void addAppMapSocketCursor(ITransactionElement cursorElement) {
    }

    @Override
    public Iterator getAppMapSocketCursors() {
        return null;
    }

    @Override
    public void notifyStackElementOfNewCrossCorrelation(Object key) {
    }

    public final boolean startedTransaction() {
        if (this.fCurrentCursor == -1) {
            return false;
        }
        int indexOfParent = this.fStack.fStack[this.fCurrentCursor + 0];
        if (indexOfParent == -1) {
            int index = this.fCurrentCursor + 2;
            return this.fStack.fStack[index] < 0;
        }
        return false;
    }

    public HighPerformanceIntelligenceStackElementVirtualStack getStack() {
        return this.fStack;
    }

    @Override
    public ITransactionElement getLastTransactionElement() {
        if (this.fCurrentCursor == -1) {
            return null;
        }
        int index = this.fStack.fStack[this.fCurrentCursor + 4];
        if (index == -1) {
            return null;
        }
        ITransactionElement ret = null;
        WeakReference<AMixedTransactionElement> ref = this.fStack.fLastStartTransactionElement[index];
        if (ref != null) {
            ret = (ITransactionElement)ref.get();
        }
        return ret;
    }

    @Override
    public ITransactionElement getFirstTransactionElement() {
        if (this.fCurrentCursor == -1) {
            return null;
        }
        int index = this.fStack.fStack[this.fCurrentCursor + 4];
        if (index == -1) {
            return null;
        }
        ITransactionElement ret = null;
        WeakReference<AMixedTransactionElement> ref = this.fStack.fFirstStartTransactionElement[index];
        if (ref != null) {
            ret = (ITransactionElement)ref.get();
        }
        return ret;
    }

    @Override
    public ProbeInformation getProbeInfo() {
        return this.getStackElement();
    }

    @Override
    public ProbeInformation getOwnProbeInfo() {
        if (this.fCurrentCursor == -1) {
            return null;
        }
        int indexOfParent = this.fStack.fStack[this.fCurrentCursor + 0];
        if (indexOfParent == -1) {
            return this.getStackElement();
        }
        ProbeInformation ownData = this.getStackElement();
        int parentStackIndex = this.fStack.fStack[indexOfParent + 4];
        ProbeInformation parentData = null;
        if (this.fStack.fProbeInfos[parentStackIndex] != null) {
            parentData = this.fStack.fProbeInfos[parentStackIndex];
        }
        if (ownData != parentData) {
            return ownData;
        }
        return null;
    }

    @Override
    public int getInvocationId() {
        if (this.fCurrentCursor == -1) {
            return -1;
        }
        int invocationDataIndex = this.fStack.fStack[this.fCurrentCursor + 4];
        if (invocationDataIndex == -1) {
            return -1;
        }
        return this.fStack.fInvocationIds[invocationDataIndex];
    }

    @Override
    public boolean hasInvocationThrownException() {
        if (this.fCurrentCursor < 0) {
            return false;
        }
        int index = this.fStack.fStack[this.fCurrentCursor + 6];
        if (index >= 0 && index < this.fStack.fExceptions.length) {
            return this.fStack.fExceptions[index] != null;
        }
        return false;
    }

    @Override
    public Throwable getInvocationThrownException() {
        if (this.fCurrentCursor == -1) {
            return null;
        }
        int index = this.fStack.fStack[this.fCurrentCursor + 6];
        if (index >= 0 && index < this.fStack.fExceptions.length) {
            return this.fStack.fExceptions[index];
        }
        return null;
    }

    @Override
    public TransactionComponentData getTransactionComponentData() {
        return this.fStack.getTcd().get(this.fCurrentCursor);
    }

    @Override
    public List getChildren() {
        List result = (List)this.fStack.getChildrenMap().get(this.fCurrentCursor);
        if (result == null) {
            result = this.getMyChildren();
            this.fStack.getChildrenMap().put(this.fCurrentCursor, result);
        }
        return result;
    }

    private List getMyChildren() {
        ArrayList<HighPerformanceIntelligenceStackElement> result = new ArrayList<HighPerformanceIntelligenceStackElement>();
        int limit = this.fStack.fCount * 9;
        int i = this.fCurrentCursor + 0;
        while (i <= limit) {
            if (this.fStack.fStack[i] == this.fCurrentCursor) {
                HighPerformanceIntelligenceStackElement element = new HighPerformanceIntelligenceStackElement(i);
                element.fStack = this.fStack;
                result.add(element);
            }
            i += 9;
        }
        return result;
    }

    @Override
    public void setTransactionComponentData(TransactionComponentData component) {
        TransactionComponentData d = this.fStack.getTcd().get(this.fCurrentCursor);
        if (d == null) {
            this.fStack.getTcd().put(this.fCurrentCursor, component);
        } else {
            TransactionComponentData[] sn = d.getSubNodes();
            while (sn != null && sn.length > 0) {
                d = sn[0];
                sn = d.getSubNodes();
            }
            d.setSubNodes(new TransactionComponentData[]{component});
        }
    }

    @Override
    public long getDuration() {
        int index = this.fStack.fStack[this.fCurrentCursor + 1];
        long duration = this.fStack.fTimeStack[index + 1] - this.fStack.fTimeStack[index];
        return duration < 0L ? 0L : duration;
    }

    @Override
    public String getElementName() {
        this.getTracer();
        return this.fStack.fProbeInformation != null ? this.getElementName(this.fStack.fProbeInformation) : this.fStack.fProbeInfo[4];
    }

    private String getElementName(ProbeInformation data) {
        String result = fCachedProbeInfoNames.get(data.getProbeIdentification());
        if (result == null) {
            result = HighPerformanceIntelligentStackHelper.getElementName(data.getProbeIdentification());
            String alreadyThere = fCachedProbeInfoNames.putIfAbsent(data.getProbeIdentification(), result);
            if (alreadyThere != null) {
                result = alreadyThere;
            }
        }
        return result;
    }

    @Override
    public String getProbeMethodName() {
        this.getTracer();
        return this.fStack.fProbeInformation != null ? this.fStack.fProbeInformation.getProbeIdentification().getProbeMethodName() : this.fStack.fProbeInfo[1];
    }

    @Override
    public String getProbeMethodDescriptor() {
        this.getTracer();
        return this.fStack.fProbeInformation != null ? this.fStack.fProbeInformation.getProbeIdentification().getProbeMethodDescriptor() : this.fStack.fProbeInfo[2];
    }

    @Override
    public String getProbeClassName() {
        this.getTracer();
        return this.fStack.fProbeInformation != null ? this.fStack.fProbeInformation.getProbeIdentification().getProbeClassName() : this.fStack.fProbeInfo[0];
    }

    @Override
    public String getProbeSourceLine() {
        int endOfProbeParams;
        this.getTracer();
        if (this.fStack.fProbeInformation != null) {
            return this.fStack.fProbeInformation.getProbeIdentification().getSourceFileLine();
        }
        String tracerEncoding = this.fStack.fProbeInfo[3];
        if (tracerEncoding != null && (endOfProbeParams = tracerEncoding.indexOf(",")) > -1) {
            String probeParams = tracerEncoding.substring(0, endOfProbeParams);
            AttributeListing probeParamList = new AttributeListing(probeParams);
            return probeParamList.get("source");
        }
        return null;
    }

    @Override
    public String getProbeMethodScoreLevel() {
        this.getTracer();
        return this.fStack.fProbeInfo[5];
    }

    @Override
    public boolean isFinished() {
        return this.getEndTime() >= this.getStartTime();
    }

    @Override
    public void setFinished(boolean finished) {
    }

    @Override
    public int getElementIndex() {
        return this.fCurrentCursor / 9;
    }

    @Override
    public void reassignTcdCursor(TransactionComponentData assignedCursor) {
        if (assignedCursor != null) {
            this.fStack.getTcd().put(this.fCurrentCursor, assignedCursor);
            return;
        }
        TransactionComponentData tcd = this.getTransactionComponentData();
        while (tcd.getSubNodes() != TransactionComponentData.kNoCalledComponents && tcd != (TransactionComponentData)tcd.getSubNode(tcd.getSubNodeCount() - 1)) {
            tcd = (TransactionComponentData)tcd.getSubNode(tcd.getSubNodeCount() - 1);
        }
        this.fStack.getTcd().put(this.fCurrentCursor, tcd);
    }

    @Override
    public void joinTCDSubTreeWithParent() {
        TransactionComponentData tcd = this.getTransactionComponentData();
        IIntelligentInstrumentationStackElement parent = (IIntelligentInstrumentationStackElement)this.getParent();
        if (parent != null) {
            parent.addTCDChild(tcd);
            this.reassignTcdCursor(null);
        }
    }

    @Override
    public void addTCDChild(TransactionComponentData tcdChild) {
        TransactionComponentData tcd = this.getTransactionComponentData();
        int countChildren = tcd.getSubNodeCount();
        if (countChildren > 0) {
            TransactionComponentData[] children = tcd.getSubNodes();
            TransactionComponentData[] childrenPlusOne = new TransactionComponentData[countChildren + 1];
            int i = 0;
            while (i < children.length) {
                childrenPlusOne[i] = children[i];
                ++i;
            }
            childrenPlusOne[children.length] = tcdChild;
            tcd.setSubNodes(childrenPlusOne);
        } else {
            tcd.setSubNodes(new TransactionComponentData[]{tcdChild});
        }
    }

    @Override
    public void setMarkedForDiscoveryTrace(boolean discoveryTrace) {
    }

    @Override
    public boolean isMarkedForDiscoveryTrace() {
        return false;
    }

    public static final class HighPerformanceIntelligenceStackElementVirtualStack
    implements ITransactionCacheProviderFactory,
    IIntelligentInstrumentationMethodTracer,
    ICallbackOnStartHarvestTransaction,
    ICallbackOnTraceSendEvent {
        AtomicBoolean fUseFlag = new AtomicBoolean(false);
        String fTransactionGUID = null;
        public final IntelligentInstrumentationThreadLocalObject sIntelligentThreadLocalObject = new IntelligentInstrumentationThreadLocalObject(false);
        private ErrorElementsParameterContainer fErrorElementsParameterContainer = new ErrorElementsParameterContainer();
        public static ITransactionCacheProviderFactory sCacheProviderFactory;
        final ITransactionCache fCache = null;
        final HighPerformanceIntelligenceStackElement fTopStackElement;
        final HighPerformanceIntelligenceStackElement fExceptionElement;
        volatile boolean fExceptionSetByMethodTracer = false;
        final HighPerformanceIntelligenceStackElement prevElement;
        final HighPerformanceIntelligenceStackElement poppedElement;
        private static final int kIncreaseBatchCardinality = 64;
        private static final int kIncreaseBatch = 576;
        private static final int kIncreaseLongBatch = 128;
        private static final int kIncreaseObjectBatchCardinality = 32;
        Object fAgentShimThreadLocal = null;
        boolean bWithinBackendCall = false;
        int fCount;
        int fDeepCompCount;
        int fRuntimeCompCount;
        int fNormalStackElementCount;
        int fCountExceptions;
        int fIncreaseSize = 255;
        int fIncreaseSizeStackElements = 127;
        int fIncreaseSizeExceptions = 15;
        int fProbeHashCode;
        boolean fShouldSetTracerFlag = false;
        boolean fHasFrontendFlag = false;
        boolean fIsBadEntryPointCheckComplete = false;
        int fCurrentFreeSpace = 0;
        boolean fTraced = false;
        private final AtomicInteger fCachedBy = new AtomicInteger(0);
        boolean fIncreased = false;
        boolean fErrorSnapshotTriggered = false;
        int fCountSinceLastInvocationData = 0;
        public int fMaxCount;
        private int fMaxCountSinceLastInvocationData;
        private int fMaxTotalComponentCount;
        private int fMaxNormalComponentCount;
        int fAllCallCounts = 0;
        int fCallCounts = 0;
        int fInvocationDataCounts = 0;
        int[] fStack = new int[2304];
        long[] fTimeStack = new long[512];
        ProbeInformation[] fProbeInfos = new ProbeInformation[128];
        int[] fInvocationIds = new int[128];
        Throwable[] fExceptions = new Throwable[16];
        String[] fProbeInfo;
        ProbeInformation fProbeInformation;
        private IWallClockDelegate fClockDelegate = null;
        WeakReference<AMixedTransactionElement>[] fFirstStartTransactionElement = new WeakReference[128];
        WeakReference<AMixedTransactionElement>[] fLastStartTransactionElement = new WeakReference[128];
        final FrontendCandidate fSuggestedFrontEnd;
        int fMaxResponseTimeSoFar = 0;
        long fMaxResponseTimeSoFarPercentage = 0L;
        final HighPerformanceIntelligenceStackElement fMaxResponseTimeElement;
        final VisibilityGapElement fLastReportedVisibilityGapElement;
        private volatile Map<Integer, TransactionComponentData> fTcd = new HashMap<Integer, TransactionComponentData>(4);
        private final HashMap<Integer, List<HighPerformanceIntelligenceStackElement>> fChildren = new HashMap(4);
        private final AtomicBoolean fTransactionWasSentToEM = new AtomicBoolean(false);
        private int fPerDeepStackGuidIndex;
        private AtomicInteger fPerGuidCounterRef;
        static final ThreadLocal<HighPerformanceIntelligenceStackElementVirtualStack> stack;
        private static final IThreadLocalObjectFactory kStackFactory;
        private static BlockingQueue<HighPerformanceIntelligenceStackElementVirtualStack> sBuffer;

        static {
            stack = new ThreadLocal<HighPerformanceIntelligenceStackElementVirtualStack>(){

                @Override
                public HighPerformanceIntelligenceStackElementVirtualStack initialValue() {
                    return (HighPerformanceIntelligenceStackElementVirtualStack)kStackFactory.makeNewThreadLocalObject();
                }
            };
            kStackFactory = new IThreadLocalObjectFactory(){

                @Override
                public Object makeNewThreadLocalObject() {
                    HighPerformanceIntelligenceStackElementVirtualStack result;
                    result.fTopStackElement.fStack = result = new HighPerformanceIntelligenceStackElementVirtualStack();
                    result.fExceptionElement.fStack = result;
                    result.prevElement.fStack = result;
                    result.poppedElement.fStack = result;
                    result.fMaxResponseTimeElement.fStack = result;
                    return result;
                }
            };
            sBuffer = new ArrayBlockingQueue<HighPerformanceIntelligenceStackElementVirtualStack>(64);
        }

        HighPerformanceIntelligenceStackElementVirtualStack() {
            this.fTopStackElement = new HighPerformanceIntelligenceStackElement(-1);
            this.prevElement = new HighPerformanceIntelligenceStackElement(-1);
            this.poppedElement = new HighPerformanceIntelligenceStackElement(-1);
            this.fExceptionElement = new HighPerformanceIntelligenceStackElement(-1);
            this.fMaxResponseTimeElement = new HighPerformanceIntelligenceStackElement(-1);
            this.fLastReportedVisibilityGapElement = new VisibilityGapElement();
            this.fSuggestedFrontEnd = new FrontendCandidate(this, fAgent);
            this.initialize();
            sCacheProviderFactory = InvocationData.getCacheHelper();
        }

        private void initialize() {
            this.fCount = 0;
            this.fDeepCompCount = 0;
            this.fRuntimeCompCount = 0;
            this.fNormalStackElementCount = 0;
            this.fCountExceptions = 0;
            this.fCountSinceLastInvocationData = 0;
            this.fCurrentFreeSpace = 0;
            this.fTraced = false;
            this.fShouldSetTracerFlag = false;
            this.fHasFrontendFlag = false;
            this.fIsBadEntryPointCheckComplete = false;
            this.fIncreased = false;
            this.fErrorSnapshotTriggered = false;
            this.fMaxCount = sMaxCount;
            this.fMaxNormalComponentCount = WilyTransactionStructure.fComponentCountClamp;
            this.initTotalCompCount();
            this.fMaxCountSinceLastInvocationData = sMaxCountSinceLastInvocationData;
            this.registerWithFrontendAnalyzer();
        }

        private void registerWithFrontendAnalyzer() {
            FrontEndCandidateAnalyzer.registerDeepStack(this);
        }

        @Override
        public ITransactionCacheProvider getProvider() {
            return null;
        }

        public static final HighPerformanceIntelligenceStackElementVirtualStack getThreadLocal() {
            HighPerformanceIntelligenceStackElementVirtualStack result;
            if (sCacheProviderFactory == null) {
                sCacheProviderFactory = InvocationData.getCacheHelper();
            }
            if (sCacheProviderFactory.isUseExternalThreadId() && (result = (HighPerformanceIntelligenceStackElementVirtualStack)sCacheProviderFactory.getExternalThreadLocalObject(0, kStackFactory)) != null) {
                return result;
            }
            return stack.get();
        }

        private static final void replaceStack(HighPerformanceIntelligenceStackElementVirtualStack replacement) {
            if (sCacheProviderFactory.isUseExternalThreadId()) {
                sCacheProviderFactory.setExternalThreadLocalObject(0, replacement);
            } else {
                stack.set(replacement);
            }
        }

        public static final IStackElement push(InvocationData stackElement) {
            HighPerformanceIntelligenceStackElementVirtualStack stack = HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            return stack.myPush(stackElement);
        }

        public final IStackElement myPush(InvocationData stackElement) {
            HighPerformanceIntelligenceStackElement cursor = this.fTopStackElement;
            if (stackElement.getInvocationId() != cursor.getInvocationId()) {
                boolean isFirstElement = this.pushElement(stackElement);
                if (isFirstElement) {
                    cursor.setStartedTransaction();
                    stackElement.setHighPerformanceIntelligenceStackElementVirtualStack(HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal());
                    return StartTransactionStackElement.getInstance();
                }
                return this.prevElement;
            }
            cursor.increaseRecursionCount();
            return cursor;
        }

        public final IStackElement myNullPush(int tracerHashCode) {
            if (tracerHashCode == this.fStack[this.fTopStackElement.fCurrentCursor + 3]) {
                this.fTopStackElement.increaseRecursionCount();
                return this.fTopStackElement;
            }
            this.pushElement(tracerHashCode);
            return this.prevElement;
        }

        private void pushElement(int tracerCode) {
            if (this.fCount == this.fIncreaseSize) {
                this.increaseSize();
            }
            ++this.fCount;
            ++this.fDeepCompCount;
            if (this.isRuntimeComponent(tracerCode)) {
                ++this.fRuntimeCompCount;
            }
            ++this.fCountSinceLastInvocationData;
            int timeIndex = this.fCount * 2;
            this.fCurrentFreeSpace += 9;
            int parentCursor = this.fTopStackElement.fCurrentCursor;
            this.prevElement.fCurrentCursor = this.fTopStackElement.fCurrentCursor;
            this.fTopStackElement.fCurrentCursor = this.fCurrentFreeSpace;
            int offset = this.fCurrentFreeSpace + 0;
            this.fStack[offset] = parentCursor;
            this.fStack[++offset] = timeIndex;
            this.fStack[++offset] = -1;
            this.fStack[++offset] = tracerCode;
            this.fStack[++offset] = -1;
            ++offset;
            this.fStack[++offset] = -1;
            this.fStack[++offset] = -1;
            this.fStack[++offset] = 0;
            long time = System.currentTimeMillis();
            if (this.fClockDelegate != null) {
                time = this.fClockDelegate.getStartTime();
            }
            this.fTimeStack[timeIndex] = time;
            this.fTimeStack[timeIndex + 1] = -1L;
            this.fStack[parentCursor + 7] = this.fTopStackElement.fCurrentCursor;
        }

        private boolean pushElement(InvocationData stackElement) {
            boolean firstMethodInTransaction;
            int currentParentIndex = this.fTopStackElement.fCurrentCursor + 0;
            boolean bl = firstMethodInTransaction = currentParentIndex == -1;
            if (this.fCount == this.fIncreaseSize) {
                this.increaseSize();
            }
            if (this.fNormalStackElementCount == this.fIncreaseSizeStackElements) {
                this.increaseSizeStackElements();
            }
            ++this.fCount;
            int timeIndex = this.fCount * 2;
            this.fCurrentFreeSpace += 9;
            int parentCursor = this.fTopStackElement.fCurrentCursor;
            this.prevElement.fCurrentCursor = this.fTopStackElement.fCurrentCursor;
            this.fTopStackElement.fCurrentCursor = this.fCurrentFreeSpace;
            int offset = this.fCurrentFreeSpace + 0;
            this.fStack[offset] = parentCursor;
            this.fStack[++offset] = timeIndex;
            this.fStack[++offset] = -1;
            this.fStack[++offset] = -1;
            long time = stackElement.getWallClockStartTime();
            if (time < 0L) {
                time = stackElement.storeWallClockStartTime();
            }
            this.fTimeStack[timeIndex] = time;
            this.fTimeStack[timeIndex + 1] = -1L;
            this.fStack[++offset] = ++this.fNormalStackElementCount;
            this.fProbeInfos[this.fNormalStackElementCount] = stackElement.getProbeInformation();
            this.fInvocationIds[this.fNormalStackElementCount] = stackElement.getInvocationId();
            ++offset;
            this.fStack[++offset] = -1;
            this.fStack[++offset] = -1;
            this.fStack[++offset] = 0;
            this.fFirstStartTransactionElement[this.fNormalStackElementCount] = null;
            this.fLastStartTransactionElement[this.fNormalStackElementCount] = null;
            int countOfElements = stackElement.getStartCursorsCount();
            ITransactionElement txElement = null;
            int i = 0;
            while (i < countOfElements) {
                txElement = stackElement.getStartCursorAt(countOfElements - i - 1);
                if (txElement != null && txElement instanceof AMixedTransactionElement) {
                    this.fLastStartTransactionElement[this.fNormalStackElementCount] = ((AMixedTransactionElement)txElement).getWeakReference();
                    break;
                }
                ++i;
            }
            if (txElement == null) {
                if (Logger.isTraceEnabled()) {
                    Logger.logTraceMessage("Unable to find cursor with AMixedTransactoinElement:" + stackElement.getComponentName());
                }
                txElement = stackElement.getCursor();
            }
            i = 0;
            while (i < countOfElements) {
                txElement = stackElement.getStartCursorAt(i);
                if (txElement != null && txElement instanceof AMixedTransactionElement) {
                    this.fFirstStartTransactionElement[this.fNormalStackElementCount] = ((AMixedTransactionElement)txElement).getWeakReference();
                    break;
                }
                ++i;
            }
            if (!firstMethodInTransaction) {
                this.fStack[parentCursor + 7] = this.fTopStackElement.fCurrentCursor;
            }
            if (stackElement.getVirtualCursor().getCurrentCache().getBackend() != null) {
                this.bWithinBackendCall = true;
            }
            return firstMethodInTransaction;
        }

        private void increaseSize() {
            int[] newfStack = new int[this.fStack.length + 576];
            System.arraycopy(this.fStack, 0, newfStack, 0, this.fStack.length);
            this.fStack = newfStack;
            long[] newfTimeStack = new long[this.fTimeStack.length + 128];
            System.arraycopy(this.fTimeStack, 0, newfTimeStack, 0, this.fTimeStack.length);
            this.fTimeStack = newfTimeStack;
            this.fIncreaseSize += 64;
        }

        private void increaseSizeStackElements() {
            int newSize = this.fProbeInfos.length + 32;
            ProbeInformation[] newfStack = new ProbeInformation[newSize];
            System.arraycopy(this.fProbeInfos, 0, newfStack, 0, this.fProbeInfos.length);
            this.fProbeInfos = newfStack;
            int[] newfIdStack = new int[newSize];
            System.arraycopy(this.fInvocationIds, 0, newfIdStack, 0, this.fInvocationIds.length);
            this.fInvocationIds = newfIdStack;
            this.fIncreaseSizeStackElements += 32;
            this.increaseSizeOfTransactionElements();
        }

        private void increaseSizeExceptions() {
            int newSize = this.fExceptions.length + 32;
            Exception[] newfStack = new Exception[newSize];
            System.arraycopy(this.fExceptions, 0, newfStack, 0, this.fExceptions.length);
            this.fExceptions = newfStack;
            this.fIncreaseSizeExceptions += 32;
        }

        private void increaseSizeOfTransactionElements() {
            int newSize = this.fFirstStartTransactionElement.length + 64;
            WeakReference[] newfStack = new WeakReference[newSize];
            System.arraycopy(this.fFirstStartTransactionElement, 0, newfStack, 0, this.fFirstStartTransactionElement.length);
            this.fFirstStartTransactionElement = newfStack;
            newfStack = new WeakReference[newSize];
            System.arraycopy(this.fLastStartTransactionElement, 0, newfStack, 0, this.fLastStartTransactionElement.length);
            this.fLastStartTransactionElement = newfStack;
        }

        public static void cleanupOnWhenTraceIsClamped() {
            HighPerformanceIntelligenceStackElementVirtualStack stack = HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            stack.prepareOnStartHarvestTransaction();
            stack.tearMeDown();
        }

        public HighPerformanceIntelligenceStackElementVirtualStack retain() {
            HighPerformanceIntelligenceStackElementVirtualStack replacement;
            List tmp;
            HighPerformanceTransactionCache highPerformanceCache = HighPerformanceTransactionCache.getInstance();
            SharedCrossProcessData cpCache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
            if (this.fShouldSetTracerFlag && this.fTraced && cpCache != null && highPerformanceCache != null && (tmp = cpCache.getListParamIn("UpstreamGUIDCache")) != null) {
                highPerformanceCache.addToQueue(tmp);
            }
            if ((replacement = (HighPerformanceIntelligenceStackElementVirtualStack)sBuffer.poll()) == null) {
                replacement = (HighPerformanceIntelligenceStackElementVirtualStack)kStackFactory.makeNewThreadLocalObject();
            }
            HighPerformanceIntelligenceStackElementVirtualStack.replaceStack(replacement);
            return this;
        }

        private HighPerformanceIntelligenceStackElementVirtualStack fromSamplersCache() {
            HighPerformanceIntelligenceStackElementVirtualStack replacement = (HighPerformanceIntelligenceStackElementVirtualStack)sBuffer.poll();
            if (replacement == null) {
                replacement = (HighPerformanceIntelligenceStackElementVirtualStack)kStackFactory.makeNewThreadLocalObject();
            }
            return replacement;
        }

        @Override
        public boolean shouldCache(ICallbackOnStartHarvestTransaction.CacheOwner cache) {
            int newValue;
            int previousValue;
            if (this.fTransactionWasSentToEM.get()) {
                return false;
            }
            do {
                if ((newValue = (previousValue = this.fCachedBy.get()) | cache.bitMask) != previousValue) continue;
                return previousValue == 0;
            } while (!this.fCachedBy.compareAndSet(previousValue, newValue));
            IModuleFeedbackChannel feedback = fAgent.IAgent_getModuleFeedback();
            if (feedback.isDebugEnabled(ISampler.kSamplingModule)) {
                feedback.debug(ISampler.kSamplingModule, "HighPerformance element " + this + " setting cached=" + (Object)((Object)cache) + ", old mask=" + previousValue + ", new mask=" + newValue);
            }
            return previousValue == 0;
        }

        private final boolean containsCache(ICallbackOnStartHarvestTransaction.CacheOwner cache) {
            return (this.fCachedBy.get() & cache.bitMask) != 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public HighPerformanceIntelligenceStackElementVirtualStack release(ICallbackOnStartHarvestTransaction.CacheOwner cache, boolean needResult) {
            AtomicInteger atomicInteger = this.fCachedBy;
            synchronized (atomicInteger) {
                block10: {
                    block11: {
                        int previousValue = this.fCachedBy.get();
                        int newValue = previousValue & ~cache.bitMask;
                        IModuleFeedbackChannel feedback = fAgent.IAgent_getModuleFeedback();
                        if (feedback.isDebugEnabled(ISampler.kSamplingModule)) {
                            feedback.debug(ISampler.kSamplingModule, "HighPerformance element " + this + " clearing cached=" + (Object)((Object)cache) + ", old mask=" + previousValue + ", new mask=" + newValue);
                        }
                        if (newValue == previousValue) {
                            if (feedback.isDebugEnabled(ISampler.kSamplingModule)) {
                                throw new IllegalArgumentException("Cannot release non-retained object " + this + " by " + (Object)((Object)cache) + ", cached mask=" + previousValue + ", sentToEm=" + this.fTransactionWasSentToEM.get() + ", traced=" + this.fTraced);
                            }
                            throw new IllegalArgumentException("Cannot release non-retained object by " + (Object)((Object)cache) + ", cached mask=" + previousValue + ", sentToEm=" + this.fTransactionWasSentToEM.get() + ", traced=" + this.fTraced);
                        }
                        this.fCachedBy.set(newValue);
                        if (newValue != 0) break block10;
                        this.reinit();
                        if (needResult) {
                            return this;
                        }
                        if (cache != ICallbackOnStartHarvestTransaction.CacheOwner.DELAYED_SAMPLER) break block11;
                        sBuffer.offer(this);
                        return null;
                    }
                    return null;
                }
                if (needResult) {
                    return this.fromSamplersCache();
                }
                return null;
            }
        }

        public final void tearMeDown() {
            if (!this.fTraced) {
                return;
            }
            HighPerformanceTransactionCache highPerformanceCache = HighPerformanceTransactionCache.getInstance();
            SharedCrossProcessData cpCache = CrossProcessCorrelationAdmin.getCrossProcessCorrelationCache();
            if (cpCache != null) {
                this.fTransactionGUID = cpCache.getCorrelationID();
                List tmp = cpCache.getListParamIn("UpstreamGUIDCache");
                if (tmp != null) {
                    highPerformanceCache.addToQueue(tmp);
                }
                if (this.fTransactionWasSentToEM.get() && this.fTransactionGUID != null) {
                    highPerformanceCache.addUpstreamGUID(this.fTransactionGUID);
                }
            }
            if (this.fTransactionWasSentToEM.get()) {
                this.reinit();
                return;
            }
            if (highPerformanceCache == null || !CrossProcessAutoTracingConfiguration.isCrossProcessAutoTracingEnabled() || this.fTransactionGUID == null) {
                this.fCachedBy.set(this.fCachedBy.get() & ~ICallbackOnStartHarvestTransaction.CacheOwner.CROSS_PROCESS.bitMask);
            }
            if (this.containsCache(ICallbackOnStartHarvestTransaction.CacheOwner.CROSS_PROCESS)) {
                highPerformanceCache.checkin(this.fTransactionGUID, this);
                HighPerformanceIntelligenceStackElementVirtualStack replacement = highPerformanceCache.checkout(false);
                if (replacement.containsCache(ICallbackOnStartHarvestTransaction.CacheOwner.CROSS_PROCESS)) {
                    HighPerformanceIntelligenceStackElementVirtualStack.replaceStack(replacement.release(ICallbackOnStartHarvestTransaction.CacheOwner.CROSS_PROCESS, true));
                } else {
                    HighPerformanceIntelligenceStackElementVirtualStack.replaceStack(replacement);
                }
                return;
            }
            if (this.containsCache(ICallbackOnStartHarvestTransaction.CacheOwner.DELAYED_SAMPLER)) {
                HighPerformanceIntelligenceStackElementVirtualStack.replaceStack(this.fromSamplersCache());
                return;
            }
            this.reinit();
        }

        private void resetUnusedObjectsInStack() {
            this.sIntelligentThreadLocalObject.reset();
            this.fErrorElementsParameterContainer.clearParams();
            if (this.fExceptions[0] != null) {
                if (this.fExceptions.length > 16) {
                    this.fExceptions = new Throwable[16];
                } else {
                    int i = 0;
                    while (i < this.fExceptions.length && this.fExceptions[i] != null) {
                        this.fExceptions[i] = null;
                        ++i;
                    }
                }
            }
        }

        void reinit() {
            this.fCallCounts = 0;
            this.fAllCallCounts = 0;
            this.fInvocationDataCounts = 0;
            if (this.fTraced) {
                this.fTopStackElement.fCurrentCursor = -1;
                this.fExceptionElement.fCurrentCursor = -1;
                this.prevElement.fCurrentCursor = -1;
                this.poppedElement.fCurrentCursor = -1;
                this.fMaxResponseTimeElement.fCurrentCursor = -1;
                this.fMaxResponseTimeSoFar = 0;
                this.fMaxResponseTimeSoFarPercentage = 0L;
                this.fTcd.clear();
                this.fChildren.clear();
                this.fCount = 0;
                this.fDeepCompCount = 0;
                this.fRuntimeCompCount = 0;
                this.fCountSinceLastInvocationData = 0;
                this.fMaxCount = sMaxCount;
                this.fMaxNormalComponentCount = WilyTransactionStructure.fComponentCountClamp;
                this.initTotalCompCount();
                this.fMaxCountSinceLastInvocationData = sMaxCountSinceLastInvocationData;
                this.fNormalStackElementCount = 0;
                this.fCountExceptions = 0;
                this.fCurrentFreeSpace = 0;
                this.fTraced = false;
                this.fShouldSetTracerFlag = false;
                this.fIsBadEntryPointCheckComplete = false;
                this.fIncreased = false;
                this.fExceptionSetByMethodTracer = false;
                this.fErrorSnapshotTriggered = false;
                this.fHasFrontendFlag = false;
                this.fCachedBy.set(0);
                this.fTransactionGUID = null;
                this.fTransactionWasSentToEM.set(false);
                this.resetUnusedObjectsInStack();
                Arrays.fill(this.fProbeInfos, null);
                this.fProbeInformation = null;
            }
        }

        @Override
        public void doOnTraceSendEvent() {
            this.fTcd = new HashMap<Integer, TransactionComponentData>(4);
        }

        private void reportVisibilityGap(HighPerformanceIntelligenceStackElement startElement) {
            if (sIsVisibilityGapProcessorEnabled) {
                if (this.fMaxResponseTimeElement.fCurrentCursor == -1) {
                    if (Logger.isTraceEnabled()) {
                        Logger.logTraceMessage("reportVisibilityGap->fMaxResponseTimeElement.fCurrentCursor:" + this.fMaxResponseTimeElement.fCurrentCursor);
                    }
                    return;
                }
                boolean shouldReport = true;
                boolean isMaxElementInstrumentedByIntelligent = this.fMaxResponseTimeElement.isInstrumentedByIntelligent();
                boolean isLastReportedElementInstrumentedByIntelligent = this.fLastReportedVisibilityGapElement.isInstrumentedByIntelligent();
                ProbeInformation maxResponseTimeElementProbeInfo = null;
                int maxResponseTimeElementTracerCode = 0;
                if (isMaxElementInstrumentedByIntelligent) {
                    maxResponseTimeElementTracerCode = this.fMaxResponseTimeElement.getTracerCode();
                    if (isLastReportedElementInstrumentedByIntelligent && maxResponseTimeElementTracerCode == this.fLastReportedVisibilityGapElement.getTracerCode()) {
                        shouldReport = false;
                    }
                } else {
                    maxResponseTimeElementProbeInfo = this.fMaxResponseTimeElement.getProbeInfo();
                    if (!isLastReportedElementInstrumentedByIntelligent && maxResponseTimeElementProbeInfo == this.fLastReportedVisibilityGapElement.getProbeInfo()) {
                        shouldReport = false;
                    }
                }
                if (shouldReport && this.exceedsVisbilityGapThreshold(startElement)) {
                    if (isMaxElementInstrumentedByIntelligent) {
                        this.fLastReportedVisibilityGapElement.setIsInstrumentedByIntelligent(true);
                        this.fLastReportedVisibilityGapElement.setTracerCode(maxResponseTimeElementTracerCode);
                        VisibilityGapManager.addMethodWithVisibilityGap(maxResponseTimeElementTracerCode, this.fMaxResponseTimeSoFarPercentage);
                        if (Logger.isDebugEnabled()) {
                            Logger.logDebugMessage("Reported Deeptrace Method with Gap:" + this.fMaxResponseTimeElement.getElementName());
                        }
                    } else {
                        this.fLastReportedVisibilityGapElement.setIsInstrumentedByIntelligent(false);
                        this.fLastReportedVisibilityGapElement.setProbeInfo(maxResponseTimeElementProbeInfo);
                        VisibilityGapManager.addMethodWithVisibilityGap(maxResponseTimeElementProbeInfo, this.fMaxResponseTimeSoFarPercentage);
                        if (Logger.isDebugEnabled()) {
                            Logger.logDebugMessage("Reported Normal Method with Gap:" + this.fMaxResponseTimeElement.getElementName());
                        }
                    }
                }
            }
        }

        private boolean exceedsVisbilityGapThreshold(HighPerformanceIntelligenceStackElement startElement) {
            if (this.fMaxResponseTimeSoFar > DeepTraceConfigurations.fVisibilityGapAbsoluteThreshold && startElement.fCurrentCursor > -1 && startElement.getDuration() > 0L) {
                this.fMaxResponseTimeSoFarPercentage = (long)(this.fMaxResponseTimeSoFar * 100) / startElement.getDuration();
                if (this.fMaxResponseTimeSoFarPercentage > (long)DeepTraceConfigurations.fVisibilityGapPercentThreshold) {
                    return true;
                }
            }
            return false;
        }

        public static void tearDown() {
            HighPerformanceIntelligenceStackElementVirtualStack stack = HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            stack.tearMeDown();
        }

        public static final IStackElement peek() {
            HighPerformanceIntelligenceStackElementVirtualStack stack = HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            return stack.fTopStackElement;
        }

        public static final IStackElement peek(HighPerformanceIntelligenceStackElementVirtualStack stack) {
            return stack.fTopStackElement;
        }

        public static final HighPerformanceIntelligenceStackElement pop(int tracerCode) {
            HighPerformanceIntelligenceStackElementVirtualStack stack = HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            return stack.myPop();
        }

        public final HighPerformanceIntelligenceStackElement myPop(InvocationData stackElement) {
            long time;
            if (this.fTopStackElement.fCurrentCursor == -1) {
                return null;
            }
            if (stackElement == null) {
                return null;
            }
            HighPerformanceIntelligenceStackElement cursor = this.fTopStackElement;
            while (stackElement.getInvocationId() != cursor.getInvocationId()) {
                int parentCursor = this.prevElement.fCurrentCursor;
                if (parentCursor == -1) {
                    return null;
                }
                this.prevElement.fCurrentCursor = this.fStack[parentCursor + 0];
                this.fTopStackElement.fCurrentCursor = parentCursor;
            }
            if (this.fStack[this.fTopStackElement.fCurrentCursor + 2] >= 0) {
                int n = this.fTopStackElement.fCurrentCursor + 2;
                this.fStack[n] = this.fStack[n] - 1;
                return this.fTopStackElement;
            }
            this.fTimeStack[this.fStack[this.fTopStackElement.fCurrentCursor + 1] + 1] = time = stackElement.getWallClockFinishTime();
            this.poppedElement.fCurrentCursor = this.fTopStackElement.fCurrentCursor;
            int parentCursor = this.prevElement.fCurrentCursor;
            this.calculateVisibilityGap(parentCursor);
            if (parentCursor != -1) {
                this.prevElement.fCurrentCursor = this.fStack[parentCursor + 0];
            }
            this.fTopStackElement.fCurrentCursor = parentCursor;
            return this.poppedElement;
        }

        private boolean findTopElement(int tracerHashCode) {
            while (tracerHashCode != this.fStack[this.fTopStackElement.fCurrentCursor + 3]) {
                int parentCursor = this.prevElement.fCurrentCursor;
                if (parentCursor == -1) {
                    return false;
                }
                this.prevElement.fCurrentCursor = this.fStack[parentCursor + 0];
                this.fTopStackElement.fCurrentCursor = parentCursor;
            }
            return true;
        }

        public final HighPerformanceIntelligenceStackElement myPop() {
            if (this.fTopStackElement.fCurrentCursor == -1) {
                return null;
            }
            if (this.fStack[this.fTopStackElement.fCurrentCursor + 2] >= 0) {
                int n = this.fTopStackElement.fCurrentCursor + 2;
                this.fStack[n] = this.fStack[n] - 1;
                return this.fTopStackElement;
            }
            long time = System.currentTimeMillis();
            if (this.fClockDelegate != null) {
                time = this.fClockDelegate.getFinishTime();
            }
            this.fTimeStack[this.fStack[this.fTopStackElement.fCurrentCursor + 1] + 1] = time;
            this.poppedElement.fCurrentCursor = this.fTopStackElement.fCurrentCursor;
            int parentCursor = this.prevElement.fCurrentCursor;
            this.calculateVisibilityGap(parentCursor);
            if (parentCursor != -1) {
                this.prevElement.fCurrentCursor = this.fStack[parentCursor + 0];
            }
            this.fTopStackElement.fCurrentCursor = parentCursor;
            return this.poppedElement;
        }

        private void calculateVisibilityGap(int parentCursor) {
            if (!sIsVisibilityGapProcessorEnabled) {
                return;
            }
            int duration = (int)(this.fTimeStack[this.fStack[this.fTopStackElement.fCurrentCursor + 1] + 1] - this.fTimeStack[this.fStack[this.fTopStackElement.fCurrentCursor + 1]]);
            if (parentCursor != -1) {
                int n = this.prevElement.fCurrentCursor + 8;
                this.fStack[n] = this.fStack[n] + duration;
            }
            int childrenTime = this.fStack[this.fTopStackElement.fCurrentCursor + 8];
            int myOwnDuration = duration - childrenTime;
            if (!this.bWithinBackendCall && myOwnDuration > this.fMaxResponseTimeSoFar) {
                this.fMaxResponseTimeElement.fCurrentCursor = this.fTopStackElement.fCurrentCursor;
                this.fMaxResponseTimeSoFar = myOwnDuration;
                if (Logger.isTraceEnabled()) {
                    Logger.logTraceMessage("fMaxResponseTimeElement.fCurrentCursor:" + this.fMaxResponseTimeElement.fCurrentCursor);
                }
            }
            if (myOwnDuration == 0 && this.isInstrumentedForVisibilityGap()) {
                this.markRemoveInstrumentationOnMethod();
            }
        }

        private void markRemoveInstrumentationOnMethod() {
            int probeHashCode = this.fStack[this.fTopStackElement.fCurrentCursor + 3];
            VisibilityGapManager.addMethodNotFillingVisibilityGap(probeHashCode);
            if (Logger.isDebugEnabled()) {
                Logger.logDebugMessage("Runtime visibilty - Removed instrumentation on method.:" + probeHashCode);
            }
        }

        private boolean isInstrumentedForVisibilityGap() {
            if (!this.fTopStackElement.isInstrumentedByIntelligent()) {
                return false;
            }
            int probeHashCode = this.fStack[this.fTopStackElement.fCurrentCursor + 3];
            String instrType = HighPerformanceIntelligenceStackElement.getHelper().getMethodInstrumentationType(probeHashCode);
            return instrType != null && instrType == "R";
        }

        private boolean isRuntimeComponent(int probeHashCode) {
            try {
                String instrType = HighPerformanceIntelligenceStackElement.getHelper().getMethodInstrumentationType(probeHashCode);
                if (instrType != null && instrType == "R") {
                    return true;
                }
            }
            catch (Exception exception) {}
            return false;
        }

        public static final IStackElement getPopped() {
            HighPerformanceIntelligenceStackElementVirtualStack stack = HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            return stack.poppedElement;
        }

        private boolean shouldSetTracer() {
            if (!this.fShouldSetTracerFlag) {
                return false;
            }
            if (this.fDeepCompCount >= this.fMaxCount) {
                this.checkForBadEntryPoint();
                return false;
            }
            if (this.fCountSinceLastInvocationData >= this.fMaxCountSinceLastInvocationData) {
                return false;
            }
            if (this.fAgentShimThreadLocal == null) {
                this.fAgentShimThreadLocal = AgentShim.getAgentShimThreadLocal();
            }
            return !AgentShim.isThreadInAgentCode(this.fAgentShimThreadLocal);
        }

        private void checkForBadEntryPoint() {
            if (this.fIsBadEntryPointCheckComplete) {
                return;
            }
            ProbeInformation pi = this.fProbeInfos[1];
            WeakReference<AMixedTransactionElement> teRef = this.fFirstStartTransactionElement[1];
            if (teRef != null) {
                AMixedTransactionElement te = (AMixedTransactionElement)teRef.get();
                ITracerFactory[] tfs = pi.getTracerFactories();
                ProbeIdentification id = pi.getProbeIdentification();
                this.fIsBadEntryPointCheckComplete = true;
                int i = 0;
                while (i < tfs.length) {
                    if (tfs[i] instanceof IEntryPointShutoff && ((IEntryPointShutoff)((Object)tfs[i])).shutoff() && tfs[i] instanceof EntryPointTracer) {
                        Logger.logDebugMessage("Automatic entrypoint withdrawn: " + id.getProbeClassName() + "." + id.getProbeMethodName() + id.getProbeMethodDescriptor());
                        IStackElement data = VirtualStack.peek();
                        if (data != null) {
                            WilyTransactionStructure.getInstance().abortTransaction(new TransactionTransitionException("Automatic Entrypoint did not return."), data);
                        }
                        this.tearMeDown();
                        if (te instanceof BlameTransactionElement) {
                            WilyTransactionStructure.getInstance().ageImmediately(te);
                        }
                        HighPerformanceIntelligenceStackElement.getHelper().removeBadPseudoFrontend(id.getProbeClassName(), id.getProbeMethodName(), id.getProbeMethodDescriptor());
                    }
                    ++i;
                }
            }
        }

        public static final IMethodTracer getThreadLocalTracerInstance(int probeHashCode) {
            HighPerformanceIntelligenceStackElementVirtualStack result = HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            ++result.fAllCallCounts;
            if (!result.shouldSetTracer()) {
                if (result.shouldSetFrontEndCandidate(probeHashCode)) {
                    return result.getFrontEndCandidate(probeHashCode);
                }
                return DesperationIntelligentTracerHelper.kDesperationTracer;
            }
            result.fProbeHashCode = probeHashCode;
            return result;
        }

        public static final IMethodTracer getThreadLocalTracerInstance(int probeHashCode, IWallClockDelegate clock) {
            HighPerformanceIntelligenceStackElementVirtualStack result = HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            ++result.fAllCallCounts;
            if (!result.shouldSetTracer()) {
                if (result.shouldSetFrontEndCandidate(probeHashCode)) {
                    return result.getFrontEndCandidate(probeHashCode);
                }
                return DesperationIntelligentTracerHelper.kDesperationTracer;
            }
            result.fProbeHashCode = probeHashCode;
            result.fClockDelegate = clock;
            return result;
        }

        private boolean isIdentifiedAsCandidateFrontend(int probeHashCode) {
            String[] probeInfo = HighPerformanceIntelligenceStackElement.getHelper().getIntelligentInstrumentationInfoForSequentialHashCode(probeHashCode);
            if (probeInfo != null) {
                if (FrontendCandidate.FrontEndCandidateState.MONITORED.toString() == probeInfo[6]) {
                    return true;
                }
                if (FrontendCandidate.FrontEndCandidateState.PSEUDOFRONTEND.toString() == probeInfo[6]) {
                    return true;
                }
            }
            return false;
        }

        private IMethodTracer getFrontEndCandidate(int probeHashCode) {
            if (this.fSuggestedFrontEnd.getProbeInfoIndex() == -1) {
                this.fSuggestedFrontEnd.initialize(probeHashCode);
            }
            return this.fSuggestedFrontEnd;
        }

        private boolean shouldSetFrontEndCandidate(int probeHashCode) {
            if (this.fAgentShimThreadLocal == null) {
                this.fAgentShimThreadLocal = AgentShim.getAgentShimThreadLocal();
            }
            return !this.fShouldSetTracerFlag && !AgentShim.isThreadInAgentCode(this.fAgentShimThreadLocal) && this.fDeepCompCount < this.fMaxCount && this.fCountSinceLastInvocationData < this.fMaxCountSinceLastInvocationData && (this.fSuggestedFrontEnd.getProbeInfoIndex() != -1 && probeHashCode == this.fSuggestedFrontEnd.getProbeInfoIndex() || this.fSuggestedFrontEnd.getProbeInfoIndex() == -1 && this.isIdentifiedAsCandidateFrontend(probeHashCode));
        }

        public static IMethodTracer getThreadLocalTracerInstance(IMethodTracer invocationData) {
            InvocationData iData = (InvocationData)invocationData;
            HighPerformanceIntelligenceStackElementVirtualStack result = HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            if (!(result.fShouldSetTracerFlag || iData.getStartedTransaction() || VirtualStack.isParentDummyVirtualElement(iData))) {
                return DesperationIntelligentTracerHelper.kDesperationTracer;
            }
            if (HighPerformanceIntelligenceStackElementVirtualStack.hasNormalComponentCountClampHit(result)) {
                return DesperationIntelligentTracerHelper.kDesperationTracer;
            }
            if (HighPerformanceIntelligenceStackElementVirtualStack.hasTotalComponentCountClampHit(result)) {
                return DesperationIntelligentTracerHelper.kDesperationTracer;
            }
            ++result.fAllCallCounts;
            return result;
        }

        private static boolean hasNormalComponentCountClampHit(HighPerformanceIntelligenceStackElementVirtualStack stack) {
            boolean result;
            boolean bl = result = stack.fNormalStackElementCount >= stack.fMaxNormalComponentCount;
            if (result) {
                stack.checkForBadEntryPoint();
            }
            return result;
        }

        private static boolean hasTotalComponentCountClampHit(HighPerformanceIntelligenceStackElementVirtualStack stack) {
            boolean result;
            boolean bl = result = stack.fCount >= stack.fMaxTotalComponentCount;
            if (result) {
                stack.checkForBadEntryPoint();
            }
            return result;
        }

        @Override
        public final void IMethodTracer_startTrace() {
            ++this.fCallCounts;
            try {
                try {
                    AgentShim.setThreadInAgentCode(this.fAgentShimThreadLocal);
                    this.myNullPush(this.fProbeHashCode);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Exception e) {
                    Logger.logException(e);
                    AgentShim.clearThreadInAgentCode(this.fAgentShimThreadLocal);
                }
            }
            finally {
                AgentShim.clearThreadInAgentCode(this.fAgentShimThreadLocal);
            }
        }

        @Override
        public void IMethodTracer_setInvocationObject(Object o) {
        }

        @Override
        public final void IMethodTracer_finishTrace() {
            try {
                try {
                    AgentShim.setThreadInAgentCode(this.fAgentShimThreadLocal);
                    HighPerformanceIntelligenceStackElement currentElement = this.myPop();
                    this.checkForTransactionEnd(currentElement);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Exception e) {
                    Logger.logException(e);
                    AgentShim.clearThreadInAgentCode(this.fAgentShimThreadLocal);
                }
            }
            finally {
                AgentShim.clearThreadInAgentCode(this.fAgentShimThreadLocal);
            }
        }

        @Override
        public final void IMethodTracer_finishTrace(int tracerHashCode) {
            try {
                try {
                    AgentShim.setThreadInAgentCode(this.fAgentShimThreadLocal);
                    HighPerformanceIntelligenceStackElement currentElement = null;
                    if (this.findTopElement(tracerHashCode)) {
                        currentElement = this.myPop();
                    }
                    this.checkForTransactionEnd(currentElement);
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Exception e) {
                    Logger.logException(e);
                    AgentShim.clearThreadInAgentCode(this.fAgentShimThreadLocal);
                }
            }
            finally {
                AgentShim.clearThreadInAgentCode(this.fAgentShimThreadLocal);
            }
        }

        private void checkForTransactionEnd(HighPerformanceIntelligenceStackElement currentElement) {
            if (currentElement != null && currentElement.startedTransaction()) {
                if (!this.fExceptionSetByMethodTracer) {
                    Throwable throwable = this.fExceptionElement.getInvocationThrownException();
                }
                this.reportVisibilityGap(currentElement);
                this.reportSustainabilityMetrics();
                this.tearMeDown();
                this.sIntelligentThreadLocalObject.fbEntryPointPassed = false;
                this.sIntelligentThreadLocalObject.fbIsSampled = false;
            }
        }

        public static final void setTracingOn() {
            HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().setMyTracingOn();
        }

        public static final void setTracingOff() {
            HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().setMyTracingOff();
        }

        public final void setMyTracingOff() {
            this.fShouldSetTracerFlag = false;
        }

        public final void setMyTracingOn() {
            this.fShouldSetTracerFlag = true;
        }

        public final boolean isMyTracingOn() {
            return this.fShouldSetTracerFlag;
        }

        public static final boolean isTracingOn() {
            return HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().fShouldSetTracerFlag;
        }

        public final boolean hasFrontend() {
            return this.fHasFrontendFlag;
        }

        public void setHasFrontendFlag(boolean b) {
            this.fHasFrontendFlag = b;
        }

        public static final boolean hasErrorSnapshotTriggered() {
            return HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().fErrorSnapshotTriggered;
        }

        public static void setErrorSnapshotTriggered(boolean b) {
            HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().fErrorSnapshotTriggered = b;
        }

        public int getStackElementCount() {
            return this.fCount;
        }

        public boolean isNotEmpty() {
            return this.fCount >= 1;
        }

        private static void setTracingOnAndTopStack() {
            HighPerformanceIntelligenceStackElementVirtualStack stack = HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal();
            stack.setMyTracingOn();
            HighPerformanceIntelligenceStackElement element = new HighPerformanceIntelligenceStackElement(stack.fTopStackElement.fCurrentCursor);
            element.fStack = stack;
            stack.sIntelligentThreadLocalObject.fTopOfStackForTT = element;
        }

        @Override
        public void IMethodTracer_startTrace(IMethodTracer tracer) {
            ++this.fInvocationDataCounts;
            this.fCountSinceLastInvocationData = 0;
            try {
                IStackElement prevElement;
                InvocationData data = (InvocationData)tracer;
                if (InvocationData.isFrontendMarkedForThisThread()) {
                    this.fHasFrontendFlag = true;
                }
                if ((prevElement = this.myPush(data)) == StartTransactionStackElement.kInstance) {
                    HighPerformanceIntelligenceStackElementVirtualStack.setTracingOnAndTopStack();
                }
            }
            catch (ThreadDeath td2) {
                throw td2;
            }
            catch (Exception e) {
                Logger.logException(e);
            }
        }

        private void initTotalCompCount() {
            this.fMaxTotalComponentCount = this.fMaxCount + WilyTransactionStructure.fComponentCountClamp;
        }

        @Override
        public void IMethodTracer_finishTrace(IMethodTracer tracer) {
            if (this.fAgentShimThreadLocal == null) {
                this.fAgentShimThreadLocal = AgentShim.getAgentShimThreadLocal();
            }
            this.fCountSinceLastInvocationData = 0;
            if (this.bWithinBackendCall && ((InvocationData)tracer).getVirtualCursor().getCurrentCache().getBackend() == null) {
                this.bWithinBackendCall = false;
            }
            HighPerformanceIntelligenceStackElement currentElement = this.myPop((InvocationData)tracer);
            this.checkForTransactionEnd(currentElement);
        }

        @Override
        public void prepareOnStartHarvestTransaction() {
            this.fTraced = true;
        }

        public Map<Integer, TransactionComponentData> getTcd() {
            return this.fTcd;
        }

        public Map getChildrenMap() {
            return this.fChildren;
        }

        @Override
        public void IIntelligentInstrumentationMethodTracer_setThrownException(Object exception) {
            try {
                if (DeepTraceConfigurations.fErrorReportingEnabled && HighPerformanceIntelligenceStackElementVirtualStack.isTracingOn() && (ErrorFeature.sThrottle == null || ErrorFeature.sThrottle.peekIsOK())) {
                    if (!(exception instanceof Throwable)) {
                        if (Logger.isDebugEnabled()) {
                            String errorMessage = "Wrong object type in IIntelligentInstrumentationMethodTracer_setThrownException(Object exception): " + exception.getClass().toString();
                            Logger.logDebugMessage(errorMessage);
                        }
                        return;
                    }
                    Throwable ex = (Throwable)exception;
                    String exceptionMessage = ErrorFeature.fetchErrorMessage(ex);
                    if (ErrorReportingService.shouldIgnore(exceptionMessage)) {
                        if (Logger.isDebugEnabled()) {
                            Logger.logDebugMessage("IIntelligentInstrumentationMethodTracer_setThrownException Ignoring Error : " + exceptionMessage);
                        }
                        return;
                    }
                    if (Logger.isDebugEnabled()) {
                        String message = "Exception in application noticed by agent: " + ex.getMessage();
                        if (Logger.isTraceEnabled()) {
                            Logger.logTraceMessage(message, ex);
                        } else {
                            Logger.logDebugMessage(message);
                        }
                    }
                    if (this.fCountExceptions == this.fIncreaseSizeExceptions) {
                        if (this.fCountExceptions < DeepTraceConfigurations.fMaxExceptionsCollected) {
                            this.increaseSizeExceptions();
                        } else {
                            this.fCountExceptions = 0;
                        }
                    }
                    if (this.fExceptionElement.getInvocationThrownException() != exception) {
                        // empty if block
                    }
                    HighPerformanceIntelligenceStackElement currElement = this.fTopStackElement;
                    int exceptionIndex = currElement.fCurrentCursor + 6;
                    this.fStack[exceptionIndex] = ++this.fCountExceptions;
                    currElement.setInvocationThrownException((Throwable)exception);
                    this.fExceptionElement.fCurrentCursor = this.fTopStackElement.fCurrentCursor;
                }
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                try {
                    if (Logger.isTraceEnabled()) {
                        Logger.logTraceMessage(t.getMessage(), t);
                    }
                }
                catch (ThreadDeath td2) {
                    throw td2;
                }
                catch (Throwable throwable) {}
            }
        }

        @Override
        public void IIntelligentInstrumentationMethodTracer_setThrownException(Object exception, IMethodTracer methodTracer) {
            if (!(exception instanceof Throwable)) {
                if (Logger.isDebugEnabled()) {
                    String errorMessage = "Wrong object type in IIntelligentInstrumentationMethodTracer_setThrownException(Object exception, IMethodTracer methodTracer): " + exception.getClass().toString();
                    Logger.logDebugMessage(errorMessage);
                }
                return;
            }
            this.IIntelligentInstrumentationMethodTracer_setThrownException(exception);
            this.fExceptionSetByMethodTracer = true;
        }

        @Override
        public Object IIntelligentInstrumentationMethodTracer_getExceptionElement() {
            if (this.fExceptionElement.fCurrentCursor > 0) {
                return this.fExceptionElement;
            }
            return null;
        }

        public static HighPerformanceIntelligenceStackElement getExceptionElement() {
            return (HighPerformanceIntelligenceStackElement)HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().IIntelligentInstrumentationMethodTracer_getExceptionElement();
        }

        public static boolean containsException() {
            HighPerformanceIntelligenceStackElement ee = HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().fExceptionElement;
            return ee != null && ee.fCurrentCursor != -1;
        }

        public static boolean isExceptionElement(int elementCursor) {
            HighPerformanceIntelligenceStackElement ee = HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().fExceptionElement;
            return ee != null && ee.fCurrentCursor != -1 && ee.fCurrentCursor == elementCursor;
        }

        private void reportSustainabilityMetrics() {
            SustainabilityMetricsHelper.reportDeepTraceSustainabilityMetrics(this.fCallCounts, this.getStackElementCount(), this.fStack.length);
            SustainabilityMetricsHelper.reportRuntimeComponentsInTransaction(this.fRuntimeCompCount);
        }

        @Override
        public void setUseExternalThreadId() {
        }

        @Override
        public boolean setExternalThreadId(String tid, Object conn, boolean createIfNew) {
            return false;
        }

        public void setExternalThreadId(String tid) {
        }

        @Override
        public void invalidateThreadsFromConnection(Object conn) {
        }

        @Override
        public int getExternalThreadCount() {
            return 0;
        }

        public static ErrorElementsParameterContainer getErrorElementsParameterContainer() {
            return HighPerformanceIntelligenceStackElementVirtualStack.getThreadLocal().fErrorElementsParameterContainer;
        }

        @Override
        public boolean IMethodTracer_shouldStub() {
            return false;
        }

        @Override
        public void IMethodTracer_setShouldStub(boolean flag) {
        }

        public static void reportFrontEndCandidateData(FrontendCandidate frontendCandidate) {
            FrontendCandidatePerformance fecp = FrontEndCandidateAnalyzer.getFrontendCandidatePerformance(frontendCandidate.getProbeInfoIndex());
            if (fecp != null) {
                fecp.incrementCompletedTransactionCount();
            }
        }

        public FrontendCandidate getFrontendCandidate() {
            return this.fSuggestedFrontEnd;
        }

        public boolean isFrontendCandidateMarked() {
            FrontendCandidate candidate = this.getFrontendCandidate();
            if (this.getFrontendCandidate().getProbeInfoIndex() == -1) {
                return false;
            }
            candidate.setHasTouchedBackend();
            return true;
        }

        @Override
        public void IMethodTracer_setReentrancyOverwrite(boolean flag) {
        }

        @Override
        public boolean isUseExternalThreadId() {
            return false;
        }

        @Override
        public Object getExternalThreadLocalObject(int idx, IThreadLocalObjectFactory factory) {
            return null;
        }

        @Override
        public Object setExternalThreadLocalObject(int idx, Object replacement) {
            return null;
        }

        @Override
        public void clearExternalThread() {
        }

        @Override
        public void clearExternalThread(Runnable thread) {
        }

        public IIntelligentInstrumentationStackElement getElementAt(int i) {
            if (this.fCount < i) {
                return null;
            }
            int index = i * 9;
            HighPerformanceIntelligenceStackElement element = new HighPerformanceIntelligenceStackElement(index);
            element.fStack = this;
            return element;
        }

        public boolean isInUse() {
            return this.fUseFlag.get();
        }

        public String getTransactionGUID() {
            return this.fTransactionGUID;
        }

        public void setInUse(boolean b) {
            this.fUseFlag.set(b);
        }

        public boolean trySetInUse(boolean b) {
            return this.fUseFlag.compareAndSet(!b, b);
        }

        public boolean markSentToEM() {
            return this.fTransactionWasSentToEM.compareAndSet(false, true);
        }

        public int getPerDeepStackGuidIndex() {
            return this.fPerDeepStackGuidIndex;
        }

        public AtomicInteger getPerGuidCounterRef() {
            return this.fPerGuidCounterRef;
        }

        public void setPerDeepStackGuidIndex(int i) {
            this.fPerDeepStackGuidIndex = i;
        }

        public void setPerGuidCounterRef(AtomicInteger counterRef) {
            this.fPerGuidCounterRef = counterRef;
        }
    }
}

