/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.transactiontrace;

import com.wily.introscope.agent.transactiontrace.ICrossProcessDataManager;
import com.wily.introscope.agent.transactiontrace.IPlatformCrossProcessDataHelper;
import com.wily.introscope.agent.transactiontrace.SharedCrossProcessData;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import javax.naming.NameNotFoundException;

public class CrossProcessDataHelper
implements ICrossProcessDataManager {
    private Set helpers;
    private volatile boolean hasAnyHelpers = false;
    private static final CrossProcessDataHelper instance = new CrossProcessDataHelper();

    public CrossProcessDataHelper() {
        SharedCrossProcessData.addCrossProcessDataCallback(new SharedCrossProcessData.ICrossProcessDataCallBack(){

            @Override
            public void prepareOptionalParameters(SharedCrossProcessData data) {
                if (!data.isCrossThreadId()) {
                    Long currentTime = System.currentTimeMillis();
                    data.addParamOut("CallerTimestamp", currentTime.toString());
                }
            }
        });
        SharedCrossProcessData.addPostCrossProcessCallback(new SharedCrossProcessData.IPostCrossProcessCallBack(){

            @Override
            public void postCrossProcessCleanup(SharedCrossProcessData data) {
                data.removeParamOut("NBThreadTxn");
            }
        });
    }

    public static CrossProcessDataHelper getInstance() {
        return instance;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public IPlatformCrossProcessDataHelper getValidEjbCrossProcessHelper() throws NameNotFoundException {
        HashSet copyOfHelpers = null;
        if (this.hasAnyHelpers) {
            CrossProcessDataHelper crossProcessDataHelper = this;
            synchronized (crossProcessDataHelper) {
                if (this.hasAnyHelpers) {
                    copyOfHelpers = new HashSet(this.helpers);
                }
            }
            boolean breakLoop = false;
            Iterator it = copyOfHelpers.iterator();
            while (it.hasNext() && !breakLoop) {
                IPlatformCrossProcessDataHelper helper = (IPlatformCrossProcessDataHelper)it.next();
                int validStatus = helper.isValidForPlatform();
                if (validStatus != 0) continue;
                return helper;
            }
        }
        return null;
    }

    @Override
    public synchronized void register(IPlatformCrossProcessDataHelper helper) {
        if (this.helpers == null) {
            this.helpers = new HashSet();
        }
        this.helpers.add(helper);
        this.hasAnyHelpers = true;
    }

    @Override
    public synchronized void unregister(IPlatformCrossProcessDataHelper helper) {
        if (this.helpers != null) {
            this.helpers.remove(helper);
        }
    }
}

