/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.stat.gatherer;

import com.wily.introscope.spec.metric.IncompatibleTypesException;
import com.wily.introscope.spec.server.beans.metricdata.IMetricDataValue;
import com.wily.introscope.stat.blame.BlameStackSnapshot;
import com.wily.introscope.stat.gatherer.AConstantGatherer;
import com.wily.introscope.stat.timeslice.ATimeslicedValue;
import com.wily.introscope.stat.timeslice.StringTimeslicedValue;
import com.wily.wilyassert.Assertion;

public class StringConstantGatherer
extends AConstantGatherer {
    private String fValue;

    public StringConstantGatherer(int typeCookie, long startTimestamp) {
        super(typeCookie, startTimestamp);
        Assertion.wilyAssert(false);
    }

    public StringConstantGatherer(int typeCookie, long startTimestamp, String constantValue) {
        this(typeCookie, startTimestamp);
        this.noteDataIsPresent();
        this.setStringValue(constantValue);
    }

    public String getStringValue() {
        return this.fValue;
    }

    public void setStringValue(String newValue) {
        this.fValue = newValue;
    }

    @Override
    protected ATimeslicedValue doConstantHarvest(long when, BlameStackSnapshot blameStack) {
        if (this.isDataAbsent()) {
            return new StringTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, true);
        }
        return new StringTimeslicedValue(this.getESETypeCookie(), this.getStartTimestampInMillis(), when, blameStack, this.getStringValue());
    }

    @Override
    protected void doAcceptAggregateTimeslicedValue(IMetricDataValue value) throws IncompatibleTypesException {
        if (value.getDataPointCount() != 0L) {
            StringTimeslicedValue typedValue = StringTimeslicedValue.checkedCast(value);
            this.setStringValue(typedValue.getString());
        }
    }
}

