/*
 * Decompiled with CFR 0.152.
 */
package com.wily.org.apache.log4j.net;

import com.wily.org.apache.log4j.AppenderSkeleton;
import com.wily.org.apache.log4j.Layout;
import com.wily.org.apache.log4j.helpers.LogLog;
import com.wily.org.apache.log4j.spi.LoggingEvent;
import java.io.IOException;
import java.io.PrintWriter;
import java.net.ServerSocket;
import java.net.Socket;
import java.util.Enumeration;
import java.util.Vector;

public class TelnetAppender
extends AppenderSkeleton {
    private SocketHandler sh;
    private int port = 23;

    public boolean requiresLayout() {
        return true;
    }

    public void activateOptions() {
        try {
            this.sh = new SocketHandler(this.port);
            this.sh.start();
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public int getPort() {
        return this.port;
    }

    public void setPort(int port) {
        this.port = port;
    }

    public void close() {
        this.sh.finalize();
    }

    protected void append(LoggingEvent event) {
        String[] s;
        this.sh.send(this.layout.format(event));
        if (this.layout.ignoresThrowable() && (s = event.getThrowableStrRep()) != null) {
            int len = s.length;
            int i = 0;
            while (i < len) {
                this.sh.send(s[i]);
                this.sh.send(Layout.LINE_SEP);
                ++i;
            }
        }
    }

    protected class SocketHandler
    extends Thread {
        private boolean done = false;
        private Vector writers = new Vector();
        private Vector connections = new Vector();
        private ServerSocket serverSocket;
        private int MAX_CONNECTIONS = 20;

        public void finalize() {
            Enumeration e = this.connections.elements();
            while (e.hasMoreElements()) {
                try {
                    ((Socket)e.nextElement()).close();
                }
                catch (Exception exception) {}
            }
            try {
                this.serverSocket.close();
            }
            catch (Exception exception) {}
            this.done = true;
        }

        public void send(String message) {
            Enumeration ce = this.connections.elements();
            Enumeration e = this.writers.elements();
            while (e.hasMoreElements()) {
                Socket sock = (Socket)ce.nextElement();
                PrintWriter writer = (PrintWriter)e.nextElement();
                writer.print(message);
                if (!writer.checkError()) continue;
                this.connections.remove(sock);
                this.writers.remove(writer);
            }
        }

        public void run() {
            while (!this.done) {
                try {
                    Socket newClient = this.serverSocket.accept();
                    PrintWriter pw = new PrintWriter(newClient.getOutputStream());
                    if (this.connections.size() < this.MAX_CONNECTIONS) {
                        this.connections.addElement(newClient);
                        this.writers.addElement(pw);
                        pw.print("TelnetAppender v1.0 (" + this.connections.size() + " active connections)\r\n\r\n");
                        pw.flush();
                        continue;
                    }
                    pw.print("Too many connections.\r\n");
                    pw.flush();
                    newClient.close();
                }
                catch (Exception e) {
                    LogLog.error("Encountered error while in SocketHandler loop.", e);
                }
            }
        }

        public SocketHandler(int port) throws IOException {
            this.serverSocket = new ServerSocket(port);
        }
    }
}

