/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.ConnectionUtils;
import com.ca.apm.agent.jmxclient.ControlledErrorLogger;
import com.ca.apm.agent.jmxclient.Utils;
import com.ca.apm.agent.jmxclient.api.ConnectionStatusUpdater;
import com.ca.apm.agent.jmxclient.api.JmxConnectionInfo;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.ca.apm.agent.jmxclient.api.JmxNodePoller;
import com.ca.apm.agent.jmxclient.api.JmxPollingClient;
import com.ca.apm.agent.jmxclient.api.JmxPollingEventListener;
import com.ca.apm.agent.jmxclient.api.PollingBehavior;
import com.ca.apm.agent.jmxclient.api.PollingTask;
import com.ca.apm.agent.jmxclient.api.TaskExecutor;
import com.ca.apm.agent.jmxclient.api.TaskTimeoutThreadPool;
import com.ca.apm.agent.jmxclient.atc.JmxAtcService;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.transformer.dynamic.IOverheadListener;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import java.lang.management.ManagementFactory;
import java.util.Collections;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.Delayed;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.ScheduledFuture;
import java.util.concurrent.ScheduledThreadPoolExecutor;
import java.util.concurrent.ThreadPoolExecutor;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import javax.management.MBeanServerConnection;
import javax.management.remote.JMXConnector;

class BasicJmxPollingClientImpl
implements JmxPollingClient,
IOverheadListener {
    public static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private static final ControlledErrorLogger ERROR_LOGGER = Configuration.createErrorLoggerInstance();
    private final Map<JmxNodeInfo, ContextualFuture> pollingTasks = new ConcurrentHashMap<JmxNodeInfo, ContextualFuture>();
    private final Set<JmxNodeInfo> configuredNodes = Collections.newSetFromMap(new ConcurrentHashMap());
    private final Lock configUpdate = new ReentrantLock();
    private final ConnectionStatusUpdater statusUpdater = new ConnectionStatusUpdater();
    private final ScheduledThreadPoolExecutor schedulingBoundedPool;
    private final ThreadPoolExecutor scalablePool;
    private final TaskExecutor scheduledPoolProxy;
    private final long reconnectionInterval;
    protected volatile boolean isClosed = false;
    private final Set<JmxPollingEventListener> listeners = new HashSet<JmxPollingEventListener>();

    public BasicJmxPollingClientImpl() {
        this(Configuration.getDiscoveryIntervalMillis(), true);
    }

    public BasicJmxPollingClientImpl(boolean isAtcSupportRequired) {
        this(Configuration.getDiscoveryIntervalMillis(), isAtcSupportRequired);
    }

    private BasicJmxPollingClientImpl(long reconnectionInterval, boolean isAtcSupportRequired) {
        this.reconnectionInterval = reconnectionInterval;
        ScheduledThreadPoolExecutor pool = this.createNewBoundedThreadPool();
        this.scheduledPoolProxy = this.createAbstractExecutorInstance(pool);
        this.schedulingBoundedPool = pool;
        this.scalablePool = new TaskTimeoutThreadPool(15L, TimeUnit.SECONDS, this.scheduledPoolProxy);
        if (isAtcSupportRequired && Configuration.shouldBuildAtcMap()) {
            this.listeners.add(new JmxAtcService(this.scheduledPoolProxy));
        }
        this.listeners.add(this.statusUpdater);
        OverheadAdministrator.registerOverheadControlSubscriber((IOverheadListener)this);
    }

    @Override
    public void startPolling(Set<JmxNodeInfo> nodes) {
        LOGGER.logDebugMessage("JMX polling requested for nodes: " + nodes);
        if (this.isClosed) {
            LOGGER.logDebugMessage("JMX polling client is closed");
            return;
        }
        this.startPollingNew(nodes);
    }

    @Override
    public void startPolling(JmxNodeInfo node) {
        this.startPolling(BasicJmxPollingClientImpl.getAsSet(node));
    }

    @Override
    public void startPolling(String host, int port) {
        this.startPolling(new JmxNodeInfo(host, port));
    }

    @Override
    public Set<JmxNodeInfo> getConfigNodes() {
        return new HashSet<JmxNodeInfo>(this.configuredNodes);
    }

    public int getConfigNodeCount() {
        return this.configuredNodes.size();
    }

    protected void addToConfigNodes(Set<JmxNodeInfo> nodes) {
        this.configuredNodes.addAll(nodes);
    }

    protected void addToConfigNodes(JmxNodeInfo node) {
        this.configuredNodes.add(node);
    }

    protected boolean removeConfigNode(JmxNodeInfo node) {
        this.configUpdate.lock();
        try {
            boolean bl = this.configuredNodes.remove(node);
            return bl;
        }
        finally {
            this.configUpdate.unlock();
        }
    }

    @Override
    public boolean isPolling(JmxNodeInfo node) {
        return this.configuredNodes.contains(node);
    }

    private Set<JmxNodeInfo> getCurrentNodes() {
        return this.pollingTasks.keySet();
    }

    @Override
    public void close() {
        this.stopPolling();
        this.stopDiscovery();
        this.listeners.clear();
        this.isClosed = true;
    }

    private void submitDiscoveryTask(Set<JmxNodeInfo> nodes) {
        this.scheduledPoolProxy.submit(this.createDiscoveryTask(nodes));
    }

    @Deprecated
    public void update(Set<JmxNodeInfo> nodes) {
        Set<JmxNodeInfo> existing = this.getConfigNodes();
        if (!nodes.equals(existing)) {
            LOGGER.logDebugMessage("JMX nodes list changed. Existing nodes: " + nodes + ", New nodes: " + nodes);
            LOGGER.logDebugMessage("Restarting polling client");
            this.stopPolling();
            this.startPolling(nodes);
        }
    }

    private void rediscover(JmxNodeInfo node) {
        if (this.getConfigNodes().contains(node)) {
            LOGGER.logDebugMessage("Submitting rediscovery task for server:" + node.getHostPort());
            this.scheduledPoolProxy.schedule(this.createDiscoveryTask(BasicJmxPollingClientImpl.getAsSet(node)), this.reconnectionInterval, TimeUnit.MILLISECONDS);
        }
    }

    private Runnable createDiscoveryTask(final Set<JmxNodeInfo> nodes) {
        return new Runnable(){

            @Override
            public void run() {
                try {
                    BasicJmxPollingClientImpl.this.discover(nodes);
                }
                catch (Exception e) {
                    ERROR_LOGGER.logError("JMX Discovery Failed for nodes " + nodes, e);
                }
            }
        };
    }

    private void discover(Set<JmxNodeInfo> jmxNodes) {
        LOGGER.logDebugMessage("Running connection discovery for servers: " + jmxNodes);
        for (JmxNodeInfo node : jmxNodes) {
            this.startPollingNode(node);
        }
    }

    private ScheduledThreadPoolExecutor createNewBoundedThreadPool() {
        ScheduledThreadPoolExecutor executor = new ScheduledThreadPoolExecutor(Configuration.getInitialPoolSize(), Utils.createNewThreadFactoryInstance("work scheduling thread"));
        executor.setMaximumPoolSize(Configuration.getMaxPoolSize());
        executor.setContinueExistingPeriodicTasksAfterShutdownPolicy(false);
        executor.setExecuteExistingDelayedTasksAfterShutdownPolicy(false);
        executor.setRemoveOnCancelPolicy(true);
        return executor;
    }

    private void stopDiscovery() {
        if (this.schedulingBoundedPool != null) {
            this.schedulingBoundedPool.shutdownNow();
        }
    }

    protected void startPollingNew(Set<JmxNodeInfo> nodes) {
        if (nodes.isEmpty()) {
            return;
        }
        int maxConnections = Configuration.getMaxJmxConnections();
        if (this.getConfigNodeCount() + nodes.size() > maxConnections) {
            LOGGER.logDebugMessage("Ignoring polling request for new nodes: " + nodes + " because it will make agent exceed Jmx connections limit of " + maxConnections);
            return;
        }
        this.addToConfigNodes(nodes);
        LOGGER.logDebugMessage("Using existing executor for polling new nodes: " + nodes);
        this.submitDiscoveryTask(nodes);
    }

    private PollingBehavior startPollingNode(final JmxNodeInfo node) {
        boolean isLocalConnection = false;
        try {
            MBeanServerConnection mbeanServer;
            ContextualFuture scheduledFuture = this.pollingTasks.get(node);
            if (scheduledFuture != null) {
                LOGGER.logDebugMessage("Jmx Poller already exists for server " + node.getConnInfo().getHostPort() + ".Skipped starting new one.");
                return scheduledFuture.getPollingTask();
            }
            final JMXConnector connector = ConnectionUtils.getJmxServerConnector(node.getConnInfo());
            JmxConnectionInfo connInfo = node.getConnInfo();
            if (connInfo.getHostPort().endsWith(":0")) {
                isLocalConnection = true;
                mbeanServer = ManagementFactory.getPlatformMBeanServer();
            } else {
                mbeanServer = connector.getMBeanServerConnection();
            }
            LOGGER.logInfoMessage("Jmx client successfully connected to server " + node.getConnInfo().getHostPort());
            if (OverheadMode.ABSOLUTE_LOW != OverheadAdministrator.getOverheadMode()) {
                this.notifyListenersOnStart(node);
            }
            Runnable onStopCallback = new Runnable(){

                @Override
                public void run() {
                    BasicJmxPollingClientImpl.this.notifyListenersOnStop(node);
                    BasicJmxPollingClientImpl.this.cancelPollingTask(node);
                    if (connector != null) {
                        ConnectionUtils.closeJmxServerConnector(connector);
                    }
                }
            };
            Runnable reregisterCallback = new Runnable(){

                @Override
                public void run() {
                    BasicJmxPollingClientImpl.this.rediscover(node);
                }
            };
            JmxNodePoller task = new JmxNodePoller(Configuration.getAgent(), mbeanServer, node, onStopCallback, reregisterCallback, this.scheduledPoolProxy);
            ContextualFuture contextFuture = new ContextualFuture(task);
            ContextualFuture result = this.pollingTasks.get(node);
            if (result == null || result.equals(contextFuture)) {
                this.configUpdate.lock();
                try {
                    if (this.isPolling(node)) {
                        this.pollingTasks.put(node, contextFuture);
                        ScheduledFuture<?> future = this.scheduledPoolProxy.scheduleAtFixedRate(task, Configuration.getPollingIntervalMillis(node), TimeUnit.MILLISECONDS);
                        contextFuture.setFuture(future);
                        LOGGER.logDebugMessage("Scheduled Poller for server " + node.getConnInfo().getHostPort());
                    }
                    LOGGER.logDebugMessage("Skipped creating poller for server: " + node.getConnInfo().getHostPort() + " Because it has been removed from target nodes");
                }
                finally {
                    this.configUpdate.unlock();
                }
            } else {
                LOGGER.logDebugMessage("Jmx Poller already exists(2) for server  " + node.getConnInfo().getHostPort());
            }
            this.logDiagnosticInfo();
            return task;
        }
        catch (Exception e) {
            if (isLocalConnection) {
                LOGGER.logWarningMessage("JMX Connection Failed to Server " + node.getConnInfo().getHostPort());
                LOGGER.logDebugMessage("JMX Connection Exception: ", (Throwable)e);
            } else {
                ERROR_LOGGER.logError("JMX Connection Failed to Server " + node.getConnInfo().getHostPort(), e);
            }
            this.rediscover(node);
            return null;
        }
    }

    private void notifyListenersOnStart(JmxNodeInfo node) {
        for (JmxPollingEventListener listener : this.listeners) {
            listener.notifyOnPollingStart(node);
        }
    }

    private void notifyListenersOnStop(JmxNodeInfo node) {
        for (JmxPollingEventListener listener : this.listeners) {
            listener.notifyOnPollingStop(node);
        }
    }

    private void cancelPollingTask(JmxNodeInfo node) {
        ContextualFuture cf = this.pollingTasks.remove(node);
        if (cf != null) {
            this.logDiagnosticInfo();
            ScheduledFuture<?> pollingTask = cf.getFuture();
            if (pollingTask != null && pollingTask.cancel(true)) {
                LOGGER.logDebugMessage("Cancelled polling task for node: " + node);
            }
        }
    }

    @Override
    public void stopPolling(JmxNodeInfo node) {
        LOGGER.logDebugMessage("Stopping JMX polling for node: " + node);
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTraceMessage("Current configured nodes: " + this.getConfigNodes());
        }
        if (this.removeConfigNode(node)) {
            ContextualFuture cf = this.pollingTasks.get(node);
            if (cf != null) {
                cf.getPollingTask().stop();
            }
            this.statusUpdater.remove(node);
        }
    }

    @Override
    public void stopPolling(Set<JmxNodeInfo> nodes) {
        for (JmxNodeInfo node : nodes) {
            this.stopPolling(node);
        }
    }

    private void stopPolling() {
        LOGGER.logDebugMessage("Stopping polling client");
        for (JmxNodeInfo node : this.getConfigNodes()) {
            this.stopPolling(node);
            this.notifyListenersOnStop(node);
        }
        this.scalablePool.shutdown();
    }

    private static Set<JmxNodeInfo> getAsSet(JmxNodeInfo node) {
        HashSet<JmxNodeInfo> nodes = new HashSet<JmxNodeInfo>();
        nodes.add(node);
        return nodes;
    }

    private TaskExecutor createAbstractExecutorInstance(final ScheduledThreadPoolExecutor schedulingBoundedPool) {
        return new TaskExecutor(){

            @Override
            public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long period, TimeUnit unit) {
                return this.scheduleAtFixedRate(task, 0L, period, unit);
            }

            @Override
            public ScheduledFuture<?> scheduleAtFixedRate(Runnable task, long delay, long period, TimeUnit unit) {
                return this.wrapAsAsyncFuture(schedulingBoundedPool.scheduleAtFixedRate(this.wrapAsAsyncTask(task), delay, period, unit));
            }

            @Override
            public ScheduledFuture<?> schedule(Runnable task, long period, TimeUnit unit) {
                return this.wrapAsAsyncFuture(schedulingBoundedPool.schedule(this.wrapAsAsyncTask(task), period, unit));
            }

            @Override
            public Future<?> submit(Runnable task) {
                return new AsyncFuture(schedulingBoundedPool.submit(this.wrapAsAsyncTask(task)));
            }

            private Runnable wrapAsAsyncTask(Runnable task) {
                return new AsyncTask(BasicJmxPollingClientImpl.this.scalablePool, task);
            }

            private ScheduledFuture<?> wrapAsAsyncFuture(ScheduledFuture<?> future) {
                return new AsyncScheduledFuture(future);
            }
        };
    }

    @Override
    public boolean addEventListener(JmxPollingEventListener listener) {
        return this.isClosed ? false : this.listeners.add(listener);
    }

    @Override
    public boolean removeEventListener(JmxPollingEventListener listener) {
        return this.isClosed ? false : this.listeners.remove(listener);
    }

    private void logDiagnosticInfo() {
        if (LOGGER.isTraceEnabled()) {
            LOGGER.logTraceMessage("pollingTasks size = " + this.pollingTasks.size());
            LOGGER.logTraceMessage("pollingTasks = " + this.pollingTasks);
            LOGGER.logTraceMessage("schedulingBoundedPool queue size = " + this.schedulingBoundedPool.getQueue().size());
            LOGGER.logTraceMessage("schedulingBoundedPool active thread count = " + this.schedulingBoundedPool.getActiveCount());
            LOGGER.logTraceMessage("scalablePool active thread count = " + this.scalablePool.getActiveCount());
        }
    }

    public void setOverheadMode(OverheadMode mode) {
        if (mode == OverheadMode.ABSOLUTE_LOW) {
            this.stopPolling();
        }
        if (mode == OverheadMode.DEFAULT) {
            Set<JmxNodeInfo> nodes = this.getConfigNodes();
            this.startPollingNew(nodes);
            for (JmxNodeInfo node : nodes) {
                this.startPolling(node);
                this.notifyListenersOnStart(node);
            }
        }
    }

    public OverheadMode getCurrentOverheadMode() {
        return null;
    }

    public Set<JmxNodeInfo> getActiveNodes() {
        return this.pollingTasks.keySet();
    }

    private static class AsyncFuture<T>
    implements Future<T> {
        final Future<T> delegate;

        AsyncFuture(Future<T> future) {
            this.delegate = future;
        }

        @Override
        public boolean cancel(boolean mayInterruptIfRunning) {
            return this.delegate.cancel(mayInterruptIfRunning);
        }

        @Override
        public boolean isCancelled() {
            return this.delegate.isCancelled();
        }

        @Override
        public boolean isDone() {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public T get() throws InterruptedException, ExecutionException {
            throw new UnsupportedOperationException("not supported");
        }

        @Override
        public T get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
            throw new UnsupportedOperationException("not supported");
        }
    }

    private static class AsyncScheduledFuture<T>
    extends AsyncFuture<T>
    implements ScheduledFuture<T> {
        final ScheduledFuture<T> delegate;

        AsyncScheduledFuture(ScheduledFuture<T> future) {
            super(future);
            this.delegate = future;
        }

        @Override
        public long getDelay(TimeUnit unit) {
            return this.delegate.getDelay(unit);
        }

        @Override
        public int compareTo(Delayed o) {
            return this.delegate.compareTo(o);
        }
    }

    private static class AsyncTask
    implements Runnable {
        private final ThreadPoolExecutor pool;
        private final Runnable task;

        AsyncTask(ThreadPoolExecutor pool, Runnable task) {
            this.pool = pool;
            this.task = task;
        }

        @Override
        public void run() {
            this.pool.submit(this.task);
        }
    }

    private class ContextualFuture {
        private volatile ScheduledFuture<?> future;
        private final PollingTask task;

        ContextualFuture(PollingTask task) {
            this.task = task;
        }

        public ScheduledFuture<?> getFuture() {
            return this.future;
        }

        public void setFuture(ScheduledFuture<?> future) {
            this.future = future;
        }

        public PollingTask getPollingTask() {
            return this.task;
        }
    }
}

