/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.BeanConfigElement;
import com.ca.apm.agent.jmxclient.api.ConfigElements;
import com.wily.introscope.agent.trace.intelligent.Logger;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.yaml.snakeyaml.Yaml;
import org.yaml.snakeyaml.constructor.BaseConstructor;
import org.yaml.snakeyaml.constructor.Constructor;

public class ConfigurationReader {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();

    public static Set<BeanConfigElement> readModuleConfig(String[] modulePaths) {
        HashSet<BeanConfigElement> elements = new HashSet<BeanConfigElement>();
        if (modulePaths != null) {
            String[] stringArray = modulePaths;
            int n = modulePaths.length;
            int n2 = 0;
            while (n2 < n) {
                String modulePath = stringArray[n2];
                try {
                    elements.addAll(ConfigurationReader.updateScriptPath(ConfigurationReader.readConfigFile(ConfigurationReader.getConfigFilePath(modulePath)), modulePath));
                }
                catch (Exception e) {
                    LOGGER.logError("Could not load configuration for module: " + modulePath);
                    LOGGER.logDebugMessage(e.getMessage(), (Throwable)e);
                }
                ++n2;
            }
        }
        return elements;
    }

    public static Set<BeanConfigElement> readConfigFile(String path) {
        HashSet<BeanConfigElement> elements = new HashSet<BeanConfigElement>();
        try {
            Throwable throwable = null;
            Object var3_5 = null;
            try (FileInputStream fis = new FileInputStream(path);){
                elements.addAll(ConfigurationReader.readConfig(fis));
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        catch (IOException e) {
            LOGGER.logDebugMessage(e.getMessage(), (Throwable)e);
        }
        return elements;
    }

    public static List<BeanConfigElement> readConfig(InputStream stream) {
        ConfigElements config = ConfigurationReader.readConfigStream(stream);
        return config != null ? config.getConfigElements() : Collections.emptyList();
    }

    private static ConfigElements readConfigStream(InputStream stream) {
        Yaml yaml = new Yaml((BaseConstructor)new Constructor(ConfigElements.class));
        ConfigElements config = (ConfigElements)yaml.load(stream);
        return config;
    }

    private static String getConfigFilePath(String modulePath) throws FileNotFoundException {
        String[] exts;
        String[] stringArray = exts = new String[]{"jmx.yml", "jmx.yaml"};
        int n = exts.length;
        int n2 = 0;
        while (n2 < n) {
            String ext = stringArray[n2];
            File f = new File(modulePath, ext);
            if (f.exists()) {
                return f.getAbsolutePath();
            }
            ++n2;
        }
        throw new FileNotFoundException(String.valueOf(modulePath) + File.separator + "jmx.yml");
    }

    private static Set<BeanConfigElement> updateScriptPath(Set<BeanConfigElement> elements, String modulePath) {
        for (BeanConfigElement el : elements) {
            String script = el.getValueTransformer();
            if (script == null || script.isEmpty() || !script.endsWith(".js")) continue;
            el.setValueTransformer(String.valueOf(modulePath) + File.separator + "scripts" + File.separator + script);
        }
        return elements;
    }
}

