/*
 * Decompiled with CFR 0.152.
 */
package com.ca.apm.agent.jmxclient.api;

import com.ca.apm.agent.jmxclient.Configuration;
import com.ca.apm.agent.jmxclient.api.AttributeFetchException;
import com.ca.apm.agent.jmxclient.api.BeanConfiguration;
import com.ca.apm.agent.jmxclient.api.JmxBeanPoller;
import com.ca.apm.agent.jmxclient.api.JmxNodeInfo;
import com.ca.apm.agent.jmxclient.api.PollingTask;
import com.ca.apm.agent.jmxclient.api.TaskExecutor;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.trace.intelligent.Logger;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import java.util.HashSet;
import java.util.Set;
import java.util.concurrent.atomic.AtomicReference;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;

public class JmxNodePoller
implements PollingTask {
    private static final Logger.ILoggingHandler LOGGER = Configuration.getLogger();
    private final MBeanServerConnection mbeanServer;
    private final JmxNodeInfo jmxNode;
    private final Runnable onStopCallback;
    private final Runnable reregisterCallback;
    private final AtomicReference<BeanConfiguration> serverConfig = new AtomicReference();
    private final Set<ObjectName> blackListedBeans = new HashSet<ObjectName>();
    private final TaskExecutor taskExecutor;

    JmxNodePoller(IAgent agent, MBeanServerConnection mServerConn, JmxNodeInfo jmxNode, Runnable onStopCallback, Runnable reregisterCallback, TaskExecutor taskExecutor) {
        this.mbeanServer = mServerConn;
        this.jmxNode = jmxNode;
        this.onStopCallback = onStopCallback;
        this.reregisterCallback = reregisterCallback;
        this.taskExecutor = taskExecutor;
        this.serverConfig.set(new BeanConfiguration(mServerConn, jmxNode, taskExecutor));
    }

    @Override
    public void run() {
        try {
            if (OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode()) {
                return;
            }
            if (LOGGER.isTraceEnabled()) {
                LOGGER.logTraceMessage("Polling server : " + this.jmxNode.getHostPort());
            }
            for (JmxBeanPoller poller : this.serverConfig.get().getPollersForServerNode()) {
                try {
                    poller.poll(this.mbeanServer);
                }
                catch (AttributeFetchException e) {
                    LOGGER.logDebugMessage("Got exception while fetching MBean data " + this.jmxNode.getHostPort(), (Throwable)e);
                }
            }
            if (this.blackListedBeans.size() > 0) {
                LOGGER.logDebugMessage("blacklisting beans:" + this.blackListedBeans);
                this.serverConfig.get().close();
                this.serverConfig.set(new BeanConfiguration(this.mbeanServer, this.jmxNode, this.blackListedBeans, this.taskExecutor));
                this.blackListedBeans.clear();
            }
        }
        catch (Throwable e) {
            LOGGER.logDebugMessage("Got exception while polling for server on " + this.jmxNode.getHostPort(), e);
            this.stop();
            this.reregisterCallback.run();
            return;
        }
    }

    @Override
    public void stop() {
        LOGGER.logDebugMessage("Stopping jmx poller for server on " + this.jmxNode.getHostPort());
        for (JmxBeanPoller poller : this.serverConfig.get().getPollersForServerNode()) {
            poller.onStop();
        }
        this.serverConfig.get().close();
        try {
            this.onStopCallback.run();
        }
        catch (Exception e) {
            LOGGER.logException(e);
        }
    }
}

