/*
 * Decompiled with CFR 0.152.
 */
package com.wily.isengard.client.transport.websocket;

import com.wily.isengard.client.transport.websocket.ProxySupport;
import com.wily.isengard.client.transport.websocket.WebSocketAdapter;
import com.wily.isengard.client.transport.websocket.WebSocketClientImpl;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.io.IOException;
import java.net.InetAddress;
import java.net.Proxy;
import java.net.SocketException;
import java.net.URI;
import java.nio.ByteBuffer;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLSocket;
import org.java_websocket.client.WebSocketClient;
import org.java_websocket.handshake.ServerHandshake;

public class WebSocketClientJavaImpl
extends WebSocketClient
implements WebSocketClientImpl {
    private final WebSocketAdapter adapter;
    private final IModuleFeedbackChannel feedback;
    private final Module module;
    private SSLContext sslContext;
    private String[] ciphers;
    private String[] protocols;

    public WebSocketClientJavaImpl(URI serverUri, Map<String, String> httpHeaders, WebSocketAdapter adapter) {
        super(serverUri, httpHeaders);
        this.adapter = adapter;
        this.feedback = adapter.getFeedbackChannel();
        this.module = adapter.getModule();
        this.setConnectionLostTimeout(0);
    }

    @Override
    public void connect(int connectionTimeout) throws IOException {
        try {
            Proxy proxy;
            if (this.sslContext != null) {
                SSLSocket socket = (SSLSocket)this.sslContext.getSocketFactory().createSocket();
                if (this.ciphers != null && this.ciphers.length > 0) {
                    socket.setEnabledCipherSuites(this.ciphers);
                }
                if (this.protocols != null && this.protocols.length > 0) {
                    socket.setEnabledProtocols(this.protocols);
                }
                this.setSocket(socket);
            }
            if ((proxy = ProxySupport.getProxy()) != null) {
                this.setProxy(proxy);
            }
            this.connectBlocking(connectionTimeout, TimeUnit.MILLISECONDS);
        }
        catch (InterruptedException e) {
            this.feedback.debug(this.module, "InterruptedException: ", (Throwable)e);
        }
    }

    @Override
    public void onClose(int frameCode, String info, boolean remote) {
        String side = remote ? "remote" : "local";
        this.feedback.info(this.module, "WebSocket Client closed by " + side + " with code=" + frameCode + ", " + info);
        this.adapter.onClose();
    }

    @Override
    public void onError(Exception e) {
        this.feedback.error(this.module, "WebSocket Client caught " + e.getClass().getName() + ": " + e.getMessage());
        this.feedback.debug(this.module, "Exception caught: ", (Throwable)e);
    }

    @Override
    public void onMessage(String text) {
        this.feedback.error(this.module, "WebSocket Client Received unexpected text data: " + text);
    }

    @Override
    public void onMessage(ByteBuffer bytes) {
        this.adapter.onMessage(bytes);
    }

    @Override
    public void onOpen(ServerHandshake data) {
        this.feedback.info(this.module, "WebSocket connection opened.");
    }

    @Override
    public void close() {
        try {
            this.closeBlocking();
        }
        catch (InterruptedException interruptedException) {}
    }

    @Override
    public int getPort() {
        return this.getSocket().getPort();
    }

    @Override
    public InetAddress getInetAddress() {
        return this.getSocket().getInetAddress();
    }

    @Override
    public void setSoTimeout(int timeout) throws SocketException {
        this.getSocket().setSoTimeout(timeout);
    }

    @Override
    public int getSoTimeout() throws SocketException {
        return this.getSocket().getSoTimeout();
    }

    @Override
    public void setSSLContext(SSLContext sslctx, String[] ciphers, String[] protocols, String serverHost, int port) {
        this.sslContext = sslctx;
        this.ciphers = ciphers;
        this.protocols = protocols;
    }
}

