/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.extensions.service;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.service.IAgentService;
import com.wily.util.IConfigurationListener;
import com.wily.util.properties.IndexedProperties;
import java.util.Map;

public class MapTracingService
implements IAgentService {
    public static final String fBlameStackPluginType = "blamestack";
    private IConfigurationListener fListener;
    private boolean fTraceEnabled = false;
    private IAgent fAgent;

    public final int IAgentService_getServiceVersion() {
        return 2;
    }

    public final void IAgentService_startService(IAgent agent, Map parameters) throws Exception {
        boolean isSoaMapEnabled = agent.IAgent_getIndexedProperties().getBooleanProperty("com.wily.introscope.agent.soa.mapdependency.enabled", false);
        if (!isSoaMapEnabled) {
            agent.IAgent_getModuleFeedback().info("MapTracingService: SOA Dependency-Map is disabled.");
            return;
        }
        this.doStartService(agent, parameters);
    }

    private void registerBlameStack(IAgent agent) {
        if (this.fTraceEnabled) {
            agent.IAgent_getModuleFeedback().info("MapTracingService: dependencyMap has been enabled");
        } else {
            agent.IAgent_getModuleFeedback().info("MapTracingService: dependencyMap has been disabled");
        }
        agent.IAgent_getExtensionsTraceController().registerBlameStackWithPluginType(fBlameStackPluginType);
        agent.IAgent_getModuleFeedback().debug("MapTracingService: trying to registerBlameStack with the controller");
    }

    protected void doStartService(IAgent agent, Map parameters) throws Exception {
        this.fAgent = agent;
        agent.IAgent_getModuleFeedback().info("MapTracingService has started");
        this.fTraceEnabled = agent.IAgent_getIndexedProperties().getBooleanProperty("com.wily.introscope.agent.transactiontrace.boundaryTracing.enable", true);
        this.registerBlameStack(agent);
        this.fListener = new MapConfigurationListener(this);
        agent.addConfigurationListener(this.fListener);
    }

    private void checkAndUpdate(IndexedProperties props) {
        boolean traceEnabled = props.getBooleanProperty("com.wily.introscope.agent.transactiontrace.boundaryTracing.enable", true);
        if (traceEnabled != this.fTraceEnabled) {
            this.fAgent.IAgent_getModuleFeedback().info("MapTracingService: BundledTrace enable property has changed to " + traceEnabled);
            this.fTraceEnabled = traceEnabled;
            this.registerBlameStack(this.fAgent);
        }
    }

    private static class MapConfigurationListener
    implements IConfigurationListener {
        MapTracingService parent;

        public MapConfigurationListener(MapTracingService parent) {
            this.parent = parent;
        }

        public void onChange(IndexedProperties props) {
            this.parent.checkAndUpdate(props);
        }
    }
}

