/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.sqlagent.hc2;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.sqlagent.StatementToConnectionCache;
import com.wily.introscope.agent.sqlagent.StatementToConnectionMappingTracer;
import com.wily.introscope.agent.trace.ASingleInstanceTracerFactory;
import com.wily.introscope.agent.trace.ICacheableInvocationDataTracerFactory;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.cas.RepositoryFactory;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.jdbc.SQLNameFormatterUtilities;
import com.wily.introscope.agent.transformer.dynamic.OverheadAdministrator;
import com.wily.introscope.agent.transformer.dynamic.OverheadMode;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.adt.ICappedMap;
import com.wily.util.adt.IGuaranteedCounter;
import com.wily.util.adt.IWeakIdentityMap;
import com.wily.util.adt.WeakIdentityHashMap;
import com.wily.util.feedback.Module;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.hot.BooleanConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.wilyassert.Assertion;
import java.lang.ref.WeakReference;
import java.sql.Connection;
import java.sql.Statement;
import java.text.MessageFormat;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;

public final class StatementToConnectionMappingTracer
extends ASingleInstanceTracerFactory
implements ICacheableInvocationDataTracerFactory {
    private static final MessageFormat kFormatter = new MessageFormat("Backends|{0}:Active Connection Object Count");
    private static final String kMetricFormatString = "Backends|$1:Connection Count";
    public static final String kStatementTypeKey = "statementtype";
    public static final int kStatementTypeDefault = 0;
    public static final int kStatementTypeOracleWrapped = 1;
    private static final String kNoticeConnectionCountProperty = "introscope.agent.sqlagent.countActiveConnections";
    private final int statementType;
    private static final Module kModule = new Module("StatementToConnectionMappingTracer");
    private static volatile ConnectionCountingBehavior sConnectionCountingBehavior;
    private static volatile HighPerformanceConnectionCountingBehavior sHPConnectionCountingBehavior;
    private static volatile StatementToConnectionMappingTracer.IOnCloseRemoveConnection sClosedConnectionRemover;
    private static volatile boolean kCountConnections;

    private static synchronized void addBehaviorIfNecessary(IAgent agent) {
        if (sConnectionCountingBehavior == null && sHPConnectionCountingBehavior == null) {
            agent.IAgent_getConfigurationManager().add((ConfigurationProperty)new NoticeConnectionCountProperty(agent), true);
            IWeakIdentityMap connToUrlCache = SQLNameFormatterUtilities.getConnectionsToURLCache();
            if (connToUrlCache != null) {
                sHPConnectionCountingBehavior = new HighPerformanceConnectionCountingBehavior(agent, connToUrlCache, SQLNameFormatterUtilities.isCacheConnectionsUrls());
                ((ICappedMap)connToUrlCache).setCallback((ICappedMap.IOnEntryRemovedListener)sHPConnectionCountingBehavior);
                agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)sHPConnectionCountingBehavior, "SQL Agent connection count metric", true, 7500L, true);
                sClosedConnectionRemover = sHPConnectionCountingBehavior;
            } else {
                sConnectionCountingBehavior = new ConnectionCountingBehavior(agent);
                agent.IAgent_getCommonHeartbeat().addBehavior((ITimestampedRunnable)sConnectionCountingBehavior, "SQL Agent connection count metric", true, 7500L, true);
                sClosedConnectionRemover = sConnectionCountingBehavior;
            }
        }
    }

    public StatementToConnectionMappingTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        StatementToConnectionMappingTracer.addBehaviorIfNecessary(agent);
        this.statementType = this.getIntegerParameter(kStatementTypeKey, 0);
    }

    public final ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    public final boolean ITracerFactory_isShutoff() {
        return false;
    }

    public final void ITracer_startTrace(int tracerIndex, InvocationData data) {
    }

    public final void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        Object connection;
        Object object = connection = this.statementType == 0 ? data.getInvocationObject() : data.getInvocationParameterAsObject(0);
        if (connection == null) {
            return;
        }
        if (!(connection instanceof Connection)) {
            Assertion.wilyAssert((String)"Expected a Connection");
            return;
        }
        Object statement = data.getInvocationReturnValueAsObject();
        if (statement == null) {
            return;
        }
        if (!(statement instanceof Statement)) {
            Assertion.wilyAssert((String)"Expected a Statement");
            return;
        }
        StatementToConnectionCache.sStatementToConnectionCache.put(statement, connection);
        if (kCountConnections) {
            this.noticeConnection(data, connection);
        }
    }

    public static Connection getConnection(Object statement) {
        Object shouldBeConnection;
        Connection result = null;
        if (statement != null && (shouldBeConnection = StatementToConnectionCache.sStatementToConnectionCache.get(statement)) instanceof Connection) {
            result = (Connection)shouldBeConnection;
        }
        return result;
    }

    public static void removeConnection(Connection connection) {
        if (sClosedConnectionRemover != null) {
            sClosedConnectionRemover.remove(connection);
        }
    }

    private void noticeConnection(InvocationData data, Object o) {
        if (o == null) {
            return;
        }
        if (!(o instanceof Connection)) {
            Assertion.wilyAssert((String)"expected a Connection");
            return;
        }
        Connection c = (Connection)o;
        if (sConnectionCountingBehavior != null) {
            String metricName = this.formatParameterizedName(data);
            if (metricName.indexOf("Unknown Database") == -1) {
                sConnectionCountingBehavior.noticeNewConnection(metricName, c);
            }
        } else if (sHPConnectionCountingBehavior != null) {
            sHPConnectionCountingBehavior.noticeNewConnection(c);
        }
    }

    public boolean canCacheInvocationData() {
        return true;
    }

    public boolean canCacheTracerInstances() {
        return true;
    }

    public boolean canCacheComponentNames() {
        return true;
    }

    private static boolean checkWithOverheadMgr() {
        return OverheadMode.LOW_WITH_ONLY_FRONTEND_BACKEND == OverheadAdministrator.getOverheadMode() || OverheadMode.ABSOLUTE_LOW == OverheadAdministrator.getOverheadMode();
    }

    private static final class ConnectionCountingBehavior
    implements ITimestampedRunnable,
    StatementToConnectionMappingTracer.IOnCloseRemoveConnection {
        private static final int kConnToMetricArraySize = 32;
        private static final int kConnToMetricBitmap = 31;
        private static final WeakIdentityHashMap[] sConnToMetric = new WeakIdentityHashMap[32];
        private final IAgent fAgent;

        static {
            int i = 0;
            while (i < 32) {
                ConnectionCountingBehavior.sConnToMetric[i] = new WeakIdentityHashMap();
                ++i;
            }
        }

        public ConnectionCountingBehavior(IAgent agent) {
            this.fAgent = agent;
        }

        private WeakIdentityHashMap getConnToMetricMap(Object connection) {
            return sConnToMetric[this.getIndex(connection)];
        }

        private int getIndex(Object connection) {
            int index = System.identityHashCode(connection) & 0x1F;
            return index;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void noticeNewConnection(String metricName, Connection connection) {
            WeakIdentityHashMap connections;
            WeakIdentityHashMap weakIdentityHashMap = connections = this.getConnToMetricMap(connection);
            synchronized (weakIdentityHashMap) {
                connections.put((Object)connection, (Object)metricName);
            }
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            this.updateConnectionCounts(nowInMillis);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void updateConnectionCounts(long nowInMillis) {
            if (StatementToConnectionMappingTracer.checkWithOverheadMgr()) {
                return;
            }
            HashMap<Object, int[]> metricNameToCount = new HashMap<Object, int[]>();
            int i = 0;
            while (i < 32) {
                Set entries = null;
                WeakIdentityHashMap weakIdentityHashMap = sConnToMetric[i];
                synchronized (weakIdentityHashMap) {
                    entries = sConnToMetric[i].entrySet();
                }
                if (kCountConnections) {
                    for (WeakIdentityHashMap.Entry entry : entries) {
                        Object metricName = entry.getValue();
                        if (metricName == null) continue;
                        int[] count = (int[])metricNameToCount.get(metricName);
                        if (count == null) {
                            count = new int[1];
                            metricNameToCount.put(metricName, count);
                        }
                        count[0] = count[0] + 1;
                    }
                }
                ++i;
            }
            if (kCountConnections) {
                for (String metricName : metricNameToCount.keySet()) {
                    final int value = ((int[])metricNameToCount.get(metricName))[0];
                    final long timeStamp = nowInMillis;
                    RepositoryFactory.ISafeGetMetricOfTypeResultCallBack result = new RepositoryFactory.ISafeGetMetricOfTypeResultCallBack(){

                        public void onSuccess(AgentMetric metric) {
                            IRepository sds = BlamePointTracer.getCountImmediateRepository((boolean)false);
                            IRepository existingSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)metric, (IRepository)sds);
                            if (existingSds != null) {
                                sds = existingSds;
                            }
                            sds.update(BlamePointTracer.getNonCombiningUpdater(), (long)value, timeStamp, 0);
                        }

                        public void onFailure(AgentMetric metric) {
                        }
                    };
                    RepositoryFactory.safeGetMetricOfType((IAgent)this.fAgent, (String)metricName, (int)257, (String)"Invalid Names:Invalid name given for a long interval counter metric", (RepositoryFactory.ISafeGetMetricOfTypeResultCallBack)result);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void remove(Connection connection) {
            WeakIdentityHashMap connections;
            WeakIdentityHashMap weakIdentityHashMap = connections = this.getConnToMetricMap(connection);
            synchronized (weakIdentityHashMap) {
                connections.remove((Object)connection);
            }
        }
    }

    private static final class HighPerformanceConnectionCountingBehavior
    implements ITimestampedRunnable,
    ICappedMap.IOnEntryRemovedListener,
    StatementToConnectionMappingTracer.IOnCloseRemoveConnection {
        private final IAgent fAgent;
        private final ConcurrentHashMap fFormattedNamesToCountMap;
        private final Map fUrlToNamesMap;
        private final IWeakIdentityMap fConnectionsToUrlsMap;
        private final boolean fConnectionsAreCachedAlready;

        public HighPerformanceConnectionCountingBehavior(IAgent agent, IWeakIdentityMap connToUrlCache, boolean connectionsUrlsAreCachedAlready) {
            this.fAgent = agent;
            this.fConnectionsAreCachedAlready = connectionsUrlsAreCachedAlready;
            this.fFormattedNamesToCountMap = new ConcurrentHashMap();
            this.fConnectionsToUrlsMap = connToUrlCache;
            this.fUrlToNamesMap = SQLNameFormatterUtilities.getURLToFormattedNameCache();
        }

        public void ITimestampedRunnable_execute(long nowInMillis) {
            if (kCountConnections) {
                this.updateConnectionCounts(nowInMillis);
            }
        }

        private void updateConnectionCounts(long nowInMillis) {
            if (StatementToConnectionMappingTracer.checkWithOverheadMgr()) {
                return;
            }
            ICappedMap map = (ICappedMap)this.fConnectionsToUrlsMap;
            map.iterateThrougEntries(new ICappedMap.IOperateOnEntry(){

                public void doOnEntry(Map.Entry entry) {
                    WeakReference wr = (WeakReference)entry.getKey();
                    Connection conn = (Connection)wr.get();
                    if (conn != null) {
                        Object url = entry.getValue();
                        HighPerformanceConnectionCountingBehavior.this.addToMetricCount(conn, url);
                    }
                }
            });
            for (Map.Entry entry : this.fFormattedNamesToCountMap.entrySet()) {
                String cfr_ignored_0 = (String)entry.getKey();
                Object[] countAndRepository = (Object[])entry.getValue();
                int value = ((IGuaranteedCounter)countAndRepository[0]).getAndSet(0);
                IRepository sds = (IRepository)countAndRepository[1];
                if (sds == null) continue;
                sds.update(BlamePointTracer.getNonCombiningUpdater(), (long)value, nowInMillis, 0);
            }
        }

        public void noticeNewConnection(Connection c) {
            if (!this.fConnectionsAreCachedAlready) {
                SQLNameFormatterUtilities.getInstance();
                this.fConnectionsToUrlsMap.putWeak((Object)c, (Object)SQLNameFormatterUtilities.getSafeURL(this.fAgent.IAgent_getModuleFeedback(), c));
            }
        }

        public void onEntryRemoved(Map.Entry eldest) {
            WeakReference wr;
            Connection conn;
            if (kCountConnections && (conn = (Connection)(wr = (WeakReference)eldest.getKey()).get()) != null) {
                Object url = eldest.getValue();
                this.addToMetricCount(conn, url);
            }
        }

        private void addToMetricCount(Connection conn, Object url) {
            Object[] countAndRepository;
            if (url == null) {
                return;
            }
            Object name = this.fUrlToNamesMap.get(url);
            if (name == null) {
                name = SQLNameFormatterUtilities.getInstance().computeFormattedString(conn, url.toString(), this.fAgent.IAgent_getModuleFeedback(), this.fAgent.IAgent_getStringLocalizer());
                this.fUrlToNamesMap.put(url, name);
            }
            if ((countAndRepository = (Object[])this.fFormattedNamesToCountMap.get(name)) == null) {
                IGuaranteedCounter integer = this.fAgent.IAgent_getGuaranteedCounter();
                final Object[] newCountAndRepository = new Object[]{integer, null};
                final Object key = name;
                Object[] alreadyExisting = this.fFormattedNamesToCountMap.putIfAbsent(name, newCountAndRepository);
                if (alreadyExisting != null) {
                    ((IGuaranteedCounter)alreadyExisting[0]).next();
                } else {
                    String metricName = kFormatter.format(new Object[]{name});
                    RepositoryFactory.ISafeGetMetricOfTypeResultCallBack result = new RepositoryFactory.ISafeGetMetricOfTypeResultCallBack(){

                        public void onSuccess(AgentMetric metric) {
                            IRepository sds = BlamePointTracer.getCountImmediateRepository((boolean)false);
                            IRepository existingSds = WilyTransactionStructure.putIntoGlobalGathererIfAbsent((AgentMetric)metric, (IRepository)sds);
                            if (existingSds != null) {
                                sds = existingSds;
                            }
                            ((IGuaranteedCounter)newCountAndRepository[0]).next();
                            newCountAndRepository[1] = sds;
                        }

                        public void onFailure(AgentMetric metric) {
                            HighPerformanceConnectionCountingBehavior.this.fFormattedNamesToCountMap.remove(key);
                        }
                    };
                    RepositoryFactory.safeGetMetricOfType((IAgent)this.fAgent, (String)metricName, (int)257, (String)"Invalid Names:Invalid name given for a long interval counter metric", (RepositoryFactory.ISafeGetMetricOfTypeResultCallBack)result);
                }
            } else {
                ((IGuaranteedCounter)countAndRepository[0]).next();
            }
        }

        @Override
        public void remove(Connection connection) {
            this.fConnectionsToUrlsMap.removeWeak((Object)connection);
        }
    }

    static final class NoticeConnectionCountProperty
    extends BooleanConfigurationProperty {
        private NoticeConnectionCountProperty(IAgent agent) {
            super(StatementToConnectionMappingTracer.kNoticeConnectionCountProperty, Boolean.TRUE, agent.IAgent_getModuleFeedback(), kModule, agent.IAgent_getStringLocalizer());
        }

        public void set(Object newValue) {
            kCountConnections = (Boolean)newValue;
        }
    }
}

