/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.swing.SearchableComboBox;
import com.wily.ui.swing.WilySearchableComboBoxEditor;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import javax.swing.ComboBoxEditor;
import javax.swing.JComboBox;
import javax.swing.JComponent;
import javax.swing.ListCellRenderer;
import javax.swing.SwingUtilities;
import javax.swing.event.ListDataEvent;
import javax.swing.event.ListDataListener;
import javax.swing.plaf.ComponentUI;
import javax.swing.plaf.basic.BasicComboBoxUI;
import javax.swing.plaf.basic.BasicComboPopup;
import javax.swing.plaf.basic.ComboPopup;
import javax.swing.plaf.metal.MetalComboBoxUI;

public class WilySearchableComboBoxUI
extends MetalComboBoxUI {
    protected boolean isTableCellEditor = false;
    protected static final String IS_TABLE_CELL_EDITOR = "JComboBox.isTableCellEditor";

    public static ComponentUI createUI(JComponent c) {
        return new WilySearchableComboBoxUI();
    }

    public JComboBox getComboBox() {
        return this.comboBox;
    }

    protected ComboPopup createPopup() {
        return new WilyComboPopup(this.comboBox);
    }

    protected ComboBoxEditor createEditor() {
        return new WilySearchableComboBoxEditor.KUIResource(this);
    }

    public void installUI(JComponent c) {
        super.installUI(c);
        Boolean inTable = (Boolean)c.getClientProperty(IS_TABLE_CELL_EDITOR);
        if (inTable != null) {
            this.isTableCellEditor = inTable.equals(Boolean.TRUE);
        }
    }

    protected ListDataListener createListDataListener() {
        return new BasicComboBoxUI.ListDataHandler(){

            public void contentsChanged(ListDataEvent e) {
                if (e.getIndex0() != -1 || e.getIndex1() != -1) {
                    WilySearchableComboBoxUI.this.isMinimumSizeDirty = true;
                    WilySearchableComboBoxUI.this.comboBox.revalidate();
                }
                if (WilySearchableComboBoxUI.this.editor != null) {
                    if (!(WilySearchableComboBoxUI.this.comboBox.getModel() instanceof SearchableComboBox.SearchableComboBoxModel)) {
                        WilySearchableComboBoxUI.this.comboBox.configureEditor(WilySearchableComboBoxUI.this.comboBox.getEditor(), WilySearchableComboBoxUI.this.comboBox.getSelectedItem());
                    } else if (WilySearchableComboBoxUI.this.comboBox.getSelectedItem() != null) {
                        WilySearchableComboBoxUI.this.comboBox.configureEditor(WilySearchableComboBoxUI.this.comboBox.getEditor(), WilySearchableComboBoxUI.this.comboBox.getSelectedItem());
                    }
                }
                WilySearchableComboBoxUI.this.comboBox.repaint();
            }
        };
    }

    public class WilyComboPopup
    extends BasicComboPopup {
        private static final long serialVersionUID = -2764747478684787627L;

        public WilyComboPopup(JComboBox cBox) {
            super(cBox);
        }

        public void delegateFocus(MouseEvent e) {
            if (this.comboBox.isEditable()) {
                WilySearchableComboBoxUI.this.editor.requestFocus();
            }
        }

        protected int getPopupHeightForRowCount(int maxRowCount) {
            if (this.comboBox.getModel() instanceof SearchableComboBox.SearchableComboBoxModel) {
                int minRowCount = maxRowCount;
                int height = 0;
                ListCellRenderer<Object> renderer = this.list.getCellRenderer();
                Object value = null;
                for (int i = 0; i < minRowCount; ++i) {
                    value = this.list.getModel().getElementAt(i);
                    Component c = renderer.getListCellRendererComponent(this.list, value, i, false, false);
                    height += c.getPreferredSize().height;
                }
                return height == 0 ? 100 : height;
            }
            return super.getPopupHeightForRowCount(maxRowCount);
        }

        protected MouseListener createMouseListener() {
            return new WilyInvocationMouseHandler();
        }

        protected MouseListener createListMouseListener() {
            return new BasicComboPopup.ListMouseHandler(){

                public void mouseReleased(MouseEvent anEvent) {
                    if (WilyComboPopup.this.comboBox instanceof SearchableComboBox) {
                        int selectedIndex = WilyComboPopup.this.list.getSelectedIndex();
                        WilyComboPopup.this.comboBox.setPopupVisible(false);
                        WilyComboPopup.this.comboBox.setSelectedIndex(selectedIndex);
                        if (WilyComboPopup.this.comboBox.isEditable() && WilyComboPopup.this.comboBox.getEditor() != null) {
                            WilyComboPopup.this.comboBox.configureEditor(WilyComboPopup.this.comboBox.getEditor(), WilyComboPopup.this.comboBox.getSelectedItem());
                        }
                    } else {
                        super.mouseReleased(anEvent);
                    }
                }
            };
        }

        protected class WilyInvocationMouseHandler
        extends BasicComboPopup.InvocationMouseHandler {
            protected WilyInvocationMouseHandler() {
                super(WilyComboPopup.this);
            }

            public void mousePressed(MouseEvent e) {
                if (!SwingUtilities.isLeftMouseButton(e)) {
                    return;
                }
                if (!WilyComboPopup.this.comboBox.isEnabled()) {
                    return;
                }
                WilyComboPopup.this.delegateFocus(e);
                if (WilyComboPopup.this.comboBox.getModel() instanceof SearchableComboBox.SearchableComboBoxModel) {
                    SearchableComboBox.SearchableComboBoxModel searchableComboBoxModel = (SearchableComboBox.SearchableComboBoxModel)WilyComboPopup.this.comboBox.getModel();
                    String oldSearchText = searchableComboBoxModel.getSearchText();
                    if (oldSearchText.length() == 0) {
                        WilyComboPopup.this.togglePopup();
                    } else {
                        Object oldSelectedItem = searchableComboBoxModel.getSelectedItem();
                        searchableComboBoxModel.setSearchText("");
                        if (oldSelectedItem != null) {
                            searchableComboBoxModel.setSelectedItem(oldSelectedItem);
                        }
                        SwingUtilities.invokeLater(new Runnable(){

                            public void run() {
                                WilyComboPopup.this.show();
                            }
                        });
                    }
                } else {
                    WilyComboPopup.this.togglePopup();
                }
            }

            public void mouseReleased(MouseEvent e) {
                Component source = (Component)e.getSource();
                Dimension size = source.getSize();
                Rectangle bounds = new Rectangle(0, 0, size.width - 1, size.height - 1);
                if (!bounds.contains(e.getPoint())) {
                    MouseEvent newEvent = WilyComboPopup.this.convertMouseEvent(e);
                    Point location = newEvent.getPoint();
                    Rectangle r = new Rectangle();
                    WilyComboPopup.this.list.computeVisibleRect(r);
                    WilyComboPopup.this.comboBox.setPopupVisible(false);
                    if (r.contains(location)) {
                        WilyComboPopup.this.comboBox.setSelectedIndex(WilyComboPopup.this.list.getSelectedIndex());
                    }
                }
                WilyComboPopup.this.hasEntered = false;
                WilyComboPopup.this.stopAutoScrolling();
            }
        }
    }

    public class WilyKeyHandler
    extends KeyAdapter {
        public void keyPressed(KeyEvent e) {
        }
    }
}

