/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.event;

import com.wily.util.event.AListenerEvent;
import com.wily.util.event.BasketableNotFoundException;
import com.wily.util.event.IBasket;
import com.wily.util.event.IBasketable;
import com.wily.util.event.ITrackableListener;
import com.wily.util.event.ListenerTracker;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;

public abstract class ARewindingBasket
implements IBasket {
    private final IModuleFeedbackChannel fFeedback;
    private final Object fBasketLock;
    private final HashMap fBasketables;
    private final ListenerTracker fListeners;
    private final List fAllBasketablesListenersList;

    protected ARewindingBasket(IModuleFeedbackChannel feedback, Class basketListenerClass, Object basketLock) {
        this.fFeedback = feedback;
        this.fBasketLock = basketLock;
        this.fBasketables = new HashMap();
        this.fListeners = new ListenerTracker(this.IBasket_getModuleFeedback(), "basket", basketListenerClass);
        this.fAllBasketablesListenersList = new ArrayList();
    }

    private Object getBasketLock() {
        return this.fBasketLock;
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.fFeedback;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private IBasketable lookupBasketableFromKey(Object key) {
        if (key == null) {
            return null;
        }
        Object object = this.getBasketLock();
        synchronized (object) {
            return (IBasketable)this.fBasketables.get(key);
        }
    }

    private Object lookupValueFromKey(Object key) {
        IBasketable basketable = this.lookupBasketableFromKey(key);
        if (basketable != null) {
            return basketable.IBasketable_getBasketableValue();
        }
        return null;
    }

    private Object findValueFromKey(Object key) throws BasketableNotFoundException {
        Object value = this.IBasket_lookupValueFromKey(key);
        if (value == null) {
            throw new BasketableNotFoundException();
        }
        return value;
    }

    public IModuleFeedbackChannel IBasket_getModuleFeedback() {
        return this.getModuleFeedback();
    }

    public Object IBasket_lookupValueFromKey(Object key) {
        return this.lookupValueFromKey(key);
    }

    public Object IBasket_findValueFromKey(Object key) throws BasketableNotFoundException {
        return this.findValueFromKey(key);
    }

    public int getSize() {
        return this.fBasketables.size();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void addBasketable(IBasketable basketable) {
        Object object = this.getBasketLock();
        synchronized (object) {
            this.fBasketables.put(basketable.IBasketable_getBasketableKey(), basketable);
            this.targetedFireBasketableAvailable(ListenerTracker.kBroadcastToAllListeners, basketable);
            Iterator i = this.fAllBasketablesListenersList.iterator();
            while (i.hasNext()) {
                ITrackableListener listener = (ITrackableListener)i.next();
                if (!this.shouldFireBasketable(basketable, listener)) continue;
                basketable.IBasketable_addBroadcastListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void removeBasketable(IBasketable basketable) throws BasketableNotFoundException {
        Object object = this.getBasketLock();
        synchronized (object) {
            if (!this.fBasketables.containsKey(basketable.IBasketable_getBasketableKey())) {
                throw new BasketableNotFoundException("Unable to remove:" + basketable.toString());
            }
            this.fBasketables.remove(basketable.IBasketable_getBasketableKey());
            this.targetedFireBasketableDisappeared(ListenerTracker.kBroadcastToAllListeners, basketable);
            Iterator i = this.fAllBasketablesListenersList.iterator();
            while (i.hasNext()) {
                ITrackableListener listener = (ITrackableListener)i.next();
                if (!this.shouldFireBasketable(basketable, listener)) continue;
                basketable.IBasketable_removeBroadcastListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBroadcastListenerWithRewind(ITrackableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener cannot be null, if you see this, contact dhalem");
        Object object = this.getBasketLock();
        synchronized (object) {
            Iterator i = this.getBasketablesIterator();
            while (i.hasNext()) {
                this.targetedFireBasketableAvailable(listener, (IBasketable)i.next());
            }
            AListenerEvent rewindFinishedEvent = this.allocateBasketEvent(1002);
            this.postTargetedEvent(listener, rewindFinishedEvent);
            this.basketPostAddBroadcastListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBroadcastListener(ITrackableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener cannot be null, if you see this, contact dhalem");
        Object object = this.getBasketLock();
        synchronized (object) {
            this.basketPostRemoveBroadcastListener(listener);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addBroadcastAllBasketablesListenerWithRewind(ITrackableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener cannot be null, if you see this, contact dhalem");
        Object object = this.getBasketLock();
        synchronized (object) {
            boolean addResult = this.fAllBasketablesListenersList.add(listener);
            Assertion.wilyAssert(addResult);
            Iterator i = this.getBasketablesIterator();
            while (i.hasNext()) {
                IBasketable basketable = (IBasketable)i.next();
                if (!this.shouldFireBasketable(basketable, listener)) continue;
                basketable.IBasketable_addBroadcastListenerWithRewind(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void removeBroadcastAllBasketablesListener(ITrackableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener cannot be null, if you see this, contact dhalem");
        Object object = this.getBasketLock();
        synchronized (object) {
            boolean removeResult = this.fAllBasketablesListenersList.remove(listener);
            Assertion.wilyAssert(removeResult);
            Iterator i = this.getBasketablesIterator();
            while (i.hasNext()) {
                IBasketable basketable = (IBasketable)i.next();
                if (!this.shouldFireBasketable(basketable, listener)) continue;
                basketable.IBasketable_removeBroadcastListener(listener);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lobotomize() {
        Object object = this.getBasketLock();
        synchronized (object) {
            this.fBasketables.clear();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object[] IBasket_getAllValuesArray(Object[] candidateArray) {
        Object object = this.getBasketLock();
        synchronized (object) {
            Collection basketables = this.getBasketablesCollection();
            Object[] result = (Object[])Array.newInstance(candidateArray.getClass().getComponentType(), basketables.size());
            Iterator allEggs = basketables.iterator();
            int index = 0;
            while (allEggs.hasNext()) {
                IBasketable currentEgg = (IBasketable)allEggs.next();
                result[index++] = currentEgg.IBasketable_getBasketableValue();
            }
            return result;
        }
    }

    protected boolean shouldFireBasketable(IBasketable basketable, ITrackableListener listener) {
        return true;
    }

    private AListenerEvent allocateBasketEvent(int eventID) {
        return this.IBasket_allocateBasketEvent(eventID);
    }

    private AListenerEvent allocateBasketableEvent(int eventID, IBasketable basketable) {
        return basketable.IBasketable_allocateEvent(eventID);
    }

    private void targetedFireBasketableAvailable(ITrackableListener listener, IBasketable basketable) {
        boolean shouldFire = this.shouldFireBasketable(basketable, listener);
        if (!shouldFire) {
            return;
        }
        Assertion.wilyAssert(listener != null, "Listener cannot be null, if you see this, contact dhalem");
        AListenerEvent availableEvent = this.allocateBasketableEvent(1003, basketable);
        this.postTargetedEvent(listener, availableEvent);
    }

    private void targetedFireBasketableDisappeared(ITrackableListener listener, IBasketable basketable) {
        if (!this.shouldFireBasketable(basketable, listener)) {
            return;
        }
        Assertion.wilyAssert(listener != null, "Listener cannot be null, if you see this, contact dhalem");
        AListenerEvent disappearedEvent = this.allocateBasketableEvent(1004, basketable);
        this.postTargetedEvent(listener, disappearedEvent);
    }

    private Collection getBasketablesCollection() {
        return this.fBasketables.values();
    }

    private Iterator getBasketablesIterator() {
        return this.getBasketablesCollection().iterator();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void postTargetedEvent(ITrackableListener listener, AListenerEvent event) {
        Assertion.wilyAssert(listener != null, "Listener cannot be null, if you see this, contact dhalem");
        Object object = this.getBasketLock();
        synchronized (object) {
            this.doPostTargetedEvent(listener, event);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final void corePostTargetedEvent(ITrackableListener listener, AListenerEvent event) {
        Assertion.wilyAssert(listener != null, "Listener cannot be null, if you see this, contact dhalem");
        Object object = this.getBasketLock();
        synchronized (object) {
            this.IBasket_getEventPump().postTargetedEvent(this.fListeners, listener, event);
        }
    }

    protected void doPostTargetedEvent(ITrackableListener listener, AListenerEvent event) {
        Assertion.wilyAssert(listener != null, "Listener cannot be null, if you see this, contact dhalem");
        this.corePostTargetedEvent(listener, event);
    }

    private void basketPostAddBroadcastListener(ITrackableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener cannot be null, if you see this, contact dhalem");
        this.IBasket_getEventPump().postAddBroadcastListener(this.fListeners, listener);
    }

    private void basketPostRemoveBroadcastListener(ITrackableListener listener) {
        Assertion.wilyAssert(listener != null, "Listener cannot be null, if you see this, contact dhalem");
        this.IBasket_getEventPump().postRemoveBroadcastListener(this.fListeners, listener);
    }
}

