/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.async;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.async.AsyncTransactionContext;
import com.wily.introscope.agent.async.AsyncVirtualStack;
import com.wily.introscope.agent.async.IAsyncMetricProvider;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.cas.ICounterRepository;
import com.wily.introscope.agent.trace.cas.IRepository;
import com.wily.introscope.agent.trace.hc2.AverageMetricGathererWrapper;
import com.wily.introscope.agent.trace.hc2.BlamePointTracer;
import com.wily.introscope.agent.transactiontrace.CorrelationId;
import com.wily.introscope.spec.metric.AgentMetric;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;

public class AsyncBackendStartTracer
extends BlamePointTracer
implements IAsyncMetricProvider {
    public static final String kBackendsAsyncCategoryPrefix = "AsyncBackendStart|";
    static final String ASYN_BACKEND_CORRELATION_INSERTED = "asyn.ackend.correlation.inserted";
    public static final int kConcurrentMetricIndex = 0;
    public static final int kTimerMetricIndex = 1;
    public static final int kPerIntervalMetricIndex = 2;
    public static final int kStallMetricIndex = 3;
    public static final int kErrorMetricIndex = 4;
    protected final IModuleFeedbackChannel feedback;
    protected static Module module = new Module("AsyncBackendStartTracer");
    protected final AsyncVirtualStack asyncStack;

    public AsyncBackendStartTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        this.feedback = agent.IAgent_getModuleFeedback();
        this.asyncStack = AsyncVirtualStack.getInstance(agent);
    }

    @Override
    protected String getComponentName(InvocationData data) {
        String name = this.formatParameterizedName(data);
        name = kBackendsAsyncCategoryPrefix + name;
        return name;
    }

    protected void insertCorrelationIdToRequest(InvocationData data, CorrelationId corId) {
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        AsyncTransactionContext.AsyncComponentInvocation info = this.asyncStack.getAsyncBackendInfoFromTransactionCache(data);
        if (info == null) {
            String name = super.formatParameterizedName(data);
            String component = "Backends|" + name;
            info = this.asyncStack.pushBackend(component, data, this);
            this.asyncStack.putAsyncBackendInfoToTransactionCache(data, info);
            data.put(ASYN_BACKEND_CORRELATION_INSERTED, true);
            CorrelationId corId = this.asyncStack.createCorrelationIdForComponent(info);
            this.insertCorrelationIdToRequest(data, corId);
        }
        super.ITracer_startTrace(tracerIndex, data);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        AsyncTransactionContext.AsyncComponentInvocation info = this.asyncStack.getAsyncBackendInfoFromTransactionCache(data);
        if (info != null && data.get(ASYN_BACKEND_CORRELATION_INSERTED) != null) {
            this.asyncStack.clearAsyncBackendInfoToTransactionCache(data);
        }
        super.ITracer_finishTrace(tracerIndex, data);
    }

    @Override
    public AsyncVirtualStack.AsyncMetricHolder[] constructAsyncComponentMetrics(String componentName) {
        IRepository concurrentSds = null;
        IRepository timerSds = null;
        IRepository stallSds = null;
        IRepository errorsSds = null;
        IRepository perIntervalSds = null;
        AsyncVirtualStack.AsyncMetricHolder[] metrics = new AsyncVirtualStack.AsyncMetricHolder[5];
        AgentMetric[] concurrentMetric = this.createConcurrentInvocationMetric(this.getConcurrentInvocationMetricName(componentName));
        concurrentSds = this.getSharedRepositoryNoSharedStructure(false);
        metrics[0] = new AsyncVirtualStack.AsyncMetricHolder(concurrentSds, concurrentMetric);
        AgentMetric[] timerMetric = this.createTimerMetric(this.getTimerMetricName(componentName));
        timerSds = this.getSharedRepository(AverageMetricGathererWrapper.getFactory(true), this.fNumberOfStripes);
        metrics[1] = new AsyncVirtualStack.AsyncMetricHolder(timerSds, timerMetric);
        AgentMetric[] perIntervalMetric = this.createPerIntervalMetric(this.getPerIntervalMetricName(componentName));
        perIntervalSds = this.getSharedRepository(true, this.fNumberOfStripes);
        metrics[2] = new AsyncVirtualStack.AsyncMetricHolder(perIntervalSds, perIntervalMetric);
        AgentMetric[] stallMetric = this.createStallsMetric(this.getStallsMetricName(componentName));
        stallSds = this.getSharedRepositoryNoSharedStructure(false);
        metrics[3] = new AsyncVirtualStack.AsyncMetricHolder(stallSds, stallMetric);
        AgentMetric[] errorMetric = this.createErrorsMetric(this.getErrorsMetricName(componentName));
        errorsSds = this.getSharedRepositoryNoSharedStructure(false);
        metrics[4] = new AsyncVirtualStack.AsyncMetricHolder(errorsSds, errorMetric);
        return metrics;
    }

    @Override
    public void updateAsyncComponentMetricsAtStart(AsyncVirtualStack.AsyncMetricHolder[] metrics, long startTime) {
        ICounterRepository cin = (ICounterRepository)metrics[0].sds;
        if (cin != null) {
            cin.increase(startTime);
        }
    }

    @Override
    public void updateAsyncComponentMetricsAtStall(AsyncVirtualStack.AsyncMetricHolder[] metrics, long time) {
        IRepository sds;
        AsyncVirtualStack.AsyncMetricHolder holder = metrics[3];
        if (holder != null && (sds = holder.sds) instanceof ICounterRepository) {
            ICounterRepository cr = (ICounterRepository)sds;
            cr.increase(time);
        }
    }

    @Override
    public void updateAsyncComponentMetricsAtError(AsyncVirtualStack.AsyncMetricHolder[] metrics, long time) {
        IRepository sds;
        AsyncVirtualStack.AsyncMetricHolder holder = metrics[4];
        if (holder != null && (sds = holder.sds) instanceof ICounterRepository) {
            ICounterRepository cr = (ICounterRepository)sds;
            cr.increase(time);
        }
    }

    @Override
    public void updateAsyncComponentMetricsAtAbort(AsyncVirtualStack.AsyncMetricHolder[] metrics, long time, boolean didStall) {
        ICounterRepository cin = (ICounterRepository)metrics[0].sds;
        if (cin != null) {
            cin.decrease(time);
        }
        if (didStall && (cin = (ICounterRepository)metrics[3].sds) != null) {
            cin.decrease(time);
        }
    }
}

