/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.DuplicateDynamicClassException;
import com.wily.introscope.agent.extension.DynamicClassLookup;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.extension.InvalidDynamicClassException;
import com.wily.introscope.agent.trace.ITracerFactory;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.transformer.dynamic.AInstrumentationHelper;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IValidationFeedbackChannel;
import com.wily.util.properties.AttributeListing;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.reflect.Constructor;

final class TracerFactoryLoader
extends DynamicClassLookup {
    private static final String kTracerPluginType = "tracer";
    private static final int kCurrentTracerPluginVersion = 1;
    private static final Class[] kTracerFactoryConstructorParameterTypes = new Class[]{IAgent.class, AttributeListing.class, ProbeIdentification.class, Object.class};
    private IValidationFeedbackChannel fValidationFeedbackChannel;

    public TracerFactoryLoader(IAgent agent) {
        super(agent, ITracerFactory.class, kTracerFactoryConstructorParameterTypes);
        if (AInstrumentationHelper.isValidate()) {
            this.fValidationFeedbackChannel = AInstrumentationHelper.getValidationFeedbackChannel();
        }
        this.loadTracerPlugins();
    }

    public final ITracerFactory createTracerFactory(String factoryClassName, String parameters, ProbeIdentification identification, Object tracedObject) throws Exception {
        AttributeListing factoryParameters = new AttributeListing();
        factoryParameters.load(parameters);
        DynamicClassLookup.DynamicClassEntry entry = null;
        try {
            entry = this.loadDynamicClassEntry(factoryClassName);
        }
        catch (ClassNotFoundException e) {
            this.getModuleFeedback().error("Unable to create tracer factories for the following class (library not found): " + factoryClassName);
            this.getModuleFeedback().info("Either the tracer configuration is incorrect or the installation is corrupt");
            throw e;
        }
        Class factoryClass = entry.getDynamicClass();
        IAgent factoryAgent = entry.getDynamicAgent();
        if (!this.getExpectedType().isAssignableFrom(factoryClass)) {
            throw new InvalidDynamicClassException("Class is not assignable to the expected type", (ILocalizableMessage)new FormattedLocalizableMessage("Agent_Extension_Dynamic_Class_Wrong_Type_Error", factoryClassName));
        }
        Constructor constructor = factoryClass.getConstructor(kTracerFactoryConstructorParameterTypes);
        ITracerFactory factory = (ITracerFactory)constructor.newInstance(factoryAgent, factoryParameters, identification, tracedObject);
        Assertion.wilyAssert(false);
        return factory;
    }

    private void loadTracerPlugins() {
        ExtensionAdministrator extensionAdministrator = this.getAgent().IAgent_getExtensionAdministrator();
        Assertion.wilyAssert(false);
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kTracerPluginType);
        int i = 0;
        while (i < plugins.length) {
            this.loadTracerPlugin(plugins[i]);
            ++i;
        }
        extensionAdministrator.setGlobalPluginCallbackByType(kTracerPluginType, new IPlugin.IPluginCallback(){

            @Override
            public void onUnload(IPlugin p) {
            }

            @Override
            public void onLoad(IPlugin p) {
                TracerFactoryLoader.this.loadTracerPlugin(p);
            }
        });
    }

    private void loadTracerPlugin(IPlugin plugin) {
        Class tracerFactoryClass = ExtensionUtilities.loadEntryPointClass(this.getModuleFeedback(), this.getStringLocalizer(), plugin, 1, ITracerFactory.class, this.fValidationFeedbackChannel);
        if (tracerFactoryClass != null) {
            IStringLocalizer tracerFactoryLocalizer = plugin.IPlugin_getOwningExtension().IExtension_getStringLocalizer(this.getStringLocalizer());
            try {
                this.register(plugin, tracerFactoryClass.getName(), tracerFactoryClass, tracerFactoryLocalizer);
                this.getModuleFeedback().verbose(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Plugin_Registered_Message", plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName()));
            }
            catch (DuplicateDynamicClassException ddce) {
                String errorMessage = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Plugin_Duplicate_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName());
                this.logErrorValidationFeedback(errorMessage, ddce);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(ddce);
            }
            catch (InvalidDynamicClassException idce) {
                String errorMessage = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Plugin_Invalid_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName());
                this.logErrorValidationFeedback(errorMessage, idce);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(idce);
            }
            catch (ThreadDeath td) {
                throw td;
            }
            catch (Throwable t) {
                String errorMessage = this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Tracer_Plugin_Invalid_Message", plugin.IPlugin_getOwningExtension().IExtension_getSource(), plugin.IPlugin_getOwningExtension().IExtension_getName(), plugin.IPlugin_getName());
                this.logErrorValidationFeedback(errorMessage, t);
                this.getModuleFeedback().error(errorMessage);
                this.getModuleFeedback().verbose(t);
            }
        }
    }

    private void logErrorValidationFeedback(String message, Throwable cause) {
        if (this.fValidationFeedbackChannel != null) {
            this.fValidationFeedbackChannel.error(message, cause);
        }
    }
}

