/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.trace.hc2;

import com.wily.introscope.agent.AgentNotAvailableException;
import com.wily.introscope.agent.AgentShim;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.MetricPathUtils;
import com.wily.introscope.agent.blame.ApplicationNameInfo;
import com.wily.introscope.agent.blame.ComponentTracer;
import com.wily.introscope.agent.blame.VirtualStack;
import com.wily.introscope.agent.trace.IEnhancedInvocationDataParameterCallback;
import com.wily.introscope.agent.trace.InvocationData;
import com.wily.introscope.agent.trace.ProbeIdentification;
import com.wily.introscope.agent.trace.ReentrancyLevel;
import com.wily.introscope.agent.trace.hc2.ABlameComponent;
import com.wily.introscope.agent.trace.hc2.FrontendTracer;
import com.wily.introscope.agent.trace.hc2.HttpServletLazyMap;
import com.wily.introscope.agent.trace.hc2.HttpServletLazyMapProvider;
import com.wily.introscope.agent.trace.hc2.UrlGroupingProvider;
import com.wily.introscope.agent.trace.hc2.WilyTransactionStructure;
import com.wily.introscope.agent.trace.servlet.IServletRequestHelper;
import com.wily.introscope.agent.trace.servlet.LoaderContext;
import com.wily.introscope.agent.trace.servlet.ServletHelperFactory;
import com.wily.introscope.agent.urlgroup.URLMatchResult;
import com.wily.introscope.spec.agent.bizdef.IBizTrx;
import com.wily.util.adt.LazyMap;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import com.wily.util.properties.AttributeListing;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.ConfigurationProperty;
import com.wily.util.properties.hot.ConfigurationPropertySet;
import com.wily.util.properties.hot.StringListConfigurationProperty;
import com.wily.util.properties.hot.StringSetConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.lang.reflect.Array;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public class HttpServletTracer
extends FrontendTracer
implements IEnhancedInvocationDataParameterCallback {
    private static final Object kNoBizTrx = new Object();
    private static final Module kModule = new Module("HttpServletTracerHC");
    protected static final String kHttpServletTracerLoaderContext = "HttpServletTracerHC";
    protected boolean fDoAppNaming;
    protected String fCharEncoding;
    private static IAgent fAgent;
    private boolean traceDeepCalls;
    private int traceDeepCount;
    static volatile List sSyntheticHeaderParameterNames;
    static volatile String sSyntheticUserParameterName;
    static volatile String sSyntheticNodeName;
    static volatile String sNonSyntheticNodeName;
    static final String kServletContextInterfaceName = "javax.servlet.ServletContext";
    static final String kServletInterfaceName = "javax.servlet.Servlet";
    private static final String kLogConfigPropertyName = "log4j.logger.IntroscopeAgent";
    static volatile boolean fIsDebugEnabled;
    public static final String kCharEncodingPropKey = "introscope.agent.charEncoding";
    protected static final String kTraceParamKey = "introscope.agent.HttpServletTracer.transactionTraceParameters";
    private static final String kTraceDeepCalls = "introscope.agent.HttpServletTracer.traceDeepCalls";
    private static final String kTraceDeepCount = "introscope.agent.HttpServletTracer.traceDeepCount";
    private static final int kDefaultTraceDeepCount = 5;
    private static String kAgentSyntheticTransactionTracerSyntheticNodeNameDefaultValue;
    private static String kAgentSyntheticTransactionTracerNonSyntheticNodeNameDefaultValue;
    private static int sCompNameErrorCount;
    private static final int sCompNameConsecutiveErrorThreshold = 100;
    protected static boolean sHaveGivenUpGettingCompName;

    static {
        fIsDebugEnabled = false;
        kAgentSyntheticTransactionTracerSyntheticNodeNameDefaultValue = "Synthetic Users";
        kAgentSyntheticTransactionTracerNonSyntheticNodeNameDefaultValue = "Real Users";
        sCompNameErrorCount = 0;
        sHaveGivenUpGettingCompName = false;
    }

    public static void initializeParameterLoader(IAgent agent) {
        final IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        ConfigurationManager cm = agent.IAgent_getConfigurationManager();
        ConfigurationProperty charEncoding = new ConfigurationProperty(kCharEncodingPropKey, null, null, null, false, true, feedback, kModule, localizer);
        cm.add(charEncoding);
        LoaderContext.setCharEncoding(feedback, kHttpServletTracerLoaderContext, (String)charEncoding.getValue());
        ConfigurationPropertySet directLoadHeaderParamsSet = new ConfigurationPropertySet(){

            @Override
            public final void set() {
                ArrayList<String> headerParamNames = new ArrayList<String>();
                Iterator i = this.iterator();
                while (i.hasNext()) {
                    ConfigurationProperty cp = (ConfigurationProperty)i.next();
                    Object value = cp.getValue();
                    if (value == null) continue;
                    if (value instanceof Collection) {
                        headerParamNames.addAll((Collection)value);
                        continue;
                    }
                    headerParamNames.add(value.toString());
                }
                LoaderContext.setDirectLoadHeaderParams(feedback, HttpServletTracer.kHttpServletTracerLoaderContext, headerParamNames.toArray(new String[0]));
            }
        };
        directLoadHeaderParamsSet.add(new StringSetConfigurationProperty("introscope.agent.transactiontracer.parameter.httprequest.headers", new HashSet(), "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer));
        cm.add(new StringSetConfigurationProperty("introscope.agent.transactiontracer.parameter.httprequest.parameters", new HashSet(), "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer){

            @Override
            public final void set(Object value) {
                LoaderContext.setDirectLoadRequestParams(this.getFeedback(), HttpServletTracer.kHttpServletTracerLoaderContext, ((Set)value).toArray(new String[0]));
            }
        });
        cm.add(new StringSetConfigurationProperty("introscope.agent.transactiontracer.parameter.httprequest.attributes", new HashSet(), "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer){

            @Override
            public final void set(Object value) {
                LoaderContext.setDirectLoadRequestAttributes(this.getFeedback(), HttpServletTracer.kHttpServletTracerLoaderContext, ((Set)value).toArray(new String[0]));
            }
        });
        cm.add(new StringSetConfigurationProperty("introscope.agent.transactiontracer.parameter.httpsession.attributes", new HashSet(), "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer){

            @Override
            public final void set(Object value) {
                LoaderContext.setDirectLoadSessionAttributes(this.getFeedback(), HttpServletTracer.kHttpServletTracerLoaderContext, ((Set)value).toArray(new String[0]));
            }
        });
        ConfigurationPropertySet userIdMethodKeySet = new ConfigurationPropertySet(){

            @Override
            public final void set() {
                LoaderContext.setDirectLoadUserId(feedback, HttpServletTracer.kHttpServletTracerLoaderContext, (String)this.getConfigurationProperty("introscope.agent.transactiontracer.userid.method").getValue(), (String)this.getConfigurationProperty("introscope.agent.transactiontracer.userid.key").getValue());
            }
        };
        userIdMethodKeySet.add(new ConfigurationProperty("introscope.agent.transactiontracer.userid.method", null, "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer));
        userIdMethodKeySet.add(new ConfigurationProperty("introscope.agent.transactiontracer.userid.key", null, "Hot_Property_Configuration_Property", null, true, true, feedback, kModule, localizer));
        cm.add(userIdMethodKeySet, true);
        directLoadHeaderParamsSet.add(new StringListConfigurationProperty("introscope.agent.synthetic.header.names", null, null, null, true, true, feedback, kModule, localizer){

            @Override
            public final void set(Object value) {
                ArrayList<String> paramNames = null;
                if (value != null) {
                    paramNames = new ArrayList<String>();
                    Iterator i = ((List)value).iterator();
                    while (i.hasNext()) {
                        paramNames.add("httprequest.header." + i.next());
                    }
                }
                sSyntheticHeaderParameterNames = paramNames;
            }
        });
        directLoadHeaderParamsSet.add(new ConfigurationProperty("introscope.agent.synthetic.user.name", null, null, null, true, true, feedback, kModule, localizer){

            @Override
            public final void set(Object value) {
                sSyntheticUserParameterName = "httprequest.header." + (String)value;
            }
        });
        cm.add(new ConfigurationProperty("introscope.agent.synthetic.node.name", kAgentSyntheticTransactionTracerSyntheticNodeNameDefaultValue, null, null, true, true, feedback, kModule, localizer){

            @Override
            public final boolean validate(Object value) {
                return MetricPathUtils.isValidMetricPath((String)value);
            }

            @Override
            public final void set(Object value) {
                sSyntheticNodeName = (String)value;
            }
        });
        cm.add(new ConfigurationProperty("introscope.agent.non.synthetic.node.name", kAgentSyntheticTransactionTracerNonSyntheticNodeNameDefaultValue, null, null, true, true, feedback, kModule, localizer){

            @Override
            public final boolean validate(Object value) {
                return MetricPathUtils.isValidMetricPath((String)value);
            }

            @Override
            public final void set(Object value) {
                sNonSyntheticNodeName = (String)value;
            }
        });
        cm.add(new TraceLogConfigurationProperty(kLogConfigPropertyName, null, null, agent.IAgent_getModule(), agent.IAgent_getStringLocalizer(), agent));
        cm.add(directLoadHeaderParamsSet, true);
    }

    public HttpServletTracer(IAgent agent, AttributeListing parameters, ProbeIdentification probe, Object sampleTracedObject) {
        super(agent, parameters, probe, sampleTracedObject);
        fAgent = agent;
        this.fDoAppNaming = true;
        try {
            String blameType = agent.IAgent_getIndexedProperties().getProperty("introscope.agent.blame.type");
            if (blameType != null) {
                this.fDoAppNaming = blameType.equals("boundary");
            }
            this.fCharEncoding = agent.IAgent_getIndexedProperties().getProperty(kCharEncodingPropKey);
        }
        catch (Exception e) {
            this.getModuleFeedback().debug(e);
            this.fDoAppNaming = false;
        }
        this.traceDeepCalls = this.getIndexedProperties().getBooleanProperty(kTraceDeepCalls, true);
        this.traceDeepCount = this.getIndexedProperties().getIntProperty(kTraceDeepCount, 5);
        if (this.traceDeepCount <= 0) {
            this.traceDeepCount = 5;
        }
    }

    @Override
    public ReentrancyLevel ITracerFactory_getReentrancyLevel() {
        return ReentrancyLevel.kNone;
    }

    @Override
    public void ITracer_startTrace(int tracerIndex, InvocationData data) {
        VirtualStack.TransactionCache tc = VirtualStack.getTransactionCache();
        if (!tc.isDownstreamServletTracing()) {
            return;
        }
        Object invocationObject = data.getInvocationObject();
        if (invocationObject == null || this.getClassesToSkip().contains(invocationObject.getClass().getName())) {
            this.setSkippedClass();
            return;
        }
        if (!this.traceDeepCalls) {
            tc.incrementStackDepth();
            if (tc.getStackDepthValue() > this.traceDeepCount) {
                return;
            }
        }
        this.setServletSupport(this.fCharEncoding, this.getAgent(), data);
        tc.setServletTracingInProgress();
        ComponentTracer ct = this.getComponentTracer();
        if (ct != null) {
            ct.setInURLTracingContext();
        }
        data.setParameterCallback(this);
        if (this.fDoAppNaming) {
            super.ITracer_startTrace(tracerIndex, data);
        }
    }

    protected IServletRequestHelper getHttpServletRequestHelper(InvocationData invocationData, IAgent agent, Object request) {
        return ServletHelperFactory.getServletHelper(request, request.getClass().getClassLoader(), agent.IAgent_getModuleFeedback());
    }

    protected Object getHttpRequestObject(InvocationData invocationData) {
        return invocationData.getInvocationParameterCount() > 0 ? invocationData.getInvocationParameterAsObject(0) : null;
    }

    protected Object getServletObject(InvocationData invocationData) {
        return invocationData.getInvocationObject();
    }

    public void setServletSupport(String charEncoding, IAgent agent, InvocationData data) {
        Object request;
        if (!data.hasServletSupport() && (request = this.getHttpRequestObject(data)) != null) {
            Object servlet = this.getServletObject(data);
            IServletRequestHelper helper = this.getHttpServletRequestHelper(data, agent, request);
            LoaderContext context = LoaderContext.getContext(kHttpServletTracerLoaderContext);
            HashMap cacheParameterMap = new HashMap();
            HashMap supportMap = new HashMap();
            HttpServletLazyMapProvider provider = new HttpServletLazyMapProvider(servlet, data, agent, cacheParameterMap, helper, charEncoding, context, request);
            HttpServletLazyMap map = new HttpServletLazyMap(agent, helper, request, servlet, provider, supportMap, context.getAccessoryKeys());
            data.setServletSupport(request, servlet, helper, context, cacheParameterMap, provider, map);
            URLMatchResult matchResult = UrlGroupingProvider.doURLMatch(agent, cacheParameterMap, helper, request, data, charEncoding);
            if (matchResult != null && matchResult.getCharEncoding() != null) {
                String urlCharEncoding = matchResult.getCharEncoding();
                if (agent.IAgent_getModuleFeedback().isTraceEnabled()) {
                    agent.IAgent_getModuleFeedback().trace(kModule, "setCharEncoding: URL=" + UrlGroupingProvider.getURL(agent, helper, request) + ", charEncoding=" + urlCharEncoding);
                }
                provider.setCharEncoding(urlCharEncoding);
            }
        }
    }

    @Override
    protected long getFilterEnablerBit() {
        return 4L;
    }

    @Override
    protected Object getBlameKey(InvocationData data) {
        if (this.fDoAppNaming && !sHaveGivenUpGettingCompName && data.getInvocationParameterCount() > 0) {
            if (!data.hasServletSupport()) {
                this.setServletSupport(this.fCharEncoding, this.getAgent(), data);
            }
            InvocationData.ServletSupportClass support = data.getServletSupport();
            HttpServletLazyMap map = (HttpServletLazyMap)support.servletParametersMap;
            IBizTrx bixTrxKey = (IBizTrx)data.get("BusinessTrxData");
            if (bixTrxKey != null) {
                VirtualStack.getTransactionCache().setBizTrx(bixTrxKey);
            }
            Object requestURI = map.get("Normalized URL");
            Object serverPortAsInteger = map.getServerPortAsInteger();
            Object servletContext = map.getServletContext();
            Object synthTrxKey = map.getSyntheticTransactionName();
            int bpckLen = 2;
            int requestURIIndex = -1;
            int bizTrxKeyIndex = -1;
            int synthTrxKeyIndex = -1;
            long bizTrxKeyId = -1L;
            if (requestURI != null) {
                requestURIIndex = bpckLen++;
            }
            if (bixTrxKey != null) {
                bizTrxKeyIndex = bpckLen++;
            }
            if (synthTrxKey != null) {
                synthTrxKeyIndex = bpckLen++;
            }
            Object[] blameComponentKey = (Object[])Array.newInstance(Object.class, bpckLen);
            String appName = ApplicationNameInfo.resolveApplicationName((String)servletContext);
            blameComponentKey[0] = appName;
            if (appName != servletContext) {
                support.servletParametersMap.put("Application Name", appName);
            }
            blameComponentKey[1] = serverPortAsInteger;
            if (requestURIIndex > 0) {
                blameComponentKey[requestURIIndex] = requestURI;
            }
            if (bizTrxKeyIndex > 0) {
                blameComponentKey[bizTrxKeyIndex] = bixTrxKey;
                bizTrxKeyId = bixTrxKey.getId();
            }
            if (synthTrxKeyIndex > 0) {
                blameComponentKey[synthTrxKeyIndex] = synthTrxKey;
            }
            data.setServletSupportInTransactionCache(support);
            ABlameComponent key = ABlameComponent.getArrayInstance(blameComponentKey, bizTrxKeyId);
            return key;
        }
        return this.getComponentName(data);
    }

    @Override
    public void ITracer_finishTrace(int tracerIndex, InvocationData data) {
        VirtualStack.TransactionCache tc = VirtualStack.getTransactionCache();
        if (!tc.isDownstreamServletTracing() || this.isSkippedClass()) {
            return;
        }
        if (!this.traceDeepCalls) {
            tc.decrementStackDepth();
            if (tc.getStackDepthValue() >= this.traceDeepCount) {
                return;
            }
        }
        try {
            if (this.fDoAppNaming) {
                super.ITracer_finishTrace(tracerIndex, data);
            }
        }
        finally {
            ComponentTracer ct = this.getComponentTracer();
            if (ct != null) {
                ct.clearInURLTracingContext();
            }
            tc.clearServletTracingInProgress();
        }
    }

    protected boolean isServletTracingInProgress() {
        return VirtualStack.getTransactionCache().isServletTracingInProgress();
    }

    @Override
    protected String getComponentName(InvocationData data) {
        String result;
        block13: {
            result = null;
            if (this.fDoAppNaming && !sHaveGivenUpGettingCompName) {
                if (!data.hasServletSupport()) {
                    this.setServletSupport(this.fCharEncoding, this.getAgent(), data);
                }
                InvocationData.ServletSupportClass support = data.getServletSupport();
                Object request = support.request;
                if (request != null) {
                    try {
                        HttpServletLazyMap map = (HttpServletLazyMap)support.servletParametersMap;
                        String url = (String)map.get("Normalized URL");
                        String appName = (String)map.get("Application Name");
                        Object synthTrxName = map.getSyntheticTransactionName();
                        StringBuilder sb = new StringBuilder();
                        String prefix = String.valueOf(this.getFormattedName()) + "|";
                        if (!prefix.contains("Frontends")) {
                            prefix = "Frontends|Apps|";
                        }
                        sb.append(prefix);
                        sb.append(appName);
                        if (synthTrxName != null) {
                            sb.append("|");
                            sb.append(synthTrxName);
                        }
                        sb.append("|URLs|");
                        sb.append(url);
                        result = sb.toString();
                        sCompNameErrorCount = 0;
                    }
                    catch (ThreadDeath td) {
                        throw td;
                    }
                    catch (Throwable t) {
                        try {
                            this.getModuleFeedback().error("An error occurred while formatting servlet metrics: " + t);
                            this.getModuleFeedback().verbose(t);
                        }
                        catch (ThreadDeath td2) {
                            throw td2;
                        }
                        catch (Throwable throwable) {}
                        if (++sCompNameErrorCount < 100) break block13;
                        sHaveGivenUpGettingCompName = true;
                    }
                }
            }
        }
        if (result == null) {
            result = this.formatParameterizedName(data);
        }
        return result.intern();
    }

    private void addBizDefParameters(InvocationData data, Map parameters) {
        String appname;
        String tenant;
        String sdk;
        String connection;
        String os;
        String device;
        String location;
        String carrier;
        IBizTrx bizTrx;
        IModuleFeedbackChannel moduleFeedback = this.getModuleFeedback();
        if (WilyTransactionStructure.fCEMForceTraceConfigurationProperty.value) {
            parameters.put("CEM Force Trace", "true");
            moduleFeedback.debug("Setting KTransactionTraceConstants.kCEMForceTrace  to true");
        }
        if ((bizTrx = (IBizTrx)data.get("BusinessTrxDataUsedForSendingTrace")) != null) {
            parameters.put("Business Definition", bizTrx.getBizFullName());
            parameters.put("EUM Business Transaction", bizTrx.getBizTrxName());
            if (!bizTrx.isIdentifying()) {
                moduleFeedback.debug("Setting forceTrace for non identifying business txn #" + bizTrx.getBizFullName());
                parameters.put("CEM Force Trace", "true");
            }
        }
        if ((carrier = (String)data.get("x-apm-bt.Carrier")) != null) {
            parameters.put("x-apm-bt.Carrier", carrier);
        }
        if ((location = (String)data.get("x-apm-bt.Location")) != null) {
            parameters.put("x-apm-bt.Location", location);
        }
        if ((device = (String)data.get("x-apm-bt.Device")) != null) {
            parameters.put("x-apm-bt.Device", device);
        }
        if ((os = (String)data.get("x-apm-bt.OS Version")) != null) {
            parameters.put("x-apm-bt.OS Version", os);
        }
        if ((connection = (String)data.get("x-apm-bt.Connection")) != null) {
            parameters.put("x-apm-bt.Connection", connection);
        }
        if ((sdk = (String)data.get("x-apm-bt.Identifier Version")) != null) {
            parameters.put("x-apm-bt.Identifier Version", sdk);
        }
        if ((tenant = (String)data.get("x-apm-bt.Tenant")) != null) {
            parameters.put("x-apm-bt.Tenant", tenant);
        }
        if ((appname = (String)data.get("x-apm-bt.Application Name")) != null) {
            parameters.put("x-apm-bt.Application Name", appname);
        }
    }

    @Override
    public void IInvocationDataParameterCallback_addParameters(InvocationData data, Map parameters) {
        if (!data.hasServletSupport()) {
            this.setServletSupport(this.fCharEncoding, this.getAgent(), data);
        }
        HttpServletLazyMap result = (HttpServletLazyMap)data.getServletSupport().servletParametersMap;
        UrlGroupingProvider.checkAndApplyURLTraceParamMasking(result);
        UrlGroupingProvider.checkAndApplyURLQueryTraceParamMasking(result);
        result.putAllParameters(parameters);
        this.addBizDefParameters(data, parameters);
    }

    @Override
    public Map IInvocationDataParameterCallback_addParametersAndReturnMap(InvocationData data, Map parameters) {
        if (!data.hasServletSupport()) {
            this.setServletSupport(this.fCharEncoding, this.getAgent(), data);
        }
        LazyMap result = data.getServletSupport().servletParametersMap;
        UrlGroupingProvider.checkAndApplyURLTraceParamMasking(result);
        UrlGroupingProvider.checkAndApplyURLQueryTraceParamMasking(result);
        if (result == parameters) {
            return result;
        }
        this.addBizDefParameters(data, parameters);
        result.changeMap(parameters);
        return result;
    }

    static void debug_clearUserIDAccessor() {
    }

    @Override
    public boolean canCacheInvocationData() {
        return false;
    }

    public static final class TraceLogConfigurationProperty
    extends StringSetConfigurationProperty {
        private TraceLogConfigurationProperty(String name, String descriptionKey, IModuleFeedbackChannel feedback, Module module, IStringLocalizer localizer, IAgent agent) {
            super(name, descriptionKey, feedback, module, localizer);
        }

        @Override
        public final void set(Object value) {
            try {
                fIsDebugEnabled = AgentShim.getAgent().IAgent_getModuleFeedback().isTraceEnabled();
            }
            catch (AgentNotAvailableException agentNotAvailableException) {}
        }
    }
}

