/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.api.instrument;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.TransformerNotAvailableException;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationFilter;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.api.instrument.ClassInfo;
import com.wily.introscope.api.instrument.DGRuntimeClass;
import com.wily.util.classfile.InvalidClassNameException;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.feedback.Module;
import java.lang.instrument.Instrumentation;
import java.lang.instrument.UnmodifiableClassException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Queue;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.regex.Pattern;

public class ContinuousRetransformer
extends Thread {
    public static Method findLoadedClass = null;
    private Module kModule = new Module("ContinuousRetransformer");
    private static ConcurrentLinkedQueue<ClassInfo> continuousRetransformQ;
    private Queue<Class> retransformQ;
    private HashSet<String> classFilter;
    private IAgent agent;
    private IDynamicInstrumentationTransformer transformer;
    private IDynamicInstrumentationFilter filter;
    private Instrumentation instrumentation;
    private IModuleFeedbackChannel logger;
    private int intervalInSeconds;
    private int batchSize;

    public ContinuousRetransformer(Instrumentation instrumentation, IAgent agent, int intervalInSeconds, int batchSize) throws TransformerNotAvailableException {
        continuousRetransformQ = new ConcurrentLinkedQueue();
        this.retransformQ = new LinkedList<Class>();
        this.classFilter = new HashSet();
        this.agent = agent;
        this.transformer = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer();
        if (this.transformer == null) {
            throw new TransformerNotAvailableException();
        }
        this.filter = agent.IAgent_getTransformerAdministrator().getDynamicInstrumentationTransformer().getDynamicInstrumentationFilter();
        this.instrumentation = instrumentation;
        this.logger = agent.IAgent_getModuleFeedback();
        this.intervalInSeconds = intervalInSeconds;
        this.batchSize = batchSize;
    }

    public static void addClass(String className, ClassLoader loader) {
        continuousRetransformQ.offer(new ClassInfo(className, loader));
    }

    private boolean shouldNotSkipClass(String className) {
        return this.filter.shouldNotSkip(className);
    }

    private boolean shouldRetransform(Class clazz) {
        if (this.filter.isLikelyToChangeIfRetransformed(clazz)) {
            return true;
        }
        try {
            DGRuntimeClass c = new DGRuntimeClass(clazz);
            if (this.transformer.hasTransformationMutations(c)) {
                return true;
            }
        }
        catch (InvalidClassNameException invalidClassNameException) {}
        return false;
    }

    private List<Class> getBootstrapSortedClasses(Class[] classes) {
        ArrayList<Class> bootstrapClasses = new ArrayList<Class>();
        ArrayList<Class> regularClasses = new ArrayList<Class>();
        List priority = this.transformer.getAllBootstrapInstrumentationClasses();
        Class[] classArray = classes;
        int n = classes.length;
        int n2 = 0;
        while (n2 < n) {
            Class clas = classArray[n2];
            if (priority.contains(clas.getName().replace('.', '/'))) {
                bootstrapClasses.add(clas);
            } else {
                regularClasses.add(clas);
            }
            ++n2;
        }
        bootstrapClasses.addAll(regularClasses);
        regularClasses.clear();
        return bootstrapClasses;
    }

    @Override
    public void run() {
        this.logger.info(this.kModule, "Starting Continuous Retransformer");
        this.logger.debug(this.kModule, "Adding loaded classes to one time retransform queue");
        this.retransformQ.addAll(this.getBootstrapSortedClasses(this.instrumentation.getAllLoadedClasses()));
        this.logger.debug(this.kModule, String.valueOf(this.retransformQ.size()) + " previously loaded Classes obtained from instrumentation API");
        Pattern pattern = Pattern.compile("\\$[0-9]");
        int globalCount = 0;
        while (true) {
            Class clazz;
            ClassInfo classInfo;
            try {
                this.logger.debug(this.kModule, "Sleeping for " + this.intervalInSeconds + " seconds");
                ContinuousRetransformer.sleep(this.intervalInSeconds * 1000);
            }
            catch (InterruptedException ie) {
                this.logger.info(this.kModule, "Woken up by Interrupt");
                this.logger.trace(this.kModule, "Stacktrace \n", ie);
            }
            long currentTime = System.nanoTime();
            int count = 0;
            while (count < this.batchSize && (classInfo = continuousRetransformQ.poll()) != null) {
                try {
                    if ((classInfo.className == null || !this.shouldNotSkipClass(classInfo.className)) && (classInfo.className == null || this.classFilter.contains(classInfo.className) || classInfo.className.startsWith("com.wily") || classInfo.loader != null && classInfo.loader.toString().startsWith("com.wily"))) {
                        this.logger.trace(this.kModule, "Class being skipped " + classInfo.className);
                        continue;
                    }
                    if (currentTime - classInfo.timeInNano < 2000000000L) {
                        try {
                            this.logger.debug(this.kModule, "Sleeping 2 seconds before retransforming");
                            ContinuousRetransformer.sleep(2000L);
                            currentTime += 2000000000L;
                        }
                        catch (InterruptedException ie) {
                            this.logger.info(this.kModule, "Woken up by Interrupt while waiting 2 seconds");
                            this.logger.trace(this.kModule, "Stacktrace \n", ie);
                        }
                    }
                    this.logger.trace(this.kModule, "Checking if class " + classInfo.className + " can be retransformed");
                    clazz = classInfo.loader == null ? Class.forName(classInfo.className, false, null) : (Class)findLoadedClass.invoke((Object)classInfo.loader, classInfo.className);
                    if (clazz == null) {
                        this.logger.trace(this.kModule, "Could not get class reference for class name " + classInfo.className + " in loader " + classInfo.loader);
                        continue;
                    }
                    try {
                        if (this.instrumentation.isModifiableClass(clazz) && this.filter.canRedefine(clazz) && this.shouldRetransform(clazz)) {
                            this.logger.trace(this.kModule, "Retransforming class " + classInfo.className);
                            this.instrumentation.retransformClasses(clazz);
                            ++count;
                            continue;
                        }
                        this.logger.trace(this.kModule, "Class didn't qualify " + classInfo.className);
                    }
                    catch (UnmodifiableClassException uce) {
                        this.logger.debug(this.kModule, "Failed to retransform class" + classInfo.className);
                        this.logger.trace(this.kModule, "Stacktrace \n", uce);
                    }
                    catch (InternalError ie) {
                        this.logger.debug(this.kModule, "Failed to retransform class" + classInfo.className);
                        this.logger.trace(this.kModule, "Stacktrace \n", ie);
                    }
                    catch (Throwable t) {
                        this.logger.debug(this.kModule, "Failed to retransform  class" + classInfo.className);
                        this.logger.trace(this.kModule, "Stacktrace \n", t);
                    }
                }
                catch (ClassNotFoundException cnfe) {
                    this.classFilter.add(classInfo.className);
                    this.logger.debug(this.kModule, "Class not found " + classInfo.className);
                    this.logger.trace(this.kModule, "Stacktrace \n", cnfe);
                }
                catch (NoClassDefFoundError ncdfe) {
                    this.classFilter.add(classInfo.className);
                    this.logger.debug(this.kModule, "No Class Def found " + classInfo.className);
                    this.logger.trace(this.kModule, "Stacktrace \n", ncdfe);
                }
                catch (Throwable t) {
                    this.classFilter.add(classInfo.className);
                    this.logger.debug(this.kModule, "Failed to retransform class " + classInfo.className);
                    this.logger.trace(this.kModule, "Stacktrace \n", t);
                }
            }
            while (count < this.batchSize && (clazz = this.retransformQ.poll()) != null) {
                String className = clazz.getName();
                if (!(className != null && this.shouldNotSkipClass(className) || className != null && !pattern.matcher(className).find() && !className.startsWith("com.wily"))) {
                    this.logger.trace(this.kModule, "Already loaded class being skipped " + className);
                    continue;
                }
                this.logger.trace(this.kModule, "Checking if previously loaded class " + className + " can be retransformed");
                try {
                    if (this.instrumentation.isModifiableClass(clazz) && this.filter.canRedefine(clazz) && this.shouldRetransform(clazz)) {
                        this.logger.trace(this.kModule, "Retransforming previously loaded class " + className);
                        this.instrumentation.retransformClasses(clazz);
                        ++count;
                        continue;
                    }
                    this.logger.trace(this.kModule, "Already loaded class did not qualify " + className);
                }
                catch (UnmodifiableClassException uce) {
                    this.logger.debug(this.kModule, "Failed to retransform already loaded class " + className);
                    this.logger.trace(this.kModule, "Stacktrace \n", uce);
                }
                catch (InternalError ie) {
                    this.logger.debug(this.kModule, "Failed to retransform already loaded class " + className);
                    this.logger.trace(this.kModule, "Stacktrace \n", ie);
                }
                catch (Throwable t) {
                    this.logger.debug(this.kModule, "Failed to retransform already loaded class " + className);
                    this.logger.trace(this.kModule, "Stacktrace \n", t);
                }
            }
            this.logger.debug(this.kModule, "Retransformation attempted for " + count + " classes and a total of " + (globalCount += count) + " classes");
            if (count >= this.batchSize || this.intervalInSeconds >= 600) continue;
            this.intervalInSeconds *= 2;
            if (this.intervalInSeconds <= 150) continue;
            this.intervalInSeconds = 150;
        }
    }
}

