/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe.connector;

import com.wily.util.io.ExtendedFile;
import com.wily.util.text.FormattedLocalizableMessage;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.text.SimpleLocalizableMessage;
import com.wily.util.validate.IValidatable;
import com.wily.util.validate.ValidationException;
import com.wily.wilyassert.Assertion;
import java.io.File;
import java.io.IOException;

public class AutoProbeConnectorCreatorEnvironment
implements IValidatable {
    private static final String kJarExtension = ".jar";
    private final IStringLocalizer fStringLocalizer;
    private boolean fShowHelp;
    private boolean fUseCurrentJVM;
    private String fJVMDirectory;
    private String fOutputLocation;

    public AutoProbeConnectorCreatorEnvironment(IStringLocalizer localizer) {
        this.fStringLocalizer = localizer;
        this.fShowHelp = false;
        this.fUseCurrentJVM = false;
        this.fJVMDirectory = null;
    }

    public IStringLocalizer getStringLocalizer() {
        return this.fStringLocalizer;
    }

    public void setShowHelp(boolean showHelp) {
        this.fShowHelp = showHelp;
    }

    public boolean shouldShowHelp() {
        return this.fShowHelp;
    }

    public void setUseCurrentJVM(boolean useCurrentJVM) {
        this.fUseCurrentJVM = useCurrentJVM;
    }

    public boolean useCurrentJVM() {
        return this.fUseCurrentJVM;
    }

    public boolean hasJVMDirectory() {
        return this.fJVMDirectory != null;
    }

    public void setJVMDirectory(String jvmDirectory) {
        this.fJVMDirectory = jvmDirectory;
    }

    public boolean hasOutputLocation() {
        return this.fOutputLocation != null;
    }

    private boolean isOutputFilenameSpecified() {
        return this.hasOutputLocation() && this.fOutputLocation.toLowerCase().endsWith(kJarExtension);
    }

    public void setOutputLocation(String outputLocation) {
        this.fOutputLocation = outputLocation;
    }

    private void throwValidationError(String messageKey) throws ValidationException {
        this.throwValidationError(new SimpleLocalizableMessage(messageKey));
    }

    private void throwValidationError(ILocalizableMessage message) throws ValidationException {
        throw new ValidationException(message);
    }

    @Override
    public void IValidatable_validate(int validationConstraintFlags) throws ValidationException {
        this.IValidatable_validate();
    }

    @Override
    public void IValidatable_validate() throws ValidationException {
        if (!this.hasJVMDirectory() && !this.useCurrentJVM()) {
            this.throwValidationError("Auto_Probe_Connector_Creator_Must_Specify_JVM");
        }
        if (this.hasJVMDirectory() && this.useCurrentJVM()) {
            this.throwValidationError("Auto_Probe_Connector_Creator_Can_Only_Specify_One_JVM");
        }
        this.validateJVMDirectory();
        this.validateOutputLocation();
    }

    private void validateJVMDirectory() throws ValidationException {
        ExtendedFile directory = this.getJVMDirectory();
        if (!directory.exists()) {
            this.throwValidationError(new FormattedLocalizableMessage("Auto_Probe_Connector_Creator_JVM_Directory_Does_Not_Exist", directory.safeGetCanonicalPath()));
        }
        if (!directory.isDirectory()) {
            this.throwValidationError(new FormattedLocalizableMessage("Auto_Probe_Connector_Creator_JVM_Directory_Is_Not_A_Directory", directory.safeGetCanonicalPath()));
        }
    }

    private void validateOutputLocation() throws ValidationException {
        ExtendedFile location;
        ExtendedFile directory = location = this.getOutputLocation();
        if (this.isOutputFilenameSpecified()) {
            directory = new ExtendedFile(ExtendedFile.safeGetCanonicalPath(location.getParentFile()));
        }
        if (!directory.exists()) {
            try {
                directory.makeDirectories();
            }
            catch (IOException iOException) {
                this.throwValidationError(new FormattedLocalizableMessage("Auto_Probe_Connector_Creator_Output_Directory_Cannot_Be_Created", directory.safeGetCanonicalPath()));
            }
        }
        if (!directory.isDirectory()) {
            this.throwValidationError(new FormattedLocalizableMessage("Auto_Probe_Connector_Creator_Output_Directory_Is_Not_A_Directory", directory.safeGetCanonicalPath()));
        }
    }

    public ExtendedFile getJVMDirectory() {
        String jvmDirectoryName = null;
        if (this.useCurrentJVM()) {
            Assertion.wilyAssert(false);
            jvmDirectoryName = System.getProperty("java.home");
        } else {
            Assertion.wilyAssert(false);
            jvmDirectoryName = this.fJVMDirectory;
        }
        return new ExtendedFile(jvmDirectoryName);
    }

    public ExtendedFile getOutputLocation() {
        if (this.hasOutputLocation()) {
            return new ExtendedFile(ExtendedFile.safeGetCanonicalPath(new File(this.fOutputLocation)));
        }
        return new ExtendedFile(ExtendedFile.safeGetCanonicalPath(new File("")));
    }

    public ExtendedFile getOutputFile() throws IOException {
        ExtendedFile result = this.getOutputLocation();
        if (!this.isOutputFilenameSpecified()) {
            result = new ExtendedFile(result, "AutoProbeConnector.jar");
        }
        return result;
    }
}

