/*
 * Decompiled with CFR 0.152.
 */
package com.wily.diagnos.cmp.batch;

import com.wily.diagnos.cmp.DGCompilationFailedException;
import com.wily.diagnos.cmp.batch.DGFileSettings;
import com.wily.diagnos.cmp.batch.IBatchCompiler;
import com.wily.diagnos.cmp.directives.DGCompilerSettings;
import com.wily.diagnos.cmp.log.ICompilerLog;
import com.wily.diagnos.cmp.ui.ICompilerUI;
import com.wily.util.io.StreamCopier;
import com.wily.util.task.IInterruptSource;
import com.wily.wilyassert.Assertion;
import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;

public abstract class ABatchCompiler
implements IBatchCompiler {
    private static final String kFailureOccurredDuringCopyMessage = "Copy requested but unable to comply since original problem occurred during an attempted copy";
    protected static final int NEW_STATE = 0;
    protected static final int RUNNING_STATE = 1;
    protected static final int PAUSED_STATE = 2;
    protected static final int CANCELLED_STATE = 3;
    protected static final int kDefaultBufferSize = 16384;
    private IInterruptSource fInterruptSource;
    private int fEntryIndex;
    protected DGCompilerSettings fSettings;
    protected DGFileSettings fFileSettings;
    protected ICompilerUI fProgressUI;
    protected ICompilerLog fLog;
    protected String fPackageName;
    protected int fItemCount;

    protected ABatchCompiler(DGCompilerSettings settings, DGFileSettings fileSettings, ICompilerUI ui, ICompilerLog log) {
        Assertion.wilyAssert((log != null ? 1 : 0) != 0);
        this.fSettings = settings;
        this.fFileSettings = fileSettings;
        this.fProgressUI = ui;
        this.fLog = log;
        this.fInterruptSource = null;
    }

    @Override
    public ICompilerLog getLog() {
        return this.fLog;
    }

    @Override
    public void setInterruptSource(IInterruptSource interruptSource) {
        this.fInterruptSource = interruptSource;
    }

    @Override
    public IInterruptSource getInterruptSource() {
        return this.fInterruptSource;
    }

    protected void prepare(String packageName, int itemCount) {
        this.fPackageName = packageName;
        this.fItemCount = itemCount;
    }

    protected void skipFile(String filename) {
        this.fLog.ICompilerLog_setSkippedFile(filename);
    }

    protected void fileCopy(File source, File dest) throws DGCompilationFailedException, IOException {
        BufferedInputStream in = new BufferedInputStream(new FileInputStream(source), 16384);
        try {
            this.copyToFile(source.getPath(), in, dest);
        }
        catch (Throwable throwable) {
            try {
                ((InputStream)in).close();
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            ((InputStream)in).close();
        }
        catch (IOException iOException) {}
    }

    protected void copyToFile(String path, InputStream input, File outFile) throws DGCompilationFailedException, IOException {
        OutputStream output = null;
        try {
            File parent = outFile.getParentFile();
            if (parent != null) {
                parent.mkdirs();
            }
            output = new FileOutputStream(outFile);
            this.copyFile(input, output, path);
        }
        catch (Throwable throwable) {
            try {
                if (output != null) {
                    output.close();
                }
            }
            catch (IOException iOException) {}
            throw throwable;
        }
        try {
            if (output != null) {
                output.close();
            }
        }
        catch (IOException iOException) {}
    }

    protected void copyFile(InputStream input, OutputStream output, String filename) throws DGCompilationFailedException {
        try {
            try {
                this.fLog.ICompilerLog_setCopiedFile(filename);
                StreamCopier.copy((InputStream)input, (OutputStream)output);
            }
            catch (IOException ioe) {
                this.logException(filename, ioe);
                if (this.fProgressUI != null) {
                    this.fProgressUI.ICompilerUI_handleExceptionCopyingFile(filename, ioe);
                }
                throw new DGCompilationFailedException(12);
            }
        }
        catch (DGCompilationFailedException dgcfe) {
            switch (dgcfe.getOption()) {
                case 11: {
                    this.skipFile(filename);
                    break;
                }
                case 10: {
                    this.logMessage(kFailureOccurredDuringCopyMessage);
                    break;
                }
                case 12: {
                    throw dgcfe;
                }
                default: {
                    throw new DGCompilationFailedException(12);
                }
            }
        }
    }

    protected void logMessage(String message) {
        this.fLog.ICompilerLog_logMessage(message);
    }

    protected void logTitleMessage(String title) {
        this.fLog.ICompilerLog_logTitleMessage(title);
    }

    protected void logErrorMessage(String title) {
        this.fLog.ICompilerLog_logErrorMessage(title);
    }

    protected void logException(Exception e) {
        this.fLog.ICompilerLog_logException(e);
    }

    protected void logException(String classFileName, Exception e) {
        this.fLog.ICompilerLog_logException(classFileName, e);
    }

    protected void updateStatusBar(String fileName) {
        if (this.fProgressUI != null) {
            this.fProgressUI.ICompilerUI_updateStatusBar(fileName, this.fEntryIndex++ % this.fItemCount);
        }
    }

    protected void setupUI() {
        if (this.fProgressUI != null) {
            this.fProgressUI.ICompilerUI_setup(this.fPackageName, this.fItemCount);
        }
    }

    protected void finishUI() {
        if (this.fProgressUI != null) {
            this.fProgressUI.ICompilerUI_close();
        }
    }

    @Override
    public void compileAll() throws DGCompilationFailedException {
        try {
            try {
                this.setupUI();
                this.compileClassFiles();
                this.close();
            }
            catch (IOException ioe) {
                this.logException(this.fPackageName, ioe);
                if (this.fProgressUI != null) {
                    this.fProgressUI.ICompilerUI_handleExceptionCopyingFile(this.fPackageName, ioe);
                }
                throw new DGCompilationFailedException(12);
            }
        }
        finally {
            this.finishUI();
        }
    }

    protected boolean isClassFile(File file) {
        return this.isClassFile(file.getName());
    }

    protected boolean isClassFile(String filename) {
        return filename.toLowerCase().endsWith(".class");
    }

    protected boolean isArchiveFile(File file) {
        return this.isArchiveFile(file.getName());
    }

    protected boolean isArchiveFile(String filename) {
        return this.isJarFile(filename) || this.isZipFile(filename);
    }

    protected boolean isJarFile(File file) {
        return this.isJarFile(file.getName());
    }

    protected boolean isJarFile(String filename) {
        return filename.toLowerCase().endsWith(".jar") || filename.toLowerCase().endsWith(".war") || filename.toLowerCase().endsWith(".ear") || filename.toLowerCase().endsWith(".rar");
    }

    protected boolean isZipFile(File file) {
        return this.isZipFile(file.getName());
    }

    protected boolean isZipFile(String filename) {
        return filename.toLowerCase().endsWith(".zip");
    }

    protected abstract void compileClassFiles() throws DGCompilationFailedException;

    protected void close() throws IOException {
    }

    protected void pauseIfNecessary() {
        if (this.fInterruptSource != null) {
            this.fInterruptSource.IInterruptSource_pauseIfNecessary();
        }
    }

    protected boolean shouldStop() {
        if (this.fInterruptSource != null) {
            return this.fInterruptSource.IInterruptSource_shouldStop();
        }
        return false;
    }

    protected void cancel() {
        if (this.fInterruptSource != null) {
            this.fInterruptSource.IInterruptSource_hasCancelled();
        }
    }

    protected void finished() {
        if (this.fInterruptSource != null) {
            this.fInterruptSource.IInterruptSource_hasFinished();
        }
    }
}

