/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.autoprobe;

import com.wily.introscope.agent.AgentAdapter;
import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.extension.ExtensionAdministrator;
import com.wily.introscope.agent.transformer.ClassFileTransformerShouldNotRunException;
import com.wily.introscope.agent.transformer.ITransformer;
import com.wily.introscope.agent.transformer.dynamic.IDynamicInstrumentationTransformer;
import com.wily.introscope.autoprobe.IAutoProbeConfig;
import com.wily.introscope.autoprobe.ICompilerLogger;
import com.wily.util.extension.ExtensionUtilities;
import com.wily.util.extension.IPlugin;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.Assertion;
import java.lang.instrument.Instrumentation;
import java.lang.reflect.Constructor;
import java.lang.reflect.InvocationTargetException;
import java.util.ArrayList;
import java.util.List;

public class AutoProbeExtensionLoader {
    private static final String kInstrumentPluginType = "instrument";
    private static final Class[] kInstrumentConstructorParameterTypes = new Class[]{IAgent.class, IDynamicInstrumentationTransformer.class, ICompilerLogger.class, IAutoProbeConfig.class, Instrumentation.class};
    private static final Class[] kOldInstrumentConstructorParameterTypes = new Class[]{IAgent.class, IAutoProbeConfig.class, Instrumentation.class};
    private static final Class[] ksmallInstrumentConstructorParameterTypes = new Class[]{IAgent.class, Instrumentation.class};
    private final IAgent fAgent;
    private final ITransformer fAutoProbe;
    private final Object fInstrumentation;

    public AutoProbeExtensionLoader(IAgent agent, ITransformer autoProbe, Object instrumentation) {
        this.fAgent = agent;
        this.fAutoProbe = autoProbe;
        this.fInstrumentation = instrumentation;
    }

    public List loadAllExtensions() {
        ArrayList<Object> result = new ArrayList<Object>();
        ExtensionAdministrator extensionAdministrator = this.fAgent.IAgent_getExtensionAdministrator();
        Assertion.wilyAssert((boolean)false);
        IPlugin[] plugins = extensionAdministrator.getAgentPluginsByType(kInstrumentPluginType);
        int i = 0;
        while (i < plugins.length) {
            result.add(this.loadInstrumentPlugin(plugins[i]));
            ++i;
        }
        return result;
    }

    private final Object loadInstrumentPlugin(IPlugin plugin) {
        Instrumentation instrumentation = (Instrumentation)this.fInstrumentation;
        Class instrumentationPluginClass = ExtensionUtilities.loadEntryPointClass((IModuleFeedbackChannel)this.fAgent.IAgent_getModuleFeedback(), (IStringLocalizer)this.fAgent.IAgent_getStringLocalizer(), (IPlugin)plugin);
        if (instrumentationPluginClass != null) {
            try {
                IStringLocalizer localizer = plugin.IPlugin_getOwningExtension().IExtension_getStringLocalizer(this.fAgent.IAgent_getStringLocalizer());
                IAgent proxyAgent = AgentAdapter.createAdapter((IAgent)this.fAgent, (IStringLocalizer)localizer);
                try {
                    Constructor constructor = instrumentationPluginClass.getConstructor(kInstrumentConstructorParameterTypes);
                    return constructor.newInstance(proxyAgent, this.fAutoProbe, this.fAutoProbe, this.fAutoProbe, instrumentation);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    try {
                        Constructor constructor = instrumentationPluginClass.getConstructor(kOldInstrumentConstructorParameterTypes);
                        return constructor.newInstance(proxyAgent, this.fAutoProbe, instrumentation);
                    }
                    catch (NoSuchMethodException noSuchMethodException2) {
                        Constructor constructor = instrumentationPluginClass.getConstructor(ksmallInstrumentConstructorParameterTypes);
                        return constructor.newInstance(proxyAgent, instrumentation);
                    }
                }
            }
            catch (InvocationTargetException ite) {
                Throwable target = ite.getTargetException();
                if (target instanceof ClassFileTransformerShouldNotRunException) {
                    this.fAgent.IAgent_getModuleFeedback().debug(target);
                } else {
                    this.fAgent.IAgent_getModuleFeedback().error(this.fAgent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Instance_Creation_Error", instrumentationPluginClass.getName()));
                    this.fAgent.IAgent_getModuleFeedback().verbose(target);
                }
            }
            catch (NoSuchMethodException noSuchMethodException) {
                this.fAgent.IAgent_getModuleFeedback().error(this.fAgent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", instrumentationPluginClass.getName()));
            }
            catch (SecurityException securityException) {
                this.fAgent.IAgent_getModuleFeedback().error(this.fAgent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Invalid_Constructor_Error", instrumentationPluginClass.getName()));
            }
            catch (Throwable t) {
                this.fAgent.IAgent_getModuleFeedback().error(this.fAgent.IAgent_getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("Agent_Extension_Dynamic_Class_Instance_Creation_Error", instrumentationPluginClass.getName()));
                this.fAgent.IAgent_getModuleFeedback().verbose(t);
            }
        }
        return null;
    }
}

