/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui;

import com.wily.properties.KUICommonStringsKeys;
import com.wily.ui.MessagePane;
import com.wily.ui.swing.ExtendedJScrollPane;
import com.wily.ui.swing.layout.SimpleVerticalLayout;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.wilyassert.SwingAssertion;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ContainerListener;
import javax.swing.BoxLayout;
import javax.swing.JLabel;
import javax.swing.JPanel;

public class MultiMessagePane
extends JPanel
implements KUICommonStringsKeys {
    private static final long serialVersionUID = -3733962822303114546L;
    private IStringLocalizer fStringLocalizer;
    private ILocalizableMessage fPluralMessageTypeName;
    private int fMaxNumMessages;
    private ILocalizableMessage fOverflowMessage;
    private JLabel fStatusMessageLabel;
    private int fTotalMessagesSeen;
    private JPanel fMessagesPane;
    private boolean fOverflowMessageDisplayed;
    private static final int kMultiMessagePanePreferredWidth = 640;
    private static final int kMultiMessagePanePreferredHeight = 100;
    private static final int kMultiMessagePaneMinimumWidth = 320;
    private static final int kMultiMessagePaneMinimumHeight = 50;
    private static final int kInterMessageWhiteSace = 8;

    public MultiMessagePane(IStringLocalizer stringLocalizer, ILocalizableMessage singularMessageTypeName, ILocalizableMessage pluralMessageTypeName) {
        this(stringLocalizer, singularMessageTypeName, pluralMessageTypeName, -1, null);
    }

    public MultiMessagePane(IStringLocalizer stringLocalizer, ILocalizableMessage singularMessageTypeName, ILocalizableMessage pluralMessageTypeName, int maxNumMessages, ILocalizableMessage overflowMessage) {
        this.fStringLocalizer = stringLocalizer;
        this.fPluralMessageTypeName = pluralMessageTypeName;
        this.fMaxNumMessages = maxNumMessages;
        this.fOverflowMessage = overflowMessage;
        this.fOverflowMessageDisplayed = false;
        this.fTotalMessagesSeen = 0;
        this.initUI();
    }

    private void initUI() {
        this.setLayout(new BoxLayout(this, 1));
        this.fMessagesPane = new JPanel();
        this.fMessagesPane.setLayout(new SimpleVerticalLayout(0, 8));
        this.setPreferredSize(new Dimension(640, 100));
        this.setMinimumSize(new Dimension(320, 50));
        this.add(new ExtendedJScrollPane(this.fMessagesPane));
        this.fStatusMessageLabel = new JLabel(this.getStringLocalizer().IStringLocalizer_getFormattedLocalizedString("FormattedMultiMessagePaneNoMessagesDisplayedString", this.fPluralMessageTypeName.ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer())));
        this.add(this.fStatusMessageLabel);
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fStringLocalizer;
    }

    public void flushMessages() {
        this.fMessagesPane.removeAll();
        this.fOverflowMessageDisplayed = false;
        this.fTotalMessagesSeen = 0;
        IStringLocalizer local = this.getStringLocalizer();
        this.fStatusMessageLabel.setText(local.IStringLocalizer_getFormattedLocalizedString("FormattedMultiMessagePaneNoMessagesDisplayedString", this.fPluralMessageTypeName.ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer())));
        this.revalidate();
        this.repaint();
    }

    public void addMessage(ILocalizableMessage message, int messageType) {
        SwingAssertion.assertSwingSafe();
        if (this.hasMessageLimit() && this.getNumMessages() == this.getMaxNumMessages()) {
            this.removeLastMessagePane();
            this.ensureOverflowMessageDisplayed();
        }
        this.fMessagesPane.add((Component)new MessagePane(message.ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer()), messageType), 0);
        ++this.fTotalMessagesSeen;
        this.updateStatusMessage();
        this.revalidate();
    }

    public void addMessagePaneContainerListener(ContainerListener listener) {
        this.fMessagesPane.addContainerListener(listener);
    }

    public void removeMessagePaneContainerListener(ContainerListener listener) {
        this.fMessagesPane.removeContainerListener(listener);
    }

    public int getNumMessages() {
        return this.overflowMessageDisplayed() ? this.fMessagesPane.getComponentCount() - 1 : this.fMessagesPane.getComponentCount();
    }

    private void updateStatusMessage() {
        IStringLocalizer local = this.getStringLocalizer();
        this.fStatusMessageLabel.setText(local.IStringLocalizer_getFormattedLocalizedString("FormattedMultiMessagePaneNumMessagesDisplayedString", Integer.toString(this.getNumMessages()), Integer.toString(this.fTotalMessagesSeen), this.fPluralMessageTypeName.ILocalizableMessage_getLocalizedMessage(local)));
    }

    private boolean hasMessageLimit() {
        return this.fMaxNumMessages != -1;
    }

    private int getMaxNumMessages() {
        return this.fMaxNumMessages;
    }

    private void removeLastMessagePane() {
        int lastMessageIndex = this.overflowMessageDisplayed() ? this.fMessagesPane.getComponentCount() - 2 : this.fMessagesPane.getComponentCount() - 1;
        this.fMessagesPane.remove(lastMessageIndex);
    }

    private boolean overflowMessageDisplayed() {
        return this.fOverflowMessageDisplayed;
    }

    private void ensureOverflowMessageDisplayed() {
        if (!this.overflowMessageDisplayed()) {
            this.fMessagesPane.add(new MessagePane(this.fOverflowMessage.ILocalizableMessage_getLocalizedMessage(this.getStringLocalizer()), 1));
            this.fOverflowMessageDisplayed = true;
        }
    }
}

