/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.action;

import com.wily.ui.action.AOneWayExtendedAction;
import com.wily.ui.action.ExtendedActionException;
import com.wily.util.text.ILocalizableMessage;
import com.wily.util.text.IStringLocalizer;
import com.wily.util.validate.IValidatable;
import com.wily.util.validate.KValidationConstants;
import com.wily.util.validate.ValidationException;
import java.awt.event.ActionEvent;

public class ValidateAction
extends AOneWayExtendedAction
implements KValidationConstants {
    private static final long serialVersionUID = -3107991172172784887L;
    private final IStringLocalizer fStringLocalizer;
    private final IValidatable fValidatable;
    private final int fValidationConstraints;
    private final ILocalizableMessage fUserMessagePrefix;

    public ValidateAction(IStringLocalizer stringLocalizer, IValidatable validatable) {
        this(stringLocalizer, null, validatable, 0, null);
    }

    public ValidateAction(IStringLocalizer stringLocalizer, IValidatable validatable, ILocalizableMessage userMessagePrefix) {
        this(stringLocalizer, null, validatable, 0, userMessagePrefix);
    }

    public ValidateAction(IStringLocalizer stringLocalizer, String actionName, IValidatable validatable) {
        this(stringLocalizer, actionName, validatable, 0, null);
    }

    public ValidateAction(IStringLocalizer stringLocalizer, String actionName, IValidatable validatable, ILocalizableMessage userMessagePrefix) {
        this(stringLocalizer, actionName, validatable, 0, userMessagePrefix);
    }

    public ValidateAction(IStringLocalizer stringLocalizer, String actionName, IValidatable validatable, int validationConstraints) {
        this(stringLocalizer, actionName, validatable, validationConstraints, null);
    }

    public ValidateAction(IStringLocalizer stringLocalizer, String actionName, IValidatable validatable, int validationConstraints, ILocalizableMessage userMessagePrefix) {
        super(actionName);
        this.fStringLocalizer = stringLocalizer;
        this.fValidatable = validatable;
        this.fValidationConstraints = validationConstraints;
        this.fUserMessagePrefix = userMessagePrefix;
    }

    private IStringLocalizer getStringLocalizer() {
        return this.fStringLocalizer;
    }

    public void doTriggerAction(ActionEvent actionEvent) throws ExtendedActionException {
        this.setCancelled(false);
        try {
            this.fValidatable.IValidatable_validate(this.fValidationConstraints);
        }
        catch (ValidationException ve) {
            this.transformException(ve);
        }
    }

    private void transformException(ValidationException ve) throws ExtendedActionException {
        if (this.fUserMessagePrefix != null) {
            ve = new ValidationException(this.fUserMessagePrefix, ve.getRequiredCondition());
        }
        this.throwExtendedActionExceptionFromGenericException(this.getStringLocalizer(), ve);
    }
}

