/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.dnd;

import com.wily.ui.IGenericServices;
import com.wily.ui.datatransfer.KDataTransferConstants;
import com.wily.ui.dnd.DropTargetDispatchListener;
import com.wily.ui.dnd.IExtendedDropTargetConspirator;
import com.wily.util.feedback.IModuleFeedbackChannel;
import java.awt.Component;
import java.awt.dnd.DropTarget;
import java.util.TooManyListenersException;

public class ExtendedDropTarget
extends DropTarget
implements KDataTransferConstants {
    private static final long serialVersionUID = -566461979554807642L;
    private IGenericServices fGenericServices;
    private IExtendedDropTargetConspirator fExtendedDropTargetConspirator;
    private boolean fEnabled;

    public ExtendedDropTarget(IGenericServices genericServices, Component c) {
        this(genericServices, c, null);
    }

    public ExtendedDropTarget(IGenericServices genericServices, Component c, IExtendedDropTargetConspirator extendedDropTargetConspirator) {
        this.fGenericServices = genericServices;
        this.setComponent(c);
        this.setDefaultActions(3);
        try {
            this.addDropTargetListener(new DropTargetDispatchListener(this.getGenericServices()));
        }
        catch (TooManyListenersException e) {
            this.getModuleFeedback().error("unexpected exception - Drop target inactive: " + e.getMessage());
        }
        this.fExtendedDropTargetConspirator = extendedDropTargetConspirator;
        this.fEnabled = true;
    }

    private IGenericServices getGenericServices() {
        return this.fGenericServices;
    }

    private IModuleFeedbackChannel getModuleFeedback() {
        return this.getGenericServices().IGenericServices_getModuleFeedback();
    }

    public void setEnabled(boolean enabled) {
        this.fEnabled = enabled;
    }

    public boolean enabled() {
        return this.fEnabled;
    }

    public IExtendedDropTargetConspirator getExtendedDropTargetConspirator() {
        return this.fExtendedDropTargetConspirator;
    }

    public String toString() {
        return "ExtendedDropTarget: enabled: " + this.enabled() + " comp: " + this.getComponent();
    }
}

