/*
 * Decompiled with CFR 0.152.
 */
package com.wily.ui.swing;

import com.wily.ui.swing.KSwingPropertyNames;
import com.wily.wilyassert.Assertion;
import java.awt.Component;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import javax.swing.Action;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenu;
import javax.swing.JMenuItem;
import javax.swing.JPopupMenu;

public class ExtendedJMenu
extends JMenu
implements KSwingPropertyNames {
    private static final long serialVersionUID = -5255218342221864980L;
    public static JPopupMenu gDummyMenu = new JPopupMenu();
    private PropertyChangePropogator fPropertyChangePropogator;
    private boolean fSetStateBasedOnComponents = true;

    public ExtendedJMenu() {
        this.init();
    }

    public ExtendedJMenu(String s) {
        super(s);
        this.init();
    }

    public ExtendedJMenu(String s, boolean setStateBasedOnComponents) {
        super(s);
        this.fSetStateBasedOnComponents = setStateBasedOnComponents;
        this.init();
    }

    public ExtendedJMenu(String s, boolean b, boolean setStateBasedOnComponents) {
        super(s, b);
        this.fSetStateBasedOnComponents = setStateBasedOnComponents;
        this.init();
    }

    private void init() {
        this.fPropertyChangePropogator = new PropertyChangePropogator();
        if (this.fSetStateBasedOnComponents) {
            this.syncEnabledStateBasedOnComponents();
        }
    }

    public JMenuItem add(Action a) {
        JMenuItem menuItem = super.add(a);
        this.addPropertyChangePropogator(menuItem);
        return menuItem;
    }

    public JMenuItem add(JMenuItem menuItem) {
        this.addPropertyChangePropogator(menuItem);
        return super.add(menuItem);
    }

    public Component add(Component c) {
        this.addPropertyChangePropogator(c);
        return super.add(c);
    }

    public Component add(Component c, int index) {
        this.addPropertyChangePropogator(c);
        return super.add(c, index);
    }

    public JMenuItem add(String s) {
        JMenuItem menuItem = super.add(s);
        this.addPropertyChangePropogator(menuItem);
        return menuItem;
    }

    public void addToggleAction(Action toggleAction, boolean initiallySelected) {
        JCheckBoxMenuItem checkBoxMenuItem = new JCheckBoxMenuItem(toggleAction);
        checkBoxMenuItem.setSelected(initiallySelected);
        checkBoxMenuItem.setHorizontalTextPosition(4);
        checkBoxMenuItem.setVerticalTextPosition(0);
        this.add(checkBoxMenuItem);
    }

    public JMenuItem insert(Action a, int pos) {
        JMenuItem menuItem = super.insert(a, pos);
        this.addPropertyChangePropogator(menuItem);
        return menuItem;
    }

    public JMenuItem insert(JMenuItem mi, int pos) {
        this.addPropertyChangePropogator(mi);
        return super.insert(mi, pos);
    }

    public void insert(String s, int pos) {
        super.insert(s, pos);
        JMenuItem menuItem = this.getItem(pos);
        this.addPropertyChangePropogator(menuItem);
    }

    public void remove(Component c) {
        this.removePropertyChangePropogator(c);
        super.remove(c);
    }

    public void remove(int pos) {
        JMenuItem item = this.getItem(pos);
        if (item != null) {
            this.removePropertyChangePropogator(item);
        }
        super.remove(pos);
    }

    public void remove(JMenuItem item) {
        this.removePropertyChangePropogator(item);
        super.remove(item);
    }

    public void removeAll() {
        this.tearDownExtendedJMenu();
        super.removeAll();
        this.init();
    }

    public void removeAll(boolean tearDownNestedExtendedJMenus) {
        this.tearDownExtendedJMenu(true);
        super.removeAll();
        this.init();
    }

    private void addPropertyChangePropogator(Component c) {
        if (this.fSetStateBasedOnComponents) {
            c.removePropertyChangeListener(this.fPropertyChangePropogator);
            c.addPropertyChangeListener(this.fPropertyChangePropogator);
            this.syncEnabledStateBasedOnComponents();
        }
    }

    private void removePropertyChangePropogator(Component c) {
        if (this.fSetStateBasedOnComponents) {
            c.removePropertyChangeListener(this.fPropertyChangePropogator);
        }
    }

    private synchronized void syncEnabledStateBasedOnComponents() {
        Component[] components = this.getMenuComponents();
        for (int i = 0; i < components.length; ++i) {
            if (!components[i].isEnabled()) continue;
            this.setEnabled(true);
            return;
        }
        this.setEnabled(false);
    }

    public void tearDownExtendedJMenu() {
        this.tearDownExtendedJMenu(false);
    }

    public void tearDownExtendedJMenu(boolean tearDownNestedExtendedJMenus) {
        Component[] components = this.getMenuComponents();
        for (int i = 0; i < components.length; ++i) {
            Component component = components[i];
            this.removePropertyChangePropogator(component);
            if (!tearDownNestedExtendedJMenus || !(component instanceof ExtendedJMenu)) continue;
            ((ExtendedJMenu)component).tearDownExtendedJMenu(true);
        }
        this.fPropertyChangePropogator = null;
        super.removeAll();
        Assertion.wilyAssert(this.getComponentCount() == 0);
    }

    private class PropertyChangePropogator
    implements PropertyChangeListener {
        private PropertyChangePropogator() {
        }

        public void propertyChange(PropertyChangeEvent evt) {
            if (evt.getPropertyName().equals("enabled")) {
                ExtendedJMenu.this.syncEnabledStateBasedOnComponents();
            }
        }
    }
}

