/*
 * Decompiled with CFR 0.152.
 */
package com.wily.introscope.agent.filter;

import com.wily.introscope.agent.IAgent;
import com.wily.introscope.agent.filter.IntervalBasedCountingSampler;
import com.wily.util.feedback.IModuleFeedbackChannel;
import com.wily.util.heartbeat.IRegisteredBehavior;
import com.wily.util.heartbeat.ITimestampedRunnable;
import com.wily.util.properties.hot.ConfigurationManager;
import com.wily.util.properties.hot.PositiveIntegerConfigurationProperty;
import com.wily.util.text.IStringLocalizer;
import java.util.Arrays;
import java.util.Random;
import java.util.concurrent.atomic.AtomicReference;

final class RandomSampler
extends IntervalBasedCountingSampler {
    private final Random fRandom = new Random();
    private final ITimestampedRunnable fSubTimerBehavior = new ITimestampedRunnable(){

        @Override
        public void ITimestampedRunnable_execute(long nowInMillis) {
            RandomSampler.this.onSubTimerExpired();
        }
    };
    private final AtomicReference<IRegisteredBehavior[]> fSubtimers = new AtomicReference<IRegisteredBehavior[]>(new IRegisteredBehavior[0]);

    RandomSampler() {
    }

    @Override
    protected String name() {
        return "random";
    }

    @Override
    public void configure(IAgent agent) {
        ConfigurationManager configManager = agent.IAgent_getConfigurationManager();
        IModuleFeedbackChannel feedback = agent.IAgent_getModuleFeedback();
        IStringLocalizer localizer = agent.IAgent_getStringLocalizer();
        configManager.add(new PositiveIntegerConfigurationProperty("introscope.agent.transactiontracer.sampling.random.perinterval.count", 120, null, null, true, false, feedback, kSamplingModule, localizer){

            @Override
            public void set(Object value) {
                RandomSampler.this.updateSamplesCountPerInterval((Integer)value);
            }

            @Override
            public boolean validate(Object value) {
                if (!super.validate(value)) {
                    return false;
                }
                if (value != null && (Integer)value > 500) {
                    throw new IllegalArgumentException(this.getLocalizer().IStringLocalizer_getLocalizedString("Hot_Property_Invalid_Message"));
                }
                return true;
            }
        });
        configManager.add(new PositiveIntegerConfigurationProperty("introscope.agent.transactiontracer.sampling.random.interval.seconds", 120, null, null, true, false, feedback, kSamplingModule, localizer){

            @Override
            public void set(Object value) {
                RandomSampler.this.updateSamplingDuration((Integer)value);
            }
        });
        super.configure(agent);
    }

    @Override
    protected void cleanup() {
        super.cleanup();
        this.killSubtimers();
    }

    private IRegisteredBehavior[] killSubtimers() {
        IRegisteredBehavior[] timers;
        IRegisteredBehavior[] iRegisteredBehaviorArray = timers = this.fSubtimers.get();
        int n = timers.length;
        int n2 = 0;
        while (n2 < n) {
            IRegisteredBehavior timer = iRegisteredBehaviorArray[n2];
            timer.close();
            ++n2;
        }
        return timers;
    }

    @Override
    protected void onDurationExpired() {
        block0: while (true) {
            this.fCounter.set(0);
            IRegisteredBehavior[] previous = this.killSubtimers();
            int ticksCount = this.fSamplesCountPerInterval;
            int[] ticks = new int[ticksCount];
            int maxValue = this.fDuration * 1000;
            int i = 0;
            while (i < ticksCount) {
                ticks[i] = this.fRandom.nextInt(maxValue);
                ++i;
            }
            Arrays.sort(ticks);
            if (this.fFeedback.isTraceEnabled(kSamplingModule)) {
                this.fFeedback.trace(kSamplingModule, String.valueOf(this.name()) + " sampling strategy generated following sample collection points: " + Arrays.toString(ticks) + " (in ms)");
            }
            IRegisteredBehavior[] subtimers = new IRegisteredBehavior[ticksCount];
            int i2 = 0;
            while (i2 < ticksCount) {
                subtimers[i2] = this.fTimer.addBehavior(this.fSubTimerBehavior, "TT Sampling " + this.name() + " #" + i2, true, ticks[i2], false, 1);
                ++i2;
            }
            if (this.fSubtimers.compareAndSet(previous, subtimers)) {
                return;
            }
            IRegisteredBehavior[] iRegisteredBehaviorArray = subtimers;
            int n = subtimers.length;
            int n2 = 0;
            while (true) {
                if (n2 >= n) continue block0;
                IRegisteredBehavior subtimer = iRegisteredBehaviorArray[n2];
                subtimer.close();
                ++n2;
            }
            break;
        }
    }

    private void onSubTimerExpired() {
        int newValue;
        int existing;
        while (!this.fCounter.compareAndSet(existing, newValue = (existing = this.fCounter.get()) <= 0 ? 1 : existing + 1)) {
        }
    }
}

