/*
 * Decompiled with CFR 0.152.
 */
package com.wily.util.adt;

public final class BidirectionalIntFilter {
    public static final int kFilteredSentinal = -1;
    private int[] fForwardMappings;
    private int[] fReverseMappings;
    private int fSize;
    private int fFilteredSize;

    public BidirectionalIntFilter(int size) {
        this.initialize(size);
    }

    private void initialize(int size) {
        if (size < 0) {
            throw new IllegalArgumentException("Size must be non-negative");
        }
        this.fSize = size;
        this.fFilteredSize = size;
        int initialCapacity = this.fSize == 0 ? 10 : this.fSize;
        this.fForwardMappings = new int[initialCapacity];
        this.fReverseMappings = new int[initialCapacity];
        for (int i = 0; i < this.fSize; ++i) {
            this.fForwardMappings[i] = i;
            this.fReverseMappings[i] = i;
        }
    }

    private void ensureCapacity(int capacity) {
        while (this.fForwardMappings.length < capacity) {
            int[] newForwardMappings = new int[this.fForwardMappings.length * 2];
            System.arraycopy(this.fForwardMappings, 0, newForwardMappings, 0, this.fForwardMappings.length);
            this.fForwardMappings = newForwardMappings;
            int[] newReverseMappings = new int[this.fReverseMappings.length * 2];
            System.arraycopy(this.fReverseMappings, 0, newReverseMappings, 0, this.fReverseMappings.length);
            this.fReverseMappings = newReverseMappings;
        }
    }

    public void setSize(int size) {
        this.initialize(size);
    }

    public int getSize() {
        return this.fSize;
    }

    public int getFilteredSize() {
        return this.fFilteredSize;
    }

    public void insert(int index) {
        if (index < 0 || index > this.fSize) {
            throw new IllegalArgumentException("index of " + index + " is outside the range [0," + this.fSize + "]");
        }
        this.ensureCapacity(this.fSize + 1);
        if (this.fSize - index > 0) {
            System.arraycopy(this.fForwardMappings, index, this.fForwardMappings, index + 1, this.fSize - index);
        }
        this.fForwardMappings[index] = -1;
        for (int i = 0; i < this.fFilteredSize; ++i) {
            if (this.fReverseMappings[i] < index) continue;
            int n = i;
            this.fReverseMappings[n] = this.fReverseMappings[n] + 1;
        }
        ++this.fSize;
    }

    public void remove(int index) {
        if (index < 0 || index >= this.fSize) {
            throw new IllegalArgumentException("index of " + index + " is outside the range [0," + this.fSize + ")");
        }
        this.hide(index);
        --this.fSize;
        if (this.fSize - index > 0) {
            System.arraycopy(this.fForwardMappings, index + 1, this.fForwardMappings, index, this.fSize - index);
        }
        for (int i = 0; i < this.fFilteredSize; ++i) {
            if (this.fReverseMappings[i] < index) continue;
            int n = i;
            this.fReverseMappings[n] = this.fReverseMappings[n] - 1;
        }
    }

    public void move(int oldIndex, int newIndex) {
        if (oldIndex < 0 || oldIndex >= this.fSize) {
            throw new IllegalArgumentException("old index of " + oldIndex + " is outside the range [0," + this.fSize + ")");
        }
        if (newIndex < 0 || newIndex >= this.fSize) {
            throw new IllegalArgumentException("new index of " + newIndex + " is outside the range [0," + this.fSize + ")");
        }
        int oldTarget = this.fForwardMappings[oldIndex];
        int newTarget = this.fForwardMappings[newIndex];
        if (oldTarget == -1 && newTarget != -1) {
            this.show(oldIndex);
            this.hide(newIndex);
        } else if (oldTarget != -1 && newTarget == -1) {
            this.hide(oldIndex);
            this.show(newIndex);
        }
    }

    public void hide(int index) {
        if (index < 0 || index >= this.fSize) {
            throw new IllegalArgumentException("index of " + index + " is outside the range [0," + this.fSize + ")");
        }
        int oldTarget = this.fForwardMappings[index];
        if (oldTarget != -1) {
            this.fForwardMappings[index] = -1;
            for (int i = index + 1; i < this.fSize; ++i) {
                if (this.fForwardMappings[i] == -1) continue;
                int n = i;
                this.fForwardMappings[n] = this.fForwardMappings[n] - 1;
            }
            --this.fFilteredSize;
            if (this.fFilteredSize - oldTarget > 0) {
                System.arraycopy(this.fReverseMappings, oldTarget + 1, this.fReverseMappings, oldTarget, this.fFilteredSize - oldTarget);
            }
        }
    }

    private int findInsertionTarget(int index) {
        for (int i = index; i >= 0; --i) {
            if (this.fForwardMappings[i] == -1) continue;
            return this.fForwardMappings[i] + 1;
        }
        return 0;
    }

    public void show(int index) {
        if (index < 0 || index >= this.fSize) {
            throw new IllegalArgumentException("index of " + index + " is outside the range [0," + this.fSize + ")");
        }
        if (this.fForwardMappings[index] == -1) {
            int newTarget;
            this.fForwardMappings[index] = newTarget = this.findInsertionTarget(index);
            for (int i = index + 1; i < this.fSize; ++i) {
                if (this.fForwardMappings[i] == -1) continue;
                int n = i;
                this.fForwardMappings[n] = this.fForwardMappings[n] + 1;
            }
            if (this.fFilteredSize - newTarget > 0) {
                System.arraycopy(this.fReverseMappings, newTarget, this.fReverseMappings, newTarget + 1, this.fFilteredSize - newTarget);
            }
            this.fReverseMappings[newTarget] = index;
            ++this.fFilteredSize;
        }
    }

    public int mapIndex(int srcIndex) {
        if (srcIndex < 0 || srcIndex >= this.fSize) {
            throw new IllegalArgumentException("index of " + srcIndex + " is outside the range [0," + this.fSize + ")");
        }
        return this.fForwardMappings[srcIndex];
    }

    public int reverseMapIndex(int destIndex) {
        if (destIndex < 0 || destIndex >= this.fFilteredSize) {
            throw new IllegalArgumentException("index of " + destIndex + " is outside the range [0," + this.fFilteredSize + ")");
        }
        return this.fReverseMappings[destIndex];
    }

    public Object clone() {
        BidirectionalIntFilter clone = new BidirectionalIntFilter(this.fSize);
        clone.fForwardMappings = (int[])this.fForwardMappings.clone();
        clone.fReverseMappings = (int[])this.fReverseMappings.clone();
        clone.fFilteredSize = this.fFilteredSize;
        return clone;
    }
}

